/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.neoforge.networking;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.math.Transformation;
import com.refinedmods.refinedstorage.common.networking.CableConnections;
import com.refinedmods.refinedstorage.common.support.direction.BiDirection;
import com.refinedmods.refinedstorage.neoforge.support.render.ModelProperties;
import com.refinedmods.refinedstorage.neoforge.support.render.RotationTranslationModelBaker;
import com.refinedmods.refinedstorage.neoforge.support.render.TransformationBuilder;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.BakedModelWrapper;
import net.neoforged.neoforge.client.model.data.ModelData;

class CableBakedModel
extends BakedModelWrapper<BakedModel> {
    private final LoadingCache<CacheKey, List<BakedQuad>> cache;
    private final RotationTranslationModelBaker extensionBaker;

    CableBakedModel(BakedModel core, RotationTranslationModelBaker extensionBaker) {
        super(core);
        this.extensionBaker = extensionBaker;
        this.cache = CacheBuilder.newBuilder().build(CacheLoader.from(cacheKey -> {
            RandomSource rand = RandomSource.create();
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>(super.getQuads(null, cacheKey.side, rand, ModelData.EMPTY, null));
            if (cacheKey.connections.north()) {
                this.addExtension(quads, Direction.NORTH, cacheKey.side, rand);
            }
            if (cacheKey.connections.east()) {
                this.addExtension(quads, Direction.EAST, cacheKey.side, rand);
            }
            if (cacheKey.connections.south()) {
                this.addExtension(quads, Direction.SOUTH, cacheKey.side, rand);
            }
            if (cacheKey.connections.west()) {
                this.addExtension(quads, Direction.WEST, cacheKey.side, rand);
            }
            if (cacheKey.connections.up()) {
                this.addExtension(quads, Direction.UP, cacheKey.side, rand);
            }
            if (cacheKey.connections.down()) {
                this.addExtension(quads, Direction.DOWN, cacheKey.side, rand);
            }
            return quads;
        }));
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand, ModelData extraData, @Nullable RenderType renderType) {
        CableConnections connections = (CableConnections)extraData.get(ModelProperties.CABLE_CONNECTIONS);
        if (connections == null) {
            return super.getQuads(state, side, rand, extraData, renderType);
        }
        return (List)this.cache.getUnchecked((Object)new CacheKey(side, connections));
    }

    private void addExtension(List<BakedQuad> quads, Direction direction, @Nullable Direction side, RandomSource randomSource) {
        Transformation transformation = TransformationBuilder.create().rotate(BiDirection.forDirection(direction)).build();
        quads.addAll(this.extensionBaker.bake(transformation, side, randomSource));
    }

    private record CacheKey(@Nullable Direction side, CableConnections connections) {
    }
}

