/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics.base.data.loot;

import it.hurts.sskirillss.relics.config.data.LootConfigData;
import it.hurts.sskirillss.relics.config.data.LootEntryConfigData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootEntry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class LootData {
    private List<LootEntry> entries;

    public LootConfigData toConfigData() {
        return new LootConfigData(this.entries.stream().map(entry -> new LootEntryConfigData(entry.getDimensions(), entry.getBiomes(), entry.getTables(), entry.getWeight())).toList());
    }

    LootData(List<LootEntry> entries) {
        this.entries = entries;
    }

    public static LootDataBuilder builder() {
        return new LootDataBuilder();
    }

    public List<LootEntry> getEntries() {
        return this.entries;
    }

    public void setEntries(List<LootEntry> entries) {
        this.entries = entries;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LootData)) {
            return false;
        }
        LootData other = (LootData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<LootEntry> this$entries = this.getEntries();
        List<LootEntry> other$entries = other.getEntries();
        return !(this$entries == null ? other$entries != null : !((Object)this$entries).equals(other$entries));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LootData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<LootEntry> $entries = this.getEntries();
        result = result * 59 + ($entries == null ? 43 : ((Object)$entries).hashCode());
        return result;
    }

    public String toString() {
        return "LootData(entries=" + String.valueOf(this.getEntries()) + ")";
    }

    public static class LootDataBuilder {
        private List<LootEntry> entries = new ArrayList<LootEntry>();

        public LootDataBuilder entry(LootEntry ... entries) {
            this.entries.addAll(Arrays.asList(entries));
            return this;
        }

        LootDataBuilder() {
        }

        public LootDataBuilder entries(List<LootEntry> entries) {
            this.entries = entries;
            return this;
        }

        public LootData build() {
            return new LootData(this.entries);
        }

        public String toString() {
            return "LootData.LootDataBuilder(entries=" + String.valueOf(this.entries) + ")";
        }
    }
}

