/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.reliquified_ars_nouveau.client.renderer.entities;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import it.hurts.octostudios.reliquified_ars_nouveau.client.renderer.models.entities.BallistarianBowModel;
import it.hurts.octostudios.reliquified_ars_nouveau.entities.BallistarianBowEntity;
import it.hurts.sskirillss.relics.utils.ParticleUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3d;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.util.Color;

public class BallistarianBowRenderer
extends GeoEntityRenderer<BallistarianBowEntity> {
    public BallistarianBowRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (GeoModel)new BallistarianBowModel());
    }

    public void renderRecursively(PoseStack poseStack, BallistarianBowEntity bow, GeoBone bone, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int color) {
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.1f, 0.0f);
        poseStack.mulPose(Axis.XP.rotationDegrees(-Mth.clamp((float)(bow.xRotO + (bow.getXRot() - bow.xRotO) * partialTick), (float)-180.0f, (float)180.0f)));
        poseStack.mulPose(Axis.YP.rotationDegrees(-90.0f));
        if (bone.getName().equals("gem")) {
            super.renderRecursively(poseStack, (Entity)bow, bone, renderType, bufferSource, buffer, isReRender, partialTick, 0xF000F0, packedOverlay, color);
        } else {
            super.renderRecursively(poseStack, (Entity)bow, bone, renderType, bufferSource, buffer, isReRender, partialTick, 0xF000F0, packedOverlay, Color.WHITE.argbInt());
        }
        poseStack.popPose();
    }

    public Color getRenderColor(BallistarianBowEntity bow, float partialTick, int packedLight) {
        ParticleColor color = ParticleColor.defaultParticleColor();
        return Color.ofRGBA((float)color.getRed(), (float)color.getGreen(), (float)color.getBlue(), (float)0.75f);
    }

    public void renderFinal(PoseStack poseStack, BallistarianBowEntity bow, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay, int color) {
        if (model.getBone("bow_top").isEmpty() || model.getBone("gem").isEmpty() || model.getBone("bow_bot").isEmpty() || Minecraft.getInstance().isPaused()) {
            return;
        }
        GeoBone gem = (GeoBone)model.getBone("gem").get();
        float outerAngle = ((float)bow.tickCount + partialTick) % 360.0f;
        gem.setRotX(outerAngle);
        gem.setRotY(outerAngle);
        Vector3d gemPos = gem.getWorldPosition();
        Level level = bow.getCommandSenderWorld();
        if (bow.tickCount % 5 == 0) {
            Vec3 pointSphere = ParticleUtil.pointInSphere().scale((double)0.3f);
            gemPos.add(pointSphere.x, pointSphere.y, pointSphere.z);
            level.addParticle(ParticleUtils.constructSimpleSpark((java.awt.Color)java.awt.Color.MAGENTA, (float)0.2f, (int)20, (float)0.7f), gemPos.x(), gemPos.y(), gemPos.z(), 0.0, 0.0, 0.0);
        }
    }

    public ResourceLocation getTextureLocation(BallistarianBowEntity bow) {
        return ArsNouveau.prefix((String)"textures/item/spellbow.png");
    }
}

