/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.reliquified_ars_nouveau.items.back;

import com.google.common.collect.Lists;
import com.hollingsworth.arsnouveau.common.entity.EntityChimeraProjectile;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.hurts.octostudios.reliquified_ars_nouveau.init.ItemRegistry;
import it.hurts.octostudios.reliquified_ars_nouveau.items.NouveauRelicItem;
import it.hurts.octostudios.reliquified_ars_nouveau.items.base.loot.LootEntries;
import it.hurts.sskirillss.relics.client.models.items.CurioModel;
import it.hurts.sskirillss.relics.init.DataComponentRegistry;
import it.hurts.sskirillss.relics.items.relics.base.IRenderableCurio;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourceData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourcesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.GemColor;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.GemShape;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootEntry;
import it.hurts.sskirillss.relics.items.relics.base.data.style.BeamsData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.StyleData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.TooltipData;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.ParticleUtils;
import java.awt.Color;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.client.ICurioRenderer;

public class SpikedCloakItem
extends NouveauRelicItem
implements IRenderableCurio {
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"spikes").stat(StatData.builder((String)"threshold").initialValue(0.1, 0.3).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.1).formatValue(value -> (int)MathUtils.round((double)(value * 100.0), (int)0)).build()).stat(StatData.builder((String)"damage").initialValue(2.0, 5.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.2).formatValue(value -> (int)MathUtils.round((double)value, (int)0)).build()).stat(StatData.builder((String)"time").initialValue(8.0, 12.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.15).formatValue(value -> (int)MathUtils.round((double)value, (int)0)).build()).build()).build()).leveling(LevelingData.builder().initialCost(100).maxLevel(10).step(100).sources(LevelingSourcesData.builder().source(LevelingSourceData.abilityBuilder((String)"spikes").initialValue(1).gem(GemShape.SQUARE, GemColor.YELLOW).build()).build()).build()).style(StyleData.builder().tooltip(TooltipData.builder().borderTop(-8039364).borderBottom(-8039364).textured(true).build()).beams(BeamsData.builder().startColor(-3256784).endColor(8851774).build()).build()).loot(LootData.builder().entry(new LootEntry[]{LootEntries.ARS_NOUVEAU, LootEntries.ARS_NOUVEAU_LIKE}).build()).build();
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        Player player;
        LivingEntity livingEntity = slotContext.entity();
        if (!(livingEntity instanceof Player) || (player = (Player)livingEntity).getCommandSenderWorld().isClientSide() || !this.isAbilityUnlocked(stack, "spikes")) {
            return;
        }
        if (this.getTime(stack) > 0) {
            this.consumeTime(stack, 1);
        }
        if (this.getTime(stack) <= 0) {
            this.setCount(stack, 1);
        }
        if (this.getCharges(stack) >= this.getActualActivatedHP(player, stack)) {
            ServerLevel level = (ServerLevel)player.getCommandSenderWorld();
            RandomSource random = player.getRandom();
            for (int i = 0; i < 35; ++i) {
                float modifier = 0.5f;
                EntityChimeraProjectile spike = new EntityChimeraProjectile((Level)level);
                spike.setPos(player.getX(), player.getY(), player.getZ());
                spike.setOwner((Entity)player);
                spike.setDeltaMovement((double)(MathUtils.randomFloat((RandomSource)random) * modifier), (double)(random.nextFloat() * modifier + 0.25f), (double)(MathUtils.randomFloat((RandomSource)random) * modifier));
                level.addFreshEntity((Entity)spike);
            }
            this.spreadRelicExperience((LivingEntity)player, stack, 1);
            this.setCharges(stack, 0);
            this.setTime(stack, (int)MathUtils.round((double)this.getStatValue(stack, "spikes", "time"), (int)0) * 20);
            if (this.getTime(stack) > 0) {
                this.addCount(stack, 1);
                player.getCommandSenderWorld().playSound(null, (Entity)player, SoundEvents.CAMEL_SADDLE, SoundSource.PLAYERS, 1.0f, 0.9f + player.getRandom().nextFloat() * 0.2f);
            }
            ((ServerLevel)player.getCommandSenderWorld()).sendParticles(ParticleUtils.constructSimpleSpark((Color)new Color(150 + random.nextInt(100), 100 + random.nextInt(80), 50 + random.nextInt(50)), (float)0.2f, (int)20, (float)0.85f), player.getX(), player.getY(), player.getZ(), 50, 0.5, 1.0, 0.5, 0.1);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public <T extends LivingEntity, M extends EntityModel<T>> void render(ItemStack stack, SlotContext slotContext, PoseStack matrixStack, RenderLayerParent<T, M> renderLayerParent, MultiBufferSource renderTypeBuffer, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        CurioModel model = this.getModel(stack);
        matrixStack.pushPose();
        LivingEntity entity = slotContext.entity();
        model.prepareMobModel(entity, limbSwing, limbSwingAmount, partialTicks);
        model.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        ICurioRenderer.followBodyRotations((LivingEntity)entity, (HumanoidModel[])new HumanoidModel[]{model});
        VertexConsumer vertexconsumer = ItemRenderer.getArmorFoilBuffer((MultiBufferSource)renderTypeBuffer, (RenderType)RenderType.entityCutout((ResourceLocation)this.getTexture(stack)), (boolean)stack.hasFoil());
        model.renderToBuffer(matrixStack, vertexconsumer, light, OverlayTexture.NO_OVERLAY);
        matrixStack.popPose();
    }

    @OnlyIn(value=Dist.CLIENT)
    public LayerDefinition constructLayerDefinition() {
        MeshDefinition mesh = HumanoidModel.createMesh((CubeDeformation)new CubeDeformation(0.4f), (float)0.0f);
        PartDefinition partdefinition = mesh.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create(), PartPose.offset((float)-3.0E-4f, (float)0.3556f, (float)0.0307f));
        PartDefinition cube_r1 = body.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(9, 66).addBox(-5.5f, -11.8353f, 2.3134f, 11.0f, 24.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(24, 36).addBox(0.0f, -6.3002f, 2.1205f, 0.0f, 19.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0E-4f, (float)10.132f, (float)3.7627f, (float)0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r2 = body.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(50, 57).addBox(-3.6596f, -9.4247f, 7.7051f, 2.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0E-4f, (float)10.132f, (float)3.7627f, (float)1.0717f, (float)0.0628f, (float)1.0142f));
        PartDefinition cube_r3 = body.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(36, 57).addBox(4.1336f, -8.9426f, 7.7051f, 2.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0E-4f, (float)10.132f, (float)3.7627f, (float)1.0944f, (float)0.0124f, (float)0.0537f));
        PartDefinition cube_r4 = body.addOrReplaceChild("cube_r4", CubeListBuilder.create().texOffs(50, 50).addBox(1.6596f, -9.4247f, 7.7051f, 2.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0E-4f, (float)10.132f, (float)3.7627f, (float)1.0717f, (float)-0.0628f, (float)-1.0142f));
        PartDefinition cube_r5 = body.addOrReplaceChild("cube_r5", CubeListBuilder.create().texOffs(50, 43).addBox(-6.1336f, -8.9426f, 7.7051f, 2.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0E-4f, (float)10.132f, (float)3.7627f, (float)1.0944f, (float)-0.0124f, (float)-0.0537f));
        PartDefinition cube_r6 = body.addOrReplaceChild("cube_r6", CubeListBuilder.create().texOffs(46, 29).addBox(-4.796f, 4.597f, 5.6375f, 2.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0003f, (float)10.132f, (float)3.7627f, (float)-0.2618f, (float)-0.4363f, (float)0.0f));
        PartDefinition cube_r7 = body.addOrReplaceChild("cube_r7", CubeListBuilder.create().texOffs(46, 22).addBox(-4.3378f, 0.3899f, 4.8797f, 2.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0003f, (float)10.132f, (float)3.7627f, (float)0.3038f, (float)-0.762f, (float)-0.2132f));
        PartDefinition cube_r8 = body.addOrReplaceChild("cube_r8", CubeListBuilder.create().texOffs(50, 36).addBox(-3.9929f, -5.1577f, 4.721f, 2.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0003f, (float)10.132f, (float)3.7627f, (float)0.8727f, (float)0.0f, (float)-0.4363f));
        PartDefinition cube_r9 = body.addOrReplaceChild("cube_r9", CubeListBuilder.create().texOffs(36, 50).addBox(1.9929f, -5.1577f, 4.721f, 2.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.9997f, (float)10.132f, (float)3.7627f, (float)0.8727f, (float)0.0f, (float)0.4363f));
        PartDefinition cube_r10 = body.addOrReplaceChild("cube_r10", CubeListBuilder.create().texOffs(36, 43).addBox(2.796f, 4.597f, 5.6375f, 2.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.9997f, (float)10.132f, (float)3.7627f, (float)-0.2618f, (float)0.4363f, (float)0.0f));
        PartDefinition cube_r11 = body.addOrReplaceChild("cube_r11", CubeListBuilder.create().texOffs(36, 36).addBox(2.3378f, 0.3899f, 4.8797f, 2.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.9997f, (float)10.132f, (float)3.7627f, (float)0.3038f, (float)0.762f, (float)0.2132f));
        PartDefinition cube_r12 = body.addOrReplaceChild("cube_r12", CubeListBuilder.create().texOffs(37, 15).addBox(-5.501f, 0.3112f, -2.8444f, 11.0f, 7.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0E-4f, (float)0.2131f, (float)0.3331f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r13 = body.addOrReplaceChild("cube_r13", CubeListBuilder.create().texOffs(34, 0).addBox(-4.5f, -2.2416f, 2.3602f, 9.0f, 8.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0E-4f, (float)-0.0365f, (float)0.3386f, (float)-0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r14 = body.addOrReplaceChild("cube_r14", CubeListBuilder.create().texOffs(9, 0).addBox(-5.5f, -0.5585f, 3.1936f, 11.0f, 24.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(0, 36).addBox(-5.5f, -0.5585f, -2.8064f, 0.0f, 24.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(12, 36).addBox(5.5f, -0.5585f, -2.8064f, 0.0f, 24.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(3, 24).addBox(-5.5f, -0.5585f, -2.8064f, 11.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0E-4f, (float)-0.0365f, (float)0.3386f, (float)0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r15 = body.addOrReplaceChild("cube_r15", CubeListBuilder.create().texOffs(3, 30).addBox(-5.501f, 20.9365f, 11.0185f, 11.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0E-4f, (float)-0.0365f, (float)0.3386f, (float)-0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition left_arm = partdefinition.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(64, 52).mirror().addBox(-2.0f, -2.5f, -2.5f, 5.0f, 7.0f, 5.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)5.751f, (float)2.2082f, (float)0.0538f));
        PartDefinition right_arm = partdefinition.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(64, 52).addBox(-3.0f, -2.5f, -2.5f, 5.0f, 7.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-5.751f, (float)2.2082f, (float)0.0538f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)128, (int)128);
    }

    public List<String> bodyParts() {
        return Lists.newArrayList((Object[])new String[]{"right_arm", "left_arm", "body"});
    }

    public int getActualActivatedHP(Player player, ItemStack stack) {
        return (int)((double)player.getMaxHealth() * (1.0 - this.getStatValue(stack, "spikes", "threshold")));
    }

    public int getCharges(ItemStack stack) {
        return (Integer)stack.getOrDefault((Supplier)DataComponentRegistry.CHARGE, (Object)0);
    }

    public void setCharges(ItemStack stack, int amount) {
        stack.set((Supplier)DataComponentRegistry.CHARGE, (Object)Math.max(amount, 0));
    }

    public void addCharges(ItemStack stack, int amount) {
        this.setCharges(stack, this.getCharges(stack) + amount);
    }

    public int getCount(ItemStack stack) {
        return (Integer)stack.getOrDefault((Supplier)DataComponentRegistry.COUNT, (Object)1);
    }

    public void setCount(ItemStack stack, int amount) {
        stack.set((Supplier)DataComponentRegistry.COUNT, (Object)Math.max(amount, 1));
    }

    public void addCount(ItemStack stack, int amount) {
        this.setCount(stack, this.getCount(stack) + amount);
    }

    public int getTime(ItemStack stack) {
        return (Integer)stack.getOrDefault((Supplier)DataComponentRegistry.TIME, (Object)0);
    }

    public void setTime(ItemStack stack, int amount) {
        stack.set((Supplier)DataComponentRegistry.TIME, (Object)Math.max(amount, 0));
    }

    public void consumeTime(ItemStack stack, int amount) {
        this.setTime(stack, this.getTime(stack) - amount);
    }

    @EventBusSubscriber
    public static class SpikedCloakEvent {
        @SubscribeEvent
        public static void onLivingDeath(LivingDeathEvent event) {
            SpikedCloakItem relic;
            Player player;
            LivingEntity livingEntity = event.getEntity();
            if (!(livingEntity instanceof Player) || (player = (Player)livingEntity).getCommandSenderWorld().isClientSide()) {
                return;
            }
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ItemRegistry.SPIKED_CLOAK.value()));
            Item item = stack.getItem();
            if (!(item instanceof SpikedCloakItem) || !(relic = (SpikedCloakItem)item).isAbilityUnlocked(stack, "spikes")) {
                return;
            }
            relic.setCharges(stack, 0);
        }

        @SubscribeEvent
        public static void onInjuredEntity(LivingDamageEvent.Pre event) {
            SpikedCloakItem relic;
            Player player;
            LivingEntity livingEntity = event.getEntity();
            if (!(livingEntity instanceof Player) || (player = (Player)livingEntity).getCommandSenderWorld().isClientSide()) {
                return;
            }
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ItemRegistry.SPIKED_CLOAK.value()));
            Item item = stack.getItem();
            if (!(item instanceof SpikedCloakItem) || !(relic = (SpikedCloakItem)item).isAbilityUnlocked(stack, "spikes")) {
                return;
            }
            relic.addCharges(stack, (int)event.getNewDamage());
        }
    }
}

