/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.reliquified_twilight_forest.item.relic;

import it.hurts.octostudios.reliquified_twilight_forest.data.loot.LootEntries;
import it.hurts.octostudios.reliquified_twilight_forest.init.DamageTypeRegistry;
import it.hurts.octostudios.reliquified_twilight_forest.init.ItemRegistry;
import it.hurts.octostudios.reliquified_twilight_forest.network.ExecutionEffectPacket;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourceData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourcesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.GemColor;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.GemShape;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootEntry;
import it.hurts.sskirillss.relics.items.relics.base.data.style.BeamsData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.StyleData;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import java.awt.Color;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import twilightforest.entity.passive.TinyBird;
import twilightforest.entity.passive.TinyBirdVariant;
import twilightforest.init.TFEntities;
import twilightforest.init.custom.TinyBirdVariants;

@EventBusSubscriber
public class TwilightFeatherItem
extends RelicItem {
    public static final Map<ResourceKey<TinyBirdVariant>, Color> VARIANTS = Map.of(TinyBirdVariants.RED, new Color(231, 70, 70, 255), TinyBirdVariants.BLUE, new Color(59, 52, 232, 255), TinyBirdVariants.GOLD, new Color(255, 202, 73, 255), TinyBirdVariants.BROWN, new Color(79, 50, 34, 255));
    private static final Object[] keys = VARIANTS.keySet().toArray();

    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"execution").stat(StatData.builder((String)"chance").initialValue(0.005, 0.01).formatValue(value -> MathUtils.round((double)(value * 100.0), (int)1)).upgradeModifier(UpgradeOperation.ADD, 0.004).build()).maxLevel(10).build()).build()).leveling(LevelingData.builder().maxLevel(10).sources(LevelingSourcesData.builder().source(LevelingSourceData.abilityBuilder((String)"execution").gem(GemShape.SQUARE, GemColor.PURPLE).build()).build()).build()).style(StyleData.builder().beams(BeamsData.builder().startColor(-12255375).endColor(990227).build()).build()).loot(LootData.builder().entry(new LootEntry[]{LootEntries.TREE_CACHE}).build()).build();
    }

    @SubscribeEvent
    public static void onDamage(LivingDamageEvent.Pre e) {
        LivingEntity source;
        LivingEntity victim = e.getEntity();
        Entity entity = e.getSource().getEntity();
        if (victim.level().isClientSide || Objects.equals(e.getSource().typeHolder().getKey(), DamageTypeRegistry.EXECUTION) || !(entity instanceof LivingEntity) || (source = (LivingEntity)entity) == victim || victim.getHealth() > source.getMaxHealth()) {
            return;
        }
        for (ItemStack stack : EntityUtils.findEquippedCurios((Entity)source, (Item)((Item)ItemRegistry.TWILIGHT_FEATHER.get()))) {
            Item item = stack.getItem();
            if (!(item instanceof TwilightFeatherItem)) continue;
            TwilightFeatherItem relic = (TwilightFeatherItem)item;
            if (!source.isAlive() || source.getRandom().nextDouble() > relic.getStatValue(stack, "execution", "chance") || !TwilightFeatherItem.hasPerformedExecution(source, victim)) continue;
            e.setNewDamage(0.0f);
            relic.spreadRelicExperience(source, stack, 1);
            break;
        }
    }

    public static boolean hasPerformedExecution(LivingEntity source, LivingEntity victim) {
        if (!victim.hurt(new DamageSource((Holder)victim.level().damageSources().damageTypes.getHolderOrThrow(DamageTypeRegistry.EXECUTION), (Entity)source), 99999.0f)) {
            return false;
        }
        victim.deathTime = 19;
        if (victim instanceof TinyBird) {
            return false;
        }
        TinyBird birb = new TinyBird((EntityType)TFEntities.TINY_BIRD.get(), victim.level());
        ResourceKey variant = (ResourceKey)keys[birb.getRandom().nextInt(keys.length)];
        Color color = VARIANTS.get(variant);
        birb.setVariant(victim.level().registryAccess().holderOrThrow(variant));
        birb.setPos(victim.getEyePosition());
        birb.setDeltaMovement(victim.getDeltaMovement());
        victim.level().addFreshEntity((Entity)birb);
        victim.level().playSound(null, (Entity)birb, SoundEvents.BEACON_DEACTIVATE, SoundSource.NEUTRAL, 1.0f, 0.8f);
        PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)victim, (CustomPacketPayload)new ExecutionEffectPacket(victim.getId(), color), (CustomPacketPayload[])new CustomPacketPayload[0]);
        return true;
    }

    public String getConfigRoute() {
        return "reliquified_twilight_forest";
    }
}

