/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.reliquified_twilight_forest.network;

import it.hurts.octostudios.reliquified_twilight_forest.init.DataComponentRegistry;
import it.hurts.octostudios.reliquified_twilight_forest.init.ItemRegistry;
import it.hurts.octostudios.reliquified_twilight_forest.item.relic.LichCrownItem;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import twilightforest.entity.projectile.TwilightWandBolt;
import twilightforest.init.TFDamageTypes;
import twilightforest.init.TFSounds;

public record LaunchTwilightBoltPacket() implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<LaunchTwilightBoltPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"reliquified_twilight_forest", (String)"launch_twilight_bolt"));
    public static final StreamCodec<RegistryFriendlyByteBuf, LaunchTwilightBoltPacket> STREAM_CODEC = CustomPacketPayload.codec(LaunchTwilightBoltPacket::write, LaunchTwilightBoltPacket::new);

    public LaunchTwilightBoltPacket(RegistryFriendlyByteBuf buf) {
        this();
    }

    public void write(RegistryFriendlyByteBuf buf) {
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(LaunchTwilightBoltPacket packet, IPayloadContext ctx) {
        Player entity = ctx.player();
        switch (ctx.flow()) {
            case SERVERBOUND: {
                ctx.enqueueWork(() -> {
                    LichCrownItem relic;
                    final ItemStack stack = EntityUtils.findEquippedCurio((Entity)entity, (Item)((Item)ItemRegistry.LICH_CROWN.get()));
                    Item patt0$temp = stack.getItem();
                    if (!(patt0$temp instanceof LichCrownItem) || (relic = (LichCrownItem)patt0$temp).getAbilityLevel(stack, "twilight") <= 0 || (Integer)stack.getOrDefault(DataComponentRegistry.TWILIGHT_TIME, (Object)0) > 0) {
                        return;
                    }
                    TwilightWandBolt bolt = new TwilightWandBolt(entity.level(), (LivingEntity)entity){
                        int age;
                        {
                            super(world, thrower);
                            this.age = 200;
                        }

                        public void tick() {
                            super.tick();
                            if (this.level().isClientSide()) {
                                return;
                            }
                            if (this.getAge() < 0) {
                                this.discard();
                            }
                            this.setAge(this.getAge() - 1);
                        }

                        public void addAdditionalSaveData(CompoundTag compound) {
                            super.addAdditionalSaveData(compound);
                            compound.putInt("Age", this.getAge());
                        }

                        public void readAdditionalSaveData(CompoundTag compound) {
                            super.readAdditionalSaveData(compound);
                            this.setAge(compound.getInt("Age"));
                        }

                        protected void onHitEntity(EntityHitResult result) {
                            if (this.level().isClientSide()) {
                                return;
                            }
                            result.getEntity().hurt(TFDamageTypes.getIndirectEntityDamageSource((Level)this.level(), (ResourceKey)TFDamageTypes.TWILIGHT_SCEPTER, (Entity)this, (Entity)this.getOwner(), (EntityType[])new EntityType[0]), (float)relic.getStatValue(stack, "twilight", "damage"));
                            this.level().playSound(null, result.getEntity().blockPosition(), (SoundEvent)TFSounds.TWILIGHT_SCEPTER_HIT.get(), this.getOwner() != null ? this.getOwner().getSoundSource() : SoundSource.PLAYERS);
                            this.level().broadcastEntityEvent((Entity)this, (byte)3);
                            this.discard();
                        }

                        public void setAge(int age) {
                            this.age = age;
                        }

                        public int getAge() {
                            return this.age;
                        }
                    };
                    bolt.getPersistentData().putBoolean("reliquified_twilight_forest:isCustom", true);
                    bolt.setNoGravity(true);
                    bolt.setDeltaMovement(entity.getViewVector(1.0f).scale(relic.getStatValue(stack, "twilight", "speed_scale")));
                    entity.level().addFreshEntity((Entity)bolt);
                    stack.set(DataComponentRegistry.TWILIGHT_TIME, (Object)50);
                    PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)entity), (CustomPacketPayload)new LaunchTwilightBoltPacket(), (CustomPacketPayload[])new CustomPacketPayload[0]);
                });
                break;
            }
            case CLIENTBOUND: {
                ctx.enqueueWork(() -> entity.playSound((SoundEvent)TFSounds.TWILIGHT_SCEPTER_USE.get(), 1.0f, (entity.getRandom().nextFloat() - entity.getRandom().nextFloat()) * 0.2f + 1.0f));
            }
        }
    }
}

