/*
 * Decompiled with CFR 0.152.
 */
package com.chen1335.renderjs.client.renderer;

import com.chen1335.renderjs.API.IGuiRenderHelper;
import com.chen1335.renderjs.API.ILevelRenderHelper;
import com.chen1335.renderjs.API.IRenderJSPoseStackHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.latvian.mods.kubejs.block.entity.KubeBlockEntity;
import dev.latvian.mods.rhino.util.HideFromJS;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class RenderJSBlockEntityRenderer
implements BlockEntityRenderer<BlockEntity> {
    public final BlockEntityRenderDispatcher blockEntityRenderDispatcher;
    public final BlockRenderDispatcher blockRenderDispatcher;
    public final ItemRenderer itemRenderer;
    public final EntityRenderDispatcher entityRenderer;
    public final EntityModelSet modelSet;
    public final Font font;
    private AABB renderBoundingBox = null;
    private int distance = 64;
    private BiPredicate<BlockEntity, Vec3> shouldRenderPredicate = this::defaultShouldRender;
    private BiConsumer<RenderJSBlockEntityRenderer, Context> customRender = (renderer, context) -> {};
    private Predicate<BlockEntity> shouldRenderOffScreen = blockEntity -> false;

    public static RenderJSBlockEntityRenderer create(BlockEntityRendererProvider.Context context) {
        return new RenderJSBlockEntityRenderer(context);
    }

    public RenderJSBlockEntityRenderer(BlockEntityRendererProvider.Context context2) {
        this.blockEntityRenderDispatcher = context2.getBlockEntityRenderDispatcher();
        this.blockRenderDispatcher = context2.getBlockRenderDispatcher();
        this.itemRenderer = context2.getItemRenderer();
        this.entityRenderer = context2.getEntityRenderer();
        this.modelSet = context2.getModelSet();
        this.font = context2.getFont();
    }

    @HideFromJS
    public void render(@NotNull BlockEntity blockEntity, float pPartialTick, @NotNull PoseStack pPoseStack, @NotNull MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay) {
        this.customRender.accept(this, Context.context.update(blockEntity, pPartialTick, pPoseStack, pBufferSource, pPackedLight, pPackedOverlay));
    }

    public boolean shouldRenderOffScreen(@NotNull BlockEntity blockEntity) {
        return this.shouldRenderOffScreen.test(blockEntity);
    }

    public int getViewDistance() {
        return this.distance;
    }

    public boolean shouldRender(@NotNull BlockEntity pBlockEntity, @NotNull Vec3 pCameraPos) {
        return this.shouldRenderPredicate.test(pBlockEntity, pCameraPos);
    }

    public boolean defaultShouldRender(BlockEntity pBlockEntity, Vec3 pCameraPos) {
        return Vec3.atCenterOf((Vec3i)pBlockEntity.getBlockPos()).closerThan((Position)pCameraPos, (double)this.getViewDistance());
    }

    public RenderJSBlockEntityRenderer setCustomRender(BiConsumer<RenderJSBlockEntityRenderer, Context> consumer) {
        this.customRender = consumer;
        return this;
    }

    public RenderJSBlockEntityRenderer setViewDistance(int distance) {
        this.distance = distance;
        return this;
    }

    public RenderJSBlockEntityRenderer setShouldRender(BiPredicate<BlockEntity, Vec3> predicate) {
        this.shouldRenderPredicate = predicate;
        return this;
    }

    public RenderJSBlockEntityRenderer setShouldRenderOffScreen(Predicate<BlockEntity> predicate) {
        this.shouldRenderOffScreen = predicate;
        return this;
    }

    @NotNull
    public AABB getRenderBoundingBox(@NotNull BlockEntity blockEntity) {
        if (this.renderBoundingBox == null) {
            return super.getRenderBoundingBox(blockEntity);
        }
        return this.renderBoundingBox;
    }

    public void setInfiniteRenderBoundingBox() {
        this.renderBoundingBox = AABB.INFINITE;
    }

    public void setRenderBoundingBox(AABB renderBoundingBox) {
        this.renderBoundingBox = renderBoundingBox;
    }

    public static class Context
    implements ILevelRenderHelper,
    IGuiRenderHelper,
    IRenderJSPoseStackHelper {
        public static final Context context = new Context();
        private GuiGraphics guiGraphics = null;
        public BlockEntity blockEntity;
        public KubeBlockEntity blockEntityJS = null;
        public float partialTick;
        public PoseStack poseStack;
        public MultiBufferSource bufferSource;
        public int packedLight;
        public int packedOverlay;

        @HideFromJS
        public Context update(@NotNull BlockEntity pBlockEntity, float pPartialTick, @NotNull PoseStack pPoseStack, @NotNull MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay) {
            if (pBlockEntity instanceof KubeBlockEntity) {
                this.blockEntityJS = (KubeBlockEntity)pBlockEntity;
            }
            this.getGuiGraphics().pose = pPoseStack;
            this.blockEntity = pBlockEntity;
            this.partialTick = pPartialTick;
            this.poseStack = pPoseStack;
            this.bufferSource = pBufferSource;
            this.packedLight = pPackedLight;
            this.packedOverlay = pPackedOverlay;
            return this;
        }

        @Override
        public GuiGraphics getGuiGraphics() {
            if (this.guiGraphics == null) {
                this.guiGraphics = new GuiGraphics(Minecraft.getInstance(), Minecraft.getInstance().renderBuffers().bufferSource());
            }
            return this.guiGraphics;
        }

        @Override
        public PoseStack getPoseStack() {
            return this.poseStack;
        }
    }
}

