/*
 * Decompiled with CFR 0.152.
 */
package net.unfamily.repae2bridge.events;

import com.buuz135.replication.ReplicationRegistry;
import com.buuz135.replication.api.IMatterType;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;
import net.unfamily.repae2bridge.Config;
import net.unfamily.repae2bridge.block.entity.RepAE2BridgeBlockEntity;
import net.unfamily.repae2bridge.data.ReplicationBridgeLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventBusSubscriber
public class ServerLifecycleEventHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerLifecycleEventHandler.class);
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final long THROTTLE_INTERVAL_TICKS = 300L;
    private static int serverStoppingLogsHidden = 0;
    private static int serverStartingLogsHidden = 0;
    private static final Map<Item, IMatterType> customItemToMatterMap = new HashMap<Item, IMatterType>();
    private static final Map<IMatterType, Item> customMatterToItemMap = new HashMap<IMatterType, Item>();
    private static final Set<Item> customVirtualMatterItems = new HashSet<Item>();
    private static boolean customAssociationsLoaded = false;

    @SubscribeEvent
    public static void onServerStopping(ServerStoppingEvent event) {
        try {
            RepAE2BridgeBlockEntity.setWorldUnloading(true);
            RepAE2BridgeBlockEntity.cancelAllPendingOperations();
            if ((long)serverStoppingLogsHidden == 300L) {
                LOGGER.warn("RepAE2Bridge - Server Stopping: Server stopping detected - emergency cleanup (+ {} similar events hidden in last 15s)", (Object)serverStoppingLogsHidden);
                serverStoppingLogsHidden = 0;
            } else {
                ++serverStoppingLogsHidden;
            }
        }
        catch (Exception e) {
            LOGGER.error("RepAE2Bridge - Server Stopping: Exception during server stop cleanup", (Throwable)e);
        }
    }

    @SubscribeEvent
    public static void onServerStarting(ServerStartingEvent event) {
        try {
            RepAE2BridgeBlockEntity.setWorldUnloading(false);
            ServerLifecycleEventHandler.createExampleConfigFileIfNeeded();
            ServerLifecycleEventHandler.initializeCustomMatterAssociations();
            if ((long)serverStartingLogsHidden == 300L) {
                LOGGER.info("RepAE2Bridge - Server Starting: Server starting detected - resetting unload flag (+ {} similar events hidden in last 15s)", (Object)serverStartingLogsHidden);
                serverStartingLogsHidden = 0;
            } else {
                ++serverStartingLogsHidden;
            }
        }
        catch (Exception e) {
            LOGGER.error("RepAE2Bridge - Server Starting: Exception during server starting handling", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initializeCustomMatterAssociations() {
        if (customAssociationsLoaded) {
            return;
        }
        if (Config.enableDebugLogging) {
            LOGGER.info("Initializing custom matter type associations...");
        }
        try {
            customItemToMatterMap.clear();
            customMatterToItemMap.clear();
            customVirtualMatterItems.clear();
            ReplicationBridgeLoader.loadConfigFile();
            Map<String, String> matterDefinitions = ReplicationBridgeLoader.getMatterDefinitions();
            if (matterDefinitions.isEmpty()) {
                if (Config.enableDebugLogging) {
                    LOGGER.info("No custom matter definitions found");
                }
                customAssociationsLoaded = true;
                return;
            }
            if (Config.enableDebugLogging) {
                LOGGER.info("Found {} custom matter definitions, building associations...", (Object)matterDefinitions.size());
            }
            for (Map.Entry<String, String> entry : matterDefinitions.entrySet()) {
                String itemRegistryName = entry.getKey();
                String matterId = entry.getValue();
                try {
                    Item item = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"rep_ae2_bridge", (String)itemRegistryName));
                    if (item != null && item != Items.AIR) {
                        ResourceLocation matterResourceLocation = ResourceLocation.parse((String)matterId);
                        IMatterType matterType = (IMatterType)ReplicationRegistry.MATTER_TYPES_REGISTRY.get(matterResourceLocation);
                        if (matterType != null) {
                            customItemToMatterMap.put(item, matterType);
                            customMatterToItemMap.put(matterType, item);
                            customVirtualMatterItems.add(item);
                            if (!Config.enableDebugLogging) continue;
                            LOGGER.debug("Associated custom item '{}' with matter type '{}' ({})", new Object[]{itemRegistryName, matterId, matterType.getName()});
                            continue;
                        }
                        if (!Config.enableDebugLogging) continue;
                        LOGGER.warn("Matter type '{}' not found for custom item '{}'", (Object)matterId, (Object)itemRegistryName);
                        continue;
                    }
                    if (!Config.enableDebugLogging) continue;
                    LOGGER.warn("Custom item '{}' not found in registry", (Object)itemRegistryName);
                }
                catch (Exception e) {
                    LOGGER.error("Error processing custom matter association: {} -> {}", new Object[]{itemRegistryName, matterId, e});
                }
            }
            if (Config.enableDebugLogging) {
                LOGGER.info("Custom matter associations initialized: {} bidirectional mappings created", (Object)customItemToMatterMap.size());
            }
        }
        catch (Exception e) {
            LOGGER.error("Error initializing custom matter associations", (Throwable)e);
        }
        finally {
            customAssociationsLoaded = true;
        }
    }

    public static Map<Item, IMatterType> getCustomItemToMatterMap() {
        return customItemToMatterMap;
    }

    public static Map<IMatterType, Item> getCustomMatterToItemMap() {
        return customMatterToItemMap;
    }

    public static Set<Item> getCustomVirtualMatterItems() {
        return customVirtualMatterItems;
    }

    private static void createExampleConfigFileIfNeeded() {
        try {
            boolean shouldCreateFile;
            Path configFilePath;
            block18: {
                Path configDir = FMLPaths.CONFIGDIR.get();
                String configFileName = "rep_ae2_bridge_matters.json";
                configFilePath = configDir.resolve(configFileName);
                shouldCreateFile = false;
                if (!Files.exists(configFilePath, new LinkOption[0])) {
                    shouldCreateFile = true;
                    if (Config.enableDebugLogging) {
                        LOGGER.info("Config file not found, creating example config file at: {}", (Object)configFilePath.toAbsolutePath());
                    }
                } else {
                    try (BufferedReader reader = Files.newBufferedReader(configFilePath);){
                        JsonObject jsonObject = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
                        if (jsonObject != null && jsonObject.has("overwritable") && jsonObject.get("overwritable").getAsBoolean()) {
                            shouldCreateFile = true;
                            if (Config.enableDebugLogging) {
                                LOGGER.info("Config file exists and is overwritable, updating with latest matter associations: {}", (Object)configFilePath.toAbsolutePath());
                            }
                        } else if (Config.enableDebugLogging) {
                            LOGGER.debug("Config file exists and is not overwritable, skipping update: {}", (Object)configFilePath.toAbsolutePath());
                        }
                    }
                    catch (Exception e) {
                        shouldCreateFile = true;
                        if (!Config.enableDebugLogging) break block18;
                        LOGGER.warn("Error reading existing config file, recreating: {}", (Object)configFilePath.toAbsolutePath(), (Object)e);
                    }
                }
            }
            if (shouldCreateFile) {
                ReplicationBridgeLoader.createExampleConfigFile(configFilePath);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error checking/creating example config file", (Throwable)e);
        }
    }
}

