/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.replicationaddon.block.tile;

import com.buuz135.replication.ReplicationConfig;
import com.buuz135.replication.api.IMatterType;
import com.buuz135.replication.api.MatterType;
import com.buuz135.replication.api.matter_fluid.IMatterTank;
import com.buuz135.replication.api.matter_fluid.MatterStack;
import com.buuz135.replication.api.matter_fluid.component.MatterTankComponent;
import com.buuz135.replication.api.network.IMatterTanksConsumer;
import com.buuz135.replication.api.network.IMatterTanksSupplier;
import com.buuz135.replication.block.tile.NetworkBlockEntity;
import com.buuz135.replication.client.gui.ReplicationAddonProvider;
import com.buuz135.replication.container.component.LockableMatterTankBundle;
import com.hrznstudio.titanium.Titanium;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.block.tile.BasicTile;
import com.hrznstudio.titanium.client.screen.addon.WidgetScreenAddon;
import com.hrznstudio.titanium.client.screen.asset.IAssetProvider;
import com.hrznstudio.titanium.component.IComponentBundle;
import com.hrznstudio.titanium.component.IComponentHarness;
import com.hrznstudio.titanium.component.fluid.FluidTankComponent;
import com.hrznstudio.titanium.network.Message;
import com.hrznstudio.titanium.network.locator.ILocatable;
import com.hrznstudio.titanium.network.messages.ButtonClickNetworkMessage;
import com.hrznstudio.titanium.util.AssetUtil;
import com.leclowndu93150.replicationaddon.registry.ModRegistry;
import java.util.List;
import java.util.function.BooleanSupplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public class MatterVoidBlockEntity
extends NetworkBlockEntity<MatterVoidBlockEntity>
implements IMatterTanksSupplier,
IMatterTanksConsumer {
    @Save
    private LockableMatterTankBundle<MatterVoidBlockEntity> lockableMatterTankBundle;
    @Save
    private int tankPriority;
    private IMatterType cachedType = MatterType.EMPTY;

    public MatterVoidBlockEntity(BasicTileBlock<MatterVoidBlockEntity> base, BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state) {
        super(base, blockEntityType != null ? blockEntityType : (BlockEntityType)ModRegistry.MATTER_VOID_BE.get(), pos, state);
        VoidingMatterTankComponent tank = new VoidingMatterTankComponent("tank", ReplicationConfig.MatterTank.CAPACITY, 32, 28, () -> true);
        tank.setTankAction(FluidTankComponent.Action.BOTH).setOnContentChange(this::onTankContentChange);
        this.lockableMatterTankBundle = new LockableMatterTankBundle((BasicTile)this, tank, 16, 30, false);
        this.addBundle((IComponentBundle)this.lockableMatterTankBundle);
        this.addMatterTank(this.lockableMatterTankBundle.getTank());
        this.tankPriority = 0;
    }

    private void onTankContentChange() {
        this.syncObject(this.lockableMatterTankBundle);
        this.getNetwork().onTankValueChanged(this.cachedType);
        if (!this.cachedType.equals((Object)this.lockableMatterTankBundle.getTank().getMatter().getMatterType())) {
            this.cachedType = this.lockableMatterTankBundle.getTank().getMatter().getMatterType();
            this.getNetwork().onTankValueChanged(this.cachedType);
        }
    }

    public void handleButtonMessage(int id, Player playerEntity, CompoundTag compound) {
        super.handleButtonMessage(id, playerEntity, compound);
        if (id == 124578) {
            this.tankPriority = compound.getInt("Priority");
            this.syncObject(this.tankPriority);
        }
        this.markComponentDirty();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initClient() {
        super.initClient();
        this.addGuiAddonFactory(() -> new VoidTankPriorityAddon(this, 53, 52));
    }

    public ItemInteractionResult onActivated(Player playerIn, InteractionHand hand, Direction facing, double hitX, double hitY, double hitZ) {
        if (super.onActivated(playerIn, hand, facing, hitX, hitY, hitZ) == ItemInteractionResult.SUCCESS) {
            return ItemInteractionResult.SUCCESS;
        }
        this.openGui(playerIn);
        return ItemInteractionResult.SUCCESS;
    }

    public List<? extends IMatterTank> getTanks() {
        return this.getMatterTankComponents();
    }

    public int getPriority() {
        return this.tankPriority;
    }

    @NotNull
    public MatterVoidBlockEntity getSelf() {
        return this;
    }

    public IAssetProvider getAssetProvider() {
        return ReplicationAddonProvider.INSTANCE;
    }

    public int getTitleColor() {
        return 15034215;
    }

    public float getTitleYPos(float titleWidth, float screenWidth, float screenHeight, float guiWidth, float guiHeight) {
        return super.getTitleYPos(titleWidth, screenWidth, screenHeight, guiWidth, guiHeight) - 16.0f;
    }

    public void loadAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.loadAdditional(compound, provider);
        if (compound.contains("tank")) {
            this.lockableMatterTankBundle.getTank().deserializeNBT(provider, compound.getCompound("tank"));
        }
    }

    public static class VoidingMatterTankComponent<T extends IComponentHarness>
    extends MatterTankComponent<T> {
        private static final double MAX_DISPLAY_AMOUNT = 255999.0;

        public VoidingMatterTankComponent(String name, int amount, int posX, int posY, BooleanSupplier voidExcessSupplier) {
            super(name, amount, posX, posY, voidExcessSupplier, () -> false);
        }

        public double getMatterAmount() {
            return Math.min(super.getMatterAmount(), 255999.0);
        }

        public double fill(MatterStack resource, IFluidHandler.FluidAction action) {
            if (!this.getInsertPredicate().test(resource) || resource.isEmpty()) {
                return 0.0;
            }
            if (!this.isMatterValid(resource)) {
                return 0.0;
            }
            if (action.simulate()) {
                return resource.getAmount();
            }
            if (this.getMatter().isEmpty()) {
                double toStore = Math.min(255999.0, resource.getAmount());
                this.setMatter(new MatterStack(resource, toStore));
                this.onContentsChanged();
                return resource.getAmount();
            }
            if (!this.getMatter().isMatterEqual(resource)) {
                return 0.0;
            }
            double actualAmount = super.getMatterAmount();
            double spaceAvailable = 255999.0 - actualAmount;
            if (spaceAvailable > 0.0) {
                double toAdd = Math.min(spaceAvailable, resource.getAmount());
                this.getMatter().grow(toAdd);
                this.onContentsChanged();
            }
            return resource.getAmount();
        }
    }

    public static class VoidTankPriorityAddon
    extends WidgetScreenAddon {
        private final MatterVoidBlockEntity blockEntity;
        private final EditBox editBox;
        private String lastValue;

        public VoidTankPriorityAddon(MatterVoidBlockEntity blockEntity, int posX, int posY) {
            super(posX, posY, (AbstractWidget)new EditBox(Minecraft.getInstance().font, 85, 20, 160, 26, (Component)Component.translatable((String)"tooltip.replication.tank.insert_priority")));
            this.blockEntity = blockEntity;
            this.lastValue = "";
            this.editBox = (EditBox)this.getWidget();
            this.editBox.setValue("" + blockEntity.getPriority());
            this.editBox.setFilter(s -> {
                if (s.isEmpty()) {
                    return true;
                }
                if (s.charAt(0) == '-') {
                    return true;
                }
                try {
                    Integer.parseInt(s);
                    return true;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            });
            this.editBox.setMaxLength(6);
            this.editBox.setBordered(false);
            this.editBox.setVisible(true);
            this.editBox.setTextColor(7529831);
        }

        public int getXSize() {
            return 0;
        }

        public int getYSize() {
            return 0;
        }

        public void drawBackgroundLayer(GuiGraphics guiGraphics, Screen screen, IAssetProvider iAssetProvider, int guiX, int guiY, int mouseX, int mouseY, float partialTicks) {
            this.editBox.setResponder(s -> {
                AbstractContainerScreen containerScreen;
                AbstractContainerMenu patt0$temp;
                if (s.isEmpty()) {
                    return;
                }
                if (!this.lastValue.equals(s) && screen instanceof AbstractContainerScreen && (patt0$temp = (containerScreen = (AbstractContainerScreen)screen).getMenu()) instanceof ILocatable) {
                    ILocatable locatable = (ILocatable)patt0$temp;
                    CompoundTag compound = new CompoundTag();
                    if (s.charAt(0) == '-' && s.length() == 1) {
                        compound.putInt("Priority", 0);
                    } else {
                        compound.putInt("Priority", Integer.parseInt(s));
                    }
                    Titanium.NETWORK.sendToServer((Message)new ButtonClickNetworkMessage(locatable.getLocatorInstance(), 124578, compound));
                    new Thread(() -> {
                        try {
                            Thread.sleep(5000L);
                            this.editBox.setValue("" + this.blockEntity.getPriority());
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException(e);
                        }
                    }).start();
                }
                this.lastValue = s;
            });
            super.drawBackgroundLayer(guiGraphics, screen, iAssetProvider, guiX, guiY, mouseX, mouseY, partialTicks);
            int textWidth = Minecraft.getInstance().font.width(Component.translatable((String)"tooltip.replication.tank.priority").getString());
            guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.translatable((String)"tooltip.replication.tank.priority"), guiX + this.getPosX(), guiY + this.getPosY(), 7529831, false);
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate((float)textWidth, 0.0f, 0.0f);
            this.editBox.render(guiGraphics, mouseX, mouseY, partialTicks);
            guiGraphics.pose().popPose();
            for (int i = 0; i < 18; ++i) {
                AssetUtil.drawHorizontalLine((GuiGraphics)guiGraphics, (int)(guiX + this.getPosX() + textWidth + i * 2), (int)(guiX + this.getPosX() + textWidth + i * 2), (int)(guiY + this.getPosY() + 8), (int)-9247385);
            }
        }

        public void drawForegroundLayer(GuiGraphics guiGraphics, Screen screen, IAssetProvider iAssetProvider, int guiX, int guiY, int mouseX, int mouseY, float partialTicks) {
        }
    }
}

