/*
 * Decompiled with CFR 0.152.
 */
package com.respawningstructures.mixin;

import com.respawningstructures.structure.RespawnManager;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LevelChunk.class})
public abstract class LevelChunkBlockEntityHookMixin {
    @Shadow
    public abstract Level getLevel();

    @Shadow
    protected abstract boolean isInLevel();

    @Inject(method={"removeBlockEntity"}, at={@At(value="INVOKE", target="Ljava/util/Map;remove(Ljava/lang/Object;)Ljava/lang/Object;", remap=false)})
    private void onBERemove(BlockPos pos, CallbackInfo ci) {
        if (this.isInLevel() && this.getLevel() instanceof ServerLevel) {
            RespawnManager.onBlockEntityAddRemove((ServerLevel)this.getLevel(), pos, true);
        }
    }

    @Inject(method={"setBlockState"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/chunk/LevelChunk;addAndRegisterBlockEntity(Lnet/minecraft/world/level/block/entity/BlockEntity;)V")})
    private void onBEAdd(BlockPos pos, BlockState p_62866_, boolean p_62867_, CallbackInfoReturnable<BlockState> cir) {
        if (this.isInLevel() && this.getLevel() instanceof ServerLevel) {
            RespawnManager.onBlockEntityAddRemove((ServerLevel)this.getLevel(), pos, false);
        }
    }
}

