/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolspower.modules.blazing.client;

import javax.annotation.Nonnull;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.widgets.EnergyBar;
import mcjty.lib.gui.widgets.ImageChoiceLabel;
import mcjty.lib.gui.widgets.Label;
import mcjty.rftoolspower.modules.blazing.BlazingModule;
import mcjty.rftoolspower.modules.blazing.blocks.BlazingGeneratorTileEntity;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;

public class GuiBlazingGenerator
extends GenericGuiContainer<BlazingGeneratorTileEntity, GenericContainer> {
    private EnergyBar energyBar;
    private final Label[] labels = new Label[4];

    public GuiBlazingGenerator(GenericContainer container, Inventory inventory, Component title) {
        super((AbstractContainerMenu)container, inventory, title, ((BaseBlock)BlazingModule.BLAZING_GENERATOR.block().get()).getManualEntry());
    }

    public static void register(RegisterMenuScreensEvent event) {
        event.register(BlazingModule.CONTAINER_BLAZING_GENERATOR.get(), GuiBlazingGenerator::new);
    }

    public void init() {
        this.window = new Window((Screen)this, this.getBE(), ResourceLocation.fromNamespaceAndPath((String)"rftoolspower", (String)"gui/blazing_generator.gui"));
        super.init();
        this.initializeFields();
    }

    private void initializeFields() {
        ((ImageChoiceLabel)this.window.findChild("redstone")).setCurrentChoice(this.getBE().getRSMode().ordinal());
        this.energyBar = (EnergyBar)this.window.findChild("energybar");
        for (int i = 0; i < 4; ++i) {
            this.labels[i] = (Label)this.window.findChild("gen" + i);
        }
    }

    private void updateFields() {
        if (this.window == null) {
            return;
        }
        this.updateEnergyBar(this.energyBar);
        BlazingGeneratorTileEntity te = (BlazingGeneratorTileEntity)this.getBE();
        for (int i = 0; i < 4; ++i) {
            this.labels[i].text(String.valueOf((int)te.getRfPerTick(i)));
        }
    }

    protected void renderBg(@Nonnull GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        this.updateFields();
        this.drawWindow(graphics, partialTicks, mouseX, mouseY);
    }
}

