/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.environmental.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Set;
import mcjty.rftoolsutility.modules.environmental.blocks.EnvironmentalMode;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public record EnvironmentalData(int radius, int miny, int maxy, EnvironmentalMode mode, Set<String> players) {
    public static final Codec<EnvironmentalData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("radius").forGetter(EnvironmentalData::radius), (App)Codec.INT.fieldOf("miny").forGetter(EnvironmentalData::miny), (App)Codec.INT.fieldOf("maxy").forGetter(EnvironmentalData::maxy), (App)EnvironmentalMode.CODEC.fieldOf("mode").forGetter(EnvironmentalData::mode), (App)Codec.STRING.listOf().fieldOf("players").forGetter(data -> new ArrayList<String>(data.players()))).apply((Applicative)instance, (radius, minY, maxY, mode, playerList) -> {
        Set<String> players = Set.copyOf(playerList);
        return new EnvironmentalData((int)radius, (int)minY, (int)maxY, (EnvironmentalMode)((Object)((Object)mode)), players);
    }));
    public static final StreamCodec<RegistryFriendlyByteBuf, EnvironmentalData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, EnvironmentalData::radius, (StreamCodec)ByteBufCodecs.INT, EnvironmentalData::miny, (StreamCodec)ByteBufCodecs.INT, EnvironmentalData::maxy, EnvironmentalMode.STREAM_CODEC, EnvironmentalData::mode, (StreamCodec)ByteBufCodecs.STRING_UTF8.apply(ByteBufCodecs.list()), data -> new ArrayList<String>(data.players()), (radius, minY, maxY, mode, playerList) -> {
        Set<String> players = Set.copyOf(playerList);
        return new EnvironmentalData((int)radius, (int)minY, (int)maxY, (EnvironmentalMode)((Object)mode), players);
    });

    public static final EnvironmentalData createDefault() {
        return new EnvironmentalData(50, 30, 70, EnvironmentalMode.MODE_BLACKLIST, Set.of());
    }

    public EnvironmentalData withRadius(int radius) {
        return new EnvironmentalData(radius, this.miny, this.maxy, this.mode, this.players);
    }

    public EnvironmentalData withMiny(int miny) {
        return new EnvironmentalData(this.radius, miny, this.maxy, this.mode, this.players);
    }

    public EnvironmentalData withMaxy(int maxy) {
        return new EnvironmentalData(this.radius, this.miny, maxy, this.mode, this.players);
    }

    public EnvironmentalData withMode(EnvironmentalMode mode) {
        return new EnvironmentalData(this.radius, this.miny, this.maxy, mode, this.players);
    }

    public EnvironmentalData withPlayers(Set<String> players) {
        return new EnvironmentalData(this.radius, this.miny, this.maxy, this.mode, players);
    }
}

