/*
 * Decompiled with CFR 0.152.
 */
package net.rocketplatform.game.client.mod.ui.template.element.button.type;

import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftblibrary.ui.SimpleTextButton;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.WidgetType;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.rocketplatform.game.client.mod.ui.template.callback.CallbackHolder;
import net.rocketplatform.game.client.mod.ui.template.callback.ElementCallback;
import net.rocketplatform.game.client.mod.ui.template.element.ElementTemplate;
import net.rocketplatform.game.client.mod.ui.template.element.button.ButtonTemplate;
import net.rocketplatform.game.client.mod.ui.template.layout.screen.TemplateScreen;
import net.rocketplatform.game.client.mod.ui.variable.VariableStorage;
import net.rocketplatform.game.client.mod.util.GuiUtils;
import org.joml.Vector2i;

public class SimpleButtonTemplate
extends ButtonTemplate {
    private static final String WIDTH_KEY = "width";
    private static final String HEIGHT_KEY = "height";
    private static final String CENTER_TEXT = "center_text";
    private static final int DEFAULT_WIDTH = 150;
    private static final int DEFAULT_HEIGHT = 20;
    private static final boolean DEFAULT_CENTER_TEXT = true;

    public SimpleButtonTemplate(String type, String id, ElementTemplate.Position position, ElementCallback callback) {
        super(type, id, position, callback);
    }

    public int getWidth() {
        return this.getOption(WIDTH_KEY, 150);
    }

    public int getHeight() {
        return this.getOption(HEIGHT_KEY, 20);
    }

    public boolean isTextCentered() {
        return this.getOption(CENTER_TEXT, true);
    }

    @Override
    public Widget createElement0(TemplateScreen screen, int elementWidth, int elementHeight, int offsetX, int offsetY, VariableStorage variableStorage) {
        Vector2i pos = this.getPivot().apply(elementWidth, elementHeight, this.getWidth(), this.getHeight());
        pos.add(offsetX + this.getPosition().x(), offsetY + this.getPosition().y());
        boolean hasText = this.getText() != null;
        SimpleTextButton button = this.createButton(screen, variableStorage, hasText);
        button.setPosAndSize(pos.x(), pos.y(), this.getWidth(), this.getHeight());
        return button;
    }

    protected SimpleTextButton createButton(final TemplateScreen screen, final VariableStorage variableStorage, final boolean hasText) {
        return new SimpleTextButton(screen.getPanel(), (Component)(hasText ? this.getText() : Component.empty()), (Icon)(this.getIcon() == null ? Icon.empty() : Icon.getIcon((String)this.getIcon()))){

            public void draw(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
                if (hasText) {
                    super.draw(graphics, theme, x, y, w, h);
                    return;
                }
                GuiHelper.setupDrawing();
                int sizeX = w - 6;
                int sizeY = h - 6;
                this.drawBackground(graphics, theme, x, y, w, h);
                this.drawIcon(graphics, theme, x + (w - sizeX) / 2, y + (h - sizeY) / 2, sizeX, sizeY);
            }

            public void onClicked(MouseButton button) {
                this.playClickSound();
                if (SimpleButtonTemplate.this.getDisabledCallback() != null && !GuiUtils.shouldProcess(SimpleButtonTemplate.this.getRequiredVariable(), screen.getStorage())) {
                    CallbackHolder.runCallbacks(screen, SimpleButtonTemplate.this, SimpleButtonTemplate.this.getDisabledCallback(), variableStorage);
                } else {
                    SimpleButtonTemplate.this.runCallbacks(screen);
                }
            }

            public boolean renderTitleInCenter() {
                return SimpleButtonTemplate.this.isTextCentered();
            }

            public void addMouseOverText(TooltipList list) {
                Component activeTooltip = SimpleButtonTemplate.this.getActiveTooltip(variableStorage, this.getWidgetType() == WidgetType.DISABLED);
                if (activeTooltip != null) {
                    list.add(activeTooltip);
                }
            }

            public WidgetType getWidgetType() {
                String requiredVariable = SimpleButtonTemplate.this.getRequiredVariable();
                if (requiredVariable == null) {
                    return super.getWidgetType();
                }
                if (SimpleButtonTemplate.this.getDisabledCallback() == null && !GuiUtils.shouldProcess(requiredVariable, screen.getStorage())) {
                    return WidgetType.DISABLED;
                }
                return super.getWidgetType();
            }
        };
    }
}

