/*
 * Decompiled with CFR 0.152.
 */
package net.tarantel.chickenroost.block.tile;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.tarantel.chickenroost.block.blocks.ModBlocks;
import net.tarantel.chickenroost.block.tile.InputOutputItemHandler;
import net.tarantel.chickenroost.block.tile.ModBlockEntities;
import net.tarantel.chickenroost.handler.BreederHandler;
import net.tarantel.chickenroost.item.base.ChickenItemBase;
import net.tarantel.chickenroost.item.base.ChickenSeedBase;
import net.tarantel.chickenroost.recipes.BreederRecipe;
import net.tarantel.chickenroost.recipes.ModRecipes;
import net.tarantel.chickenroost.util.Config;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BreederTile
extends BlockEntity
implements MenuProvider {
    private boolean migrating = false;
    public int progress = 0;
    public int maxProgress = (Integer)Config.breed_speed_tick.get() * 20;
    public final ItemStackHandler itemHandler = new ItemStackHandler(12){

        protected void onContentsChanged(int slot) {
            if (!BreederTile.this.migrating) {
                BreederTile.this.setChanged();
                if (slot == 0 || slot == 2) {
                    BreederTile.this.resetProgress();
                }
                assert (BreederTile.this.level != null);
                if (!BreederTile.this.level.isClientSide()) {
                    BreederTile.this.level.sendBlockUpdated(BreederTile.this.getBlockPos(), BreederTile.this.getBlockState(), BreederTile.this.getBlockState(), 3);
                }
            }
        }

        public int getSlotLimit(int slot) {
            if (slot == 0 || slot == 2) {
                return 1;
            }
            return 64;
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return switch (slot) {
                case 0, 2 -> stack.getItem() instanceof ChickenItemBase;
                case 1 -> stack.getItem() instanceof ChickenSeedBase;
                default -> false;
            };
        }
    };
    public ItemStack currentOutput = ItemStack.EMPTY;
    protected final ContainerData data;
    private final IItemHandler itemHandlerSided = new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> i == 0 || i == 1 || i == 2, i -> i == 3 || i == 4 || i == 5 || i == 6 || i == 7 || i == 8 || i == 9 || i == 10 || i == 11);
    private boolean autoOutput = false;

    public ItemStack getRenderStack1() {
        ItemStack stack = !this.itemHandler.getStackInSlot(0).isEmpty() ? this.itemHandler.getStackInSlot(0) : ItemStack.EMPTY;
        return stack;
    }

    public ItemStack getRenderStack2() {
        ItemStack stack = !this.itemHandler.getStackInSlot(2).isEmpty() ? this.itemHandler.getStackInSlot(2) : ItemStack.EMPTY;
        return stack;
    }

    public ItemStack getRenderStack3() {
        ItemStack stack = !this.itemHandler.getStackInSlot(1).isEmpty() ? this.itemHandler.getStackInSlot(1) : ItemStack.EMPTY;
        return stack;
    }

    public void setHandler(ItemStackHandler itemStackHandler) {
        for (int i = 0; i < itemStackHandler.getSlots(); ++i) {
            this.itemHandler.setStackInSlot(i, itemStackHandler.getStackInSlot(i));
        }
    }

    public int getScaledProgress() {
        int progresss = this.progress;
        int maxProgresss = this.maxProgress;
        int progressArrowSize = 200;
        return maxProgresss != 0 && progresss != 0 ? progresss * progressArrowSize / maxProgresss : 0;
    }

    public BreederTile(BlockPos pos, BlockState state) {
        super(ModBlockEntities.BREEDER.get(), pos, state);
        this.data = new ContainerData(){

            public int get(int index) {
                return switch (index) {
                    case 0 -> BreederTile.this.progress;
                    case 1 -> BreederTile.this.maxProgress;
                    default -> 0;
                };
            }

            public void set(int index, int value) {
                switch (index) {
                    case 0: {
                        BreederTile.this.progress = value;
                        break;
                    }
                    case 1: {
                        BreederTile.this.maxProgress = value;
                    }
                }
            }

            public int getCount() {
                return 2;
            }
        };
    }

    @NotNull
    public Component getDisplayName() {
        return Component.translatable((String)"");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, @NotNull Inventory inventory, @NotNull Player player) {
        return new BreederHandler(id, inventory, this, this.data);
    }

    @Nullable
    public IItemHandler getItemHandlerCapability(@Nullable Direction side) {
        if (side == null) {
            return this.itemHandler;
        }
        return this.itemHandlerSided;
    }

    public void onLoad() {
        super.onLoad();
        this.setChanged();
    }

    public void saveAdditional(CompoundTag nbt, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider lookup) {
        nbt.put("inventory", (Tag)this.itemHandler.serializeNBT(lookup));
        nbt.putInt("breeder.progress", this.progress);
        nbt.putBoolean("AutoOutput", this.autoOutput);
        super.saveAdditional(nbt, lookup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadAdditional(@NotNull CompoundTag nbt, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider lookup) {
        super.loadAdditional(nbt, lookup);
        this.migrating = true;
        try {
            if (nbt.contains("inventory")) {
                CompoundTag invTag = nbt.getCompound("inventory");
                int oldSize = invTag.contains("Size") ? invTag.getInt("Size") : this.itemHandler.getSlots();
                ItemStackHandler oldHandler = new ItemStackHandler(oldSize);
                oldHandler.deserializeNBT(lookup, invTag);
                for (int i = 0; i < Math.min(oldHandler.getSlots(), this.itemHandler.getSlots()); ++i) {
                    ItemStack oldStack = oldHandler.getStackInSlot(i);
                    if (oldStack.isEmpty() || !this.itemHandler.getStackInSlot(i).isEmpty()) continue;
                    this.itemHandler.setStackInSlot(i, oldStack);
                }
            }
            this.progress = nbt.getInt("breeder.progress");
        }
        finally {
            this.migrating = false;
        }
        this.autoOutput = nbt.contains("AutoOutput") ? nbt.getBoolean("AutoOutput") : false;
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        SimpleContainer block = new SimpleContainer(1);
        ItemStack itemStack = new ItemStack((ItemLike)ModBlocks.BREEDER.get());
        NonNullList items = inventory.getItems();
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            items.set(i, (Object)this.itemHandler.getStackInSlot(i));
        }
        itemStack.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems((List)inventory.getItems()));
        block.setItem(0, itemStack.copy());
        Containers.dropContents((Level)Objects.requireNonNull(this.level), (BlockPos)this.worldPosition, (Container)block);
    }

    private static boolean hasFreeOrStackableSlot(BreederTile pEntity, ItemStack result) {
        for (int slot = 3; slot <= 11; ++slot) {
            ItemStack stackInSlot = pEntity.itemHandler.getStackInSlot(slot);
            if (stackInSlot.isEmpty()) {
                return true;
            }
            if (!ItemStack.isSameItemSameComponents((ItemStack)stackInSlot, (ItemStack)result) || stackInSlot.getCount() >= stackInSlot.getMaxStackSize()) continue;
            return true;
        }
        return false;
    }

    public boolean isAutoOutputEnabled() {
        return this.autoOutput;
    }

    public void setAutoOutputEnabled(boolean enabled) {
        this.autoOutput = enabled;
        if (this.level != null && !this.level.isClientSide) {
            BreederTile.setChanged((Level)this.level, (BlockPos)this.worldPosition, (BlockState)this.getBlockState());
        }
    }

    public static void tick(Level levelL, BlockPos pos, BlockState state, BreederTile pEntity) {
        if (levelL.isClientSide()) {
            return;
        }
        BreederTile.setChanged((Level)levelL, (BlockPos)pos, (BlockState)state);
        SimpleContainer inventory = new SimpleContainer(pEntity.itemHandler.getSlots());
        for (int i = 0; i < pEntity.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, pEntity.itemHandler.getStackInSlot(i));
        }
        List recipes = levelL.getRecipeManager().getRecipesFor(ModRecipes.BASIC_BREEDING_TYPE.get(), BreederTile.getRecipeInput(inventory), levelL);
        if (!recipes.isEmpty()) {
            if (pEntity.progress == 0 || pEntity.currentOutput.isEmpty()) {
                pEntity.currentOutput = BreederTile.pickRandomVariant(recipes);
                Optional first = levelL.getRecipeManager().getRecipeFor(ModRecipes.BASIC_BREEDING_TYPE.get(), BreederTile.getRecipeInput(inventory), levelL);
                first.ifPresent(holder -> {
                    pEntity.maxProgress = (Integer)Config.breed_speed_tick.get() * ((BreederRecipe)holder.value()).time();
                });
            }
            if (BreederTile.hasFreeOrStackableSlot(pEntity, pEntity.currentOutput)) {
                ++pEntity.progress;
                if (pEntity.progress >= pEntity.maxProgress) {
                    BreederTile.craftItem(pEntity);
                    pEntity.currentOutput = ItemStack.EMPTY;
                }
            } else {
                pEntity.resetProgress();
                pEntity.currentOutput = ItemStack.EMPTY;
            }
        } else {
            pEntity.resetProgress();
            pEntity.currentOutput = ItemStack.EMPTY;
            BreederTile.setChanged((Level)levelL, (BlockPos)pos, (BlockState)state);
        }
        if (pEntity.isAutoOutputEnabled()) {
            BreederTile.tryPushBreederOutputsDown(levelL, pos, state, pEntity);
        }
    }

    private static void tryPushBreederOutputsDown(Level level, BlockPos pos, BlockState state, BreederTile tile) {
        IItemHandler belowHandler = (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, pos.below(), (Object)Direction.UP);
        if (belowHandler == null) {
            return;
        }
        boolean changed = false;
        for (int outputSlot = 3; outputSlot <= 11; ++outputSlot) {
            ItemStack stackInSlot = tile.itemHandler.getStackInSlot(outputSlot);
            if (stackInSlot.isEmpty()) continue;
            ItemStack remaining = stackInSlot.copy();
            for (int targetSlot = 0; targetSlot < belowHandler.getSlots() && !remaining.isEmpty(); ++targetSlot) {
                remaining = belowHandler.insertItem(targetSlot, remaining, false);
            }
            if (remaining.getCount() == stackInSlot.getCount()) continue;
            int moved = stackInSlot.getCount() - remaining.getCount();
            ItemStack newStack = stackInSlot.copy();
            newStack.shrink(moved);
            if (newStack.isEmpty()) {
                newStack = ItemStack.EMPTY;
            }
            tile.itemHandler.setStackInSlot(outputSlot, newStack);
            changed = true;
        }
        if (changed) {
            BreederTile.setChanged((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    private void resetProgress() {
        this.progress = 0;
    }

    private static ItemStack pickRandomVariant(List<RecipeHolder<BreederRecipe>> recipes) {
        Random ran = new Random();
        int randomIndex = ran.nextInt(recipes.size());
        RecipeHolder<BreederRecipe> randomRecipe = recipes.get(randomIndex);
        return new ItemStack((ItemLike)((BreederRecipe)randomRecipe.value()).output().getItem());
    }

    private static void craftItem(BreederTile pEntity) {
        int slot;
        ItemStack chickenOutput;
        Level level = pEntity.level;
        SimpleContainer inventory = new SimpleContainer(pEntity.itemHandler.getSlots());
        for (int i = 0; i < pEntity.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, pEntity.itemHandler.getStackInSlot(i));
        }
        assert (level != null);
        List recipes = level.getRecipeManager().getRecipesFor(ModRecipes.BASIC_BREEDING_TYPE.get(), BreederTile.getRecipeInput(inventory), level);
        ItemStack itemStack = pEntity.currentOutput != null && !pEntity.currentOutput.isEmpty() ? pEntity.currentOutput : (chickenOutput = recipes.isEmpty() ? ItemStack.EMPTY : new ItemStack((ItemLike)((BreederRecipe)((RecipeHolder)recipes.get(new Random().nextInt(recipes.size()))).value()).output().getItem()));
        if (chickenOutput.isEmpty()) {
            pEntity.resetProgress();
            return;
        }
        for (slot = 3; slot <= 11; ++slot) {
            ItemStack stackInSlot = pEntity.itemHandler.getStackInSlot(slot);
            if (stackInSlot.isEmpty() || !ItemStack.isSameItemSameComponents((ItemStack)stackInSlot, (ItemStack)chickenOutput) || stackInSlot.getCount() >= stackInSlot.getMaxStackSize()) continue;
            int spaceLeft = stackInSlot.getMaxStackSize() - stackInSlot.getCount();
            int toInsert = Math.min(spaceLeft, chickenOutput.getCount());
            pEntity.itemHandler.extractItem(0, 0, true);
            pEntity.itemHandler.extractItem(2, 0, true);
            pEntity.itemHandler.extractItem(1, 1, false);
            stackInSlot.grow(toInsert);
            pEntity.itemHandler.setStackInSlot(slot, stackInSlot);
            pEntity.resetProgress();
            return;
        }
        for (slot = 3; slot <= 11; ++slot) {
            if (!pEntity.itemHandler.getStackInSlot(slot).isEmpty()) continue;
            pEntity.itemHandler.extractItem(0, 0, true);
            pEntity.itemHandler.extractItem(2, 0, true);
            pEntity.itemHandler.extractItem(1, 1, false);
            pEntity.itemHandler.setStackInSlot(slot, chickenOutput);
            pEntity.resetProgress();
            return;
        }
        pEntity.resetProgress();
    }

    public static RecipeInput getRecipeInput(final SimpleContainer inventory) {
        return new RecipeInput(){

            @NotNull
            public ItemStack getItem(int index) {
                return inventory.getItem(index).copy();
            }

            public int size() {
                return inventory.getContainerSize();
            }
        };
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @NotNull
    public CompoundTag getUpdateTag(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider prov) {
        return this.saveWithFullMetadata(prov);
    }
}

