/*
 * Decompiled with CFR 0.152.
 */
package net.tarantel.chickenroost.item;

import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import net.tarantel.chickenroost.item.UniversalFluidItem;
import org.jetbrains.annotations.NotNull;

public class SingleUseFluidHandler
implements IFluidHandlerItem {
    private ItemStack container;

    public SingleUseFluidHandler(ItemStack stack) {
        this.container = stack;
    }

    private UniversalFluidItem getItem() {
        return (UniversalFluidItem)this.container.getItem();
    }

    public ItemStack getContainer() {
        return this.container;
    }

    public int getTanks() {
        return 1;
    }

    @NotNull
    public FluidStack getFluidInTank(int tank) {
        if (tank != 0 || this.container.isEmpty()) {
            return FluidStack.EMPTY;
        }
        UniversalFluidItem item = this.getItem();
        return new FluidStack(item.getFluid(), item.getAmountPerItem());
    }

    public int getTankCapacity(int tank) {
        if (tank != 0) {
            return 0;
        }
        return this.getItem().getAmountPerItem();
    }

    public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
        return tank == 0 && stack.getFluid() == this.getItem().getFluid();
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        return 0;
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty() || resource.getFluid() != this.getItem().getFluid()) {
            return FluidStack.EMPTY;
        }
        return this.drain(resource.getAmount(), action);
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        if (this.container.isEmpty() || maxDrain <= 0) {
            return FluidStack.EMPTY;
        }
        UniversalFluidItem item = this.getItem();
        int amountPerItem = item.getAmountPerItem();
        int toDrain = Math.min(maxDrain, amountPerItem);
        if (toDrain <= 0) {
            return FluidStack.EMPTY;
        }
        FluidStack result = new FluidStack(item.getFluid(), toDrain);
        if (action.execute()) {
            this.container.shrink(1);
            if (this.container.getCount() <= 0) {
                this.container = ItemStack.EMPTY;
            }
        }
        return result;
    }
}

