/*
 * Decompiled with CFR 0.152.
 */
package net.tarantel.chickenroost.item;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CauldronBlock;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UniversalFluidItem
extends Item {
    private final Fluid fluid;
    private final int amount;

    public UniversalFluidItem(Item.Properties props, Fluid fluid, int amount) {
        super(props);
        this.fluid = fluid;
        this.amount = amount;
    }

    public int getAmount() {
        return this.amount;
    }

    public Fluid getFluid() {
        return this.fluid;
    }

    public int getAmountPerItem() {
        return this.amount;
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        Direction handlerSideForPlace;
        BlockState clickedState;
        Player player = context.getPlayer();
        Level level = context.getLevel();
        BlockPos clickedPos = context.getClickedPos();
        Direction side = context.getClickedFace();
        ItemStack stack = player != null ? player.getItemInHand(context.getHand()) : context.getItemInHand();
        BlockHitResult hit = this.raycast(level, player);
        if (hit != null) {
            side = hit.getDirection();
        }
        if (this.isAnyCauldron(clickedState = level.getBlockState(clickedPos)) && side == Direction.UP && this.handleCauldronFill(level, clickedPos)) {
            this.consumeOne(stack, player);
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        BlockPos placePos = clickedState.canBeReplaced() ? clickedPos : clickedPos.relative(side);
        BlockState placeState = level.getBlockState(placePos);
        if (this.isAnyCauldron(placeState) && side == Direction.UP && this.handleCauldronFill(level, placePos)) {
            this.consumeOne(stack, player);
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        boolean requireFull = this.amount >= 1000;
        Direction direction = handlerSideForPlace = placePos.equals((Object)clickedPos) ? side : side.getOpposite();
        if (this.tryFillAnyHandler(level, clickedPos, side, requireFull) || this.tryFillAnyHandler(level, clickedPos, null, requireFull) || this.tryFillAnyHandler(level, placePos, handlerSideForPlace, requireFull) || this.tryFillAnyHandler(level, placePos, null, requireFull)) {
            this.consumeOne(stack, player);
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        if (this.placeFluidInWorld(level, placePos, this.fluid)) {
            this.consumeOne(stack, player);
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return InteractionResult.PASS;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        BlockHitResult hit = this.raycast(level, player);
        if (hit != null && hit.getType() == HitResult.Type.BLOCK) {
            boolean requireFull;
            BlockPos pos = hit.getBlockPos();
            Direction face = hit.getDirection();
            boolean bl = requireFull = this.amount >= 1000;
            if (this.tryFillAnyHandler(level, pos, face, requireFull) || this.tryFillAnyHandler(level, pos, null, requireFull)) {
                this.consumeOne(stack, player);
                return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide);
            }
        }
        return InteractionResultHolder.pass((Object)stack);
    }

    private BlockHitResult raycast(Level level, Player player) {
        BlockHitResult bhr;
        double reach;
        Vec3 look;
        Vec3 reachVec;
        if (player == null) {
            return null;
        }
        Vec3 eye = player.getEyePosition(1.0f);
        BlockHitResult hit = level.clip(new ClipContext(eye, reachVec = eye.add((look = player.getViewVector(1.0f)).scale(reach = player.blockInteractionRange())), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
        return hit instanceof BlockHitResult ? (bhr = hit) : null;
    }

    private boolean isAnyCauldron(BlockState state) {
        Block b = state.getBlock();
        return b instanceof CauldronBlock || b == Blocks.WATER_CAULDRON || b == Blocks.LAVA_CAULDRON;
    }

    private boolean handleCauldronFill(Level level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        Block block = state.getBlock();
        if (this.fluid == Fluids.WATER) {
            int current;
            if (block == Blocks.WATER_CAULDRON) {
                current = (Integer)state.getValue((Property)LayeredCauldronBlock.LEVEL);
            } else if (block instanceof CauldronBlock) {
                current = 0;
            } else {
                return false;
            }
            int addLevels = this.amount / 333;
            if (addLevels <= 0) {
                return false;
            }
            int newLevels = Math.min(3, current + Math.min(3, addLevels));
            if (newLevels == current) {
                return false;
            }
            BlockState newState = (BlockState)Blocks.WATER_CAULDRON.defaultBlockState().setValue((Property)LayeredCauldronBlock.LEVEL, (Comparable)Integer.valueOf(newLevels));
            if (!level.isClientSide) {
                level.setBlock(pos, newState, 3);
                level.gameEvent(null, (Holder)GameEvent.FLUID_PLACE, pos);
                level.playSound(null, pos, SoundEvents.BUCKET_EMPTY, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            return true;
        }
        if (this.fluid == Fluids.LAVA) {
            if (this.amount < 1000) {
                return false;
            }
            if (block instanceof CauldronBlock && block != Blocks.WATER_CAULDRON && block != Blocks.LAVA_CAULDRON) {
                if (!level.isClientSide) {
                    level.setBlock(pos, Blocks.LAVA_CAULDRON.defaultBlockState(), 3);
                    level.gameEvent(null, (Holder)GameEvent.FLUID_PLACE, pos);
                    level.playSound(null, pos, SoundEvents.BUCKET_EMPTY_LAVA, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                return true;
            }
        }
        return false;
    }

    private void consumeOne(ItemStack stack, @Nullable Player player) {
        if (player != null && player.getAbilities().instabuild) {
            return;
        }
        stack.shrink(1);
    }

    public boolean tryFillAnyHandler(Level level, BlockPos pos, Direction side, boolean requireFull) {
        if (this.tryFill(level, pos, side, requireFull, true)) {
            return true;
        }
        return this.tryFill(level, pos, side, requireFull, false);
    }

    private boolean tryFill(Level level, BlockPos pos, Direction side, boolean requireFull, boolean blockEntityCap) {
        IFluidHandler handler = (IFluidHandler)level.getCapability(Capabilities.FluidHandler.BLOCK, pos, (Object)side);
        if (handler == null) {
            return false;
        }
        FluidStack toInsert = new FluidStack(this.fluid, this.amount);
        int canFill = handler.fill(toInsert, IFluidHandler.FluidAction.SIMULATE);
        if (requireFull && canFill < this.amount) {
            return false;
        }
        if (canFill <= 0) {
            return false;
        }
        int filled = handler.fill(toInsert, IFluidHandler.FluidAction.EXECUTE);
        return requireFull ? filled == this.amount : filled > 0;
    }

    private boolean placeFluidInWorld(Level level, BlockPos pos, Fluid fluid) {
        BlockState fluidState;
        BlockState state = level.getBlockState(pos);
        if (!state.canBeReplaced() && !state.isAir()) {
            return false;
        }
        if (fluid == Fluids.WATER) {
            fluidState = Blocks.WATER.defaultBlockState();
        } else if (fluid == Fluids.LAVA) {
            fluidState = Blocks.LAVA.defaultBlockState();
        } else {
            return false;
        }
        if (!level.isClientSide) {
            level.setBlock(pos, fluidState, 3);
            level.gameEvent(null, (Holder)GameEvent.BLOCK_PLACE, pos);
            if (fluid == Fluids.WATER) {
                level.playSound(null, pos, SoundEvents.BUCKET_EMPTY, SoundSource.BLOCKS, 1.0f, 1.0f);
            } else {
                level.playSound(null, pos, SoundEvents.BUCKET_EMPTY_LAVA, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
        return true;
    }
}

