/*
 * Decompiled with CFR 0.152.
 */
package com.schematicenergistics.menu;

import appeng.api.stacks.AEItemKey;
import appeng.menu.AEBaseMenu;
import com.schematicenergistics.blockentity.CannonInterfaceEntity;
import com.schematicenergistics.core.Registration;
import com.schematicenergistics.logic.CannonInterfaceLogic;
import com.schematicenergistics.logic.ICannonInterfaceHost;
import com.schematicenergistics.network.payloads.CannonInterfaceConfigClientPacket;
import com.schematicenergistics.network.payloads.CannonInterfaceSyncPacket;
import com.schematicenergistics.part.CannonInterfacePart;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.PacketDistributor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CannonInterfaceMenu
extends AEBaseMenu {
    private static final Logger log = LoggerFactory.getLogger(CannonInterfaceMenu.class);
    private AEItemKey clientItem;
    private ICannonInterfaceHost host;

    public CannonInterfaceMenu(int id, Inventory playerInventory, ICannonInterfaceHost host) {
        super(Registration.CANNON_INTERFACE_MENU.get(), id, playerInventory, (Object)host);
        this.createPlayerInventorySlots(playerInventory);
        this.host = host;
        this.sendState();
    }

    public CannonInterfaceLogic getLogic() {
        return this.host.getLogic();
    }

    public ICannonInterfaceHost getHost() {
        return this.host;
    }

    public BlockEntity getBlockEntity() {
        return super.getBlockEntity();
    }

    public void sendState() {
        Player player = this.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            boolean currentGunpowderState = this.getGunpowderState();
            boolean currentCraftingState = this.getCraftingState();
            boolean currentGunpowderCraftingState = this.getGunpowderCraftingState();
            PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new CannonInterfaceConfigClientPacket(currentGunpowderState, currentCraftingState, currentGunpowderCraftingState), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public void receiveStates(String type, boolean value) {
        CannonInterfaceEntity entity = this.getHost().getEntity();
        CannonInterfacePart part = this.getHost().getPart();
        if (entity != null && part == null) {
            entity.setConfigState(type, value);
            entity.setChanged();
            this.sendState();
        } else if (part != null && entity == null) {
            part.setConfigState(type, value);
            part.getHost().markForSave();
            this.sendState();
        } else {
            throw new IllegalStateException("Both entity and part are null or not null in CannonInterfaceMenu");
        }
    }

    public boolean getGunpowderState() {
        CannonInterfaceEntity entity = this.getHost().getEntity();
        CannonInterfacePart part = this.getHost().getPart();
        if (entity != null) {
            return entity.getConfigState("gunpowderState");
        }
        if (part != null) {
            return part.getConfigState("gunpowderState");
        }
        return false;
    }

    public boolean getCraftingState() {
        CannonInterfaceEntity entity = this.getHost().getEntity();
        CannonInterfacePart part = this.getHost().getPart();
        if (entity != null) {
            return entity.getConfigState("craftingState");
        }
        if (part != null) {
            return part.getConfigState("craftingState");
        }
        return false;
    }

    public boolean getGunpowderCraftingState() {
        CannonInterfaceEntity entity = this.getHost().getEntity();
        CannonInterfacePart part = this.getHost().getPart();
        if (entity != null) {
            return entity.getConfigState("gunpowderCraftingState");
        }
        if (part != null) {
            return part.getConfigState("gunpowderCraftingState");
        }
        return false;
    }

    public void updateStateFromInterface(String state) {
        CannonInterfaceLogic logic = this.getLogic();
        if (logic != null) {
            logic.sendSchematicannonState(state);
        }
    }

    public void broadcastChanges() {
        super.broadcastChanges();
        Player player = this.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            if (this.getLogic() != null) {
                this.clientItem = this.getLogic().getItem();
                CompoundTag item = this.clientItem != null && !this.clientItem.toStack().isEmpty() ? this.clientItem.toTag((HolderLookup.Provider)this.getLogic().getLevel().registryAccess()) : new CompoundTag();
                String name = this.getLogic().getSchematicName() != null && !this.getLogic().getSchematicName().isEmpty() ? this.getLogic().getSchematicName() : "";
                String statusMsg = this.getLogic().getStatusMsg() != null && !this.getLogic().getStatusMsg().isEmpty() ? this.getLogic().getStatusMsg() : "";
                String state = this.getLogic().getState() != null && !this.getLogic().getState().isEmpty() ? this.getLogic().getState() : "";
                BlockPos terminal = this.getLogic().getTerminalPos();
                if (terminal != null) {
                    PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new CannonInterfaceSyncPacket(item, name, statusMsg, state, terminal), (CustomPacketPayload[])new CustomPacketPayload[0]);
                } else {
                    PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new CannonInterfaceSyncPacket(item, name, statusMsg, state), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }
    }
}

