/*
 * Decompiled with CFR 0.152.
 */
package com.schematicenergistics.mixin;

import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.api.stacks.AEItemKey;
import com.schematicenergistics.blockentity.CannonInterfaceEntity;
import com.schematicenergistics.logic.CannonInterfaceLogic;
import com.schematicenergistics.part.CannonInterfacePart;
import com.simibubi.create.AllDataComponents;
import com.simibubi.create.content.schematics.cannon.SchematicannonBlockEntity;
import com.simibubi.create.content.schematics.cannon.SchematicannonInventory;
import com.simibubi.create.content.schematics.requirement.ItemRequirement;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SchematicannonBlockEntity.class})
public abstract class SchematicCannonMixin {
    @Shadow
    public SchematicannonInventory inventory;
    @Shadow
    public ItemStack missingItem;
    @Shadow
    public SchematicannonBlockEntity.State state;
    @Shadow
    public String statusMsg;
    private CannonInterfaceLogic cannonInterface;

    @Inject(method={"initializePrinter"}, at={@At(value="HEAD")}, cancellable=true)
    protected void initializePrinter(CallbackInfo ci) {
        if (this.cannonInterface != null) {
            this.cannonInterface.setLinkedCannon((SchematicannonBlockEntity)this);
        }
    }

    @Inject(method={"findInventories"}, at={@At(value="TAIL")})
    public void findInventories(CallbackInfo ci) {
        Level level = ((SchematicannonBlockEntity)this).getLevel();
        BlockPos pos = ((SchematicannonBlockEntity)this).getBlockPos();
        CannonInterfaceLogic logicalHost = null;
        if (level == null) {
            return;
        }
        for (Direction dir : Direction.values()) {
            IPartHost partHost;
            IPart part;
            BlockPos neighborPos = pos.relative(dir);
            BlockEntity be = level.getBlockEntity(neighborPos);
            if (be instanceof CannonInterfaceEntity) {
                CannonInterfaceEntity candidateInterface = (CannonInterfaceEntity)be;
                CannonInterfaceLogic logic = candidateInterface.getLogic();
                if (logic == null) continue;
                logicalHost = logic;
                break;
            }
            if (!(be instanceof IPartHost) || !((part = (partHost = (IPartHost)be).getPart(dir.getOpposite())) instanceof CannonInterfacePart)) continue;
            CannonInterfacePart cannonPart = (CannonInterfacePart)part;
            logicalHost = cannonPart.getLogic();
        }
        this.cannonInterface = logicalHost != null ? logicalHost : null;
    }

    @Inject(method={"grabItemsFromAttachedInventories"}, at={@At(value="TAIL")}, cancellable=true)
    protected void grabItemsFromAttachedInventories(ItemRequirement.StackRequirement required, boolean simulate, CallbackInfoReturnable<Boolean> cir) {
        if (!((Boolean)cir.getReturnValue()).booleanValue() && this.cannonInterface != null) {
            AEItemKey key = AEItemKey.of((ItemStack)required.stack);
            this.cannonInterface.setItem(key);
            long neededCount = required.stack.getCount();
            boolean result = this.cannonInterface.request(key, neededCount, simulate);
            cir.setReturnValue((Object)result);
        }
    }

    @Inject(method={"tickPrinter"}, at={@At(value="HEAD")}, cancellable=true)
    protected void tickPrinter(CallbackInfo ci) {
        AEItemKey key;
        if (this.cannonInterface == null) {
            return;
        }
        ItemStack blueprint = this.inventory.getStackInSlot(0);
        this.cannonInterface.setStatusMsg(this.statusMsg);
        this.cannonInterface.setState(this.state.toString());
        if (!blueprint.isEmpty()) {
            this.cannonInterface.setSchematicName((String)blueprint.get(AllDataComponents.SCHEMATIC_FILE));
        } else {
            this.cannonInterface.setSchematicName(null);
            this.cannonInterface.setItem(null);
        }
        if (this.missingItem != null && (key = AEItemKey.of((ItemStack)this.missingItem)) != this.cannonInterface.getItem()) {
            this.cannonInterface.setItem(key);
        }
        int maxStackSize = this.inventory.getStackInSlot(4).getMaxStackSize();
        int currentAmountOnSlot = this.inventory.getStackInSlot(4).getCount();
        if (currentAmountOnSlot >= maxStackSize) {
            return;
        }
        int amountToRefill = maxStackSize - currentAmountOnSlot;
        if (amountToRefill <= 0) {
            return;
        }
        int insertedItems = this.cannonInterface.refill(amountToRefill);
        if (insertedItems <= 0) {
            return;
        }
        ItemStack gunpowderStack = new ItemStack((ItemLike)Items.GUNPOWDER, insertedItems);
        this.inventory.insertItem(4, gunpowderStack, false);
    }
}

