/*
 * Decompiled with CFR 0.152.
 */
package com.schematicenergistics.network.payloads;

import com.schematicenergistics.SchematicEnergistics;
import com.schematicenergistics.lib.CannonInterfaceClientState;
import com.schematicenergistics.screen.CannonInterfaceScreen;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record CannonInterfaceConfigClientPacket(boolean gunpowderState, boolean craftingState, boolean gunpowderCraftingState) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<CannonInterfaceConfigClientPacket> TYPE = new CustomPacketPayload.Type(SchematicEnergistics.makeId("cannon_state"));
    public static final StreamCodec<ByteBuf, CannonInterfaceConfigClientPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, CannonInterfaceConfigClientPacket::gunpowderState, (StreamCodec)ByteBufCodecs.BOOL, CannonInterfaceConfigClientPacket::craftingState, (StreamCodec)ByteBufCodecs.BOOL, CannonInterfaceConfigClientPacket::gunpowderCraftingState, CannonInterfaceConfigClientPacket::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(CannonInterfaceConfigClientPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Minecraft minecraft = Minecraft.getInstance();
            CannonInterfaceClientState.setState(packet.gunpowderState(), packet.craftingState(), packet.gunpowderCraftingState());
            Screen patt0$temp = minecraft.screen;
            if (patt0$temp instanceof CannonInterfaceScreen) {
                CannonInterfaceScreen screen = (CannonInterfaceScreen)patt0$temp;
                screen.updateStates(packet.gunpowderState(), packet.craftingState(), packet.gunpowderCraftingState());
            }
        });
    }
}

