/*
 * Decompiled with CFR 0.152.
 */
package com.schematicenergistics.network.payloads;

import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.menu.MenuOpener;
import appeng.menu.locator.MenuHostLocator;
import appeng.menu.locator.MenuLocators;
import appeng.parts.AEBasePart;
import com.schematicenergistics.SchematicEnergistics;
import com.schematicenergistics.core.Registration;
import com.schematicenergistics.part.CannonInterfaceTerminal;
import io.netty.buffer.ByteBuf;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record ReturnToTerminalPacket(BlockPos terminalPos) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ReturnToTerminalPacket> TYPE = new CustomPacketPayload.Type(SchematicEnergistics.makeId("return_to_terminal"));
    public static final StreamCodec<ByteBuf, ReturnToTerminalPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, ReturnToTerminalPacket::terminalPos, ReturnToTerminalPacket::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(ReturnToTerminalPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            ServerPlayer player;
            BlockEntity blockEntity;
            Player patt0$temp = context.player();
            if (patt0$temp instanceof ServerPlayer && (blockEntity = (player = (ServerPlayer)patt0$temp).level().getBlockEntity(packet.terminalPos())) instanceof IPartHost) {
                IPartHost host = (IPartHost)blockEntity;
                for (Direction direction : Direction.values()) {
                    IPart part = host.getPart(direction);
                    if (!(part instanceof CannonInterfaceTerminal)) continue;
                    CannonInterfaceTerminal terminal = (CannonInterfaceTerminal)part;
                    MenuHostLocator menuLocators = MenuLocators.forPart((AEBasePart)terminal);
                    MenuOpener.open(Registration.CANNON_INTERFACE_TERMINAL_MENU.get(), (Player)player, (MenuHostLocator)menuLocators);
                    return;
                }
            }
        });
    }
}

