/*
 * Decompiled with CFR 0.152.
 */
package com.schematicenergistics.screen;

import appeng.api.stacks.AEItemKey;
import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.style.ScreenStyle;
import appeng.menu.AEBaseMenu;
import com.schematicenergistics.lib.CannonInterfaceClientState;
import com.schematicenergistics.lib.SEUtils;
import com.schematicenergistics.menu.CannonInterfaceMenu;
import com.schematicenergistics.network.payloads.CannonInterfaceConfigPacket;
import com.schematicenergistics.network.payloads.CannonStatePacket;
import com.schematicenergistics.network.payloads.ReturnToTerminalPacket;
import com.schematicenergistics.widgets.SEIcon;
import com.schematicenergistics.widgets.SESimpleIconButton;
import com.schematicenergistics.widgets.SEToggleButton;
import com.simibubi.create.content.schematics.cannon.SchematicannonBlockEntity;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;

public class CannonInterfaceScreen
extends AEBaseScreen<CannonInterfaceMenu> {
    private AEItemKey item;
    private final SEToggleButton toggleGunpowderCrafting;
    private final SEToggleButton toggleCrafting;
    private final SEToggleButton toggleGunpowder;
    private SEToggleButton playPause;
    private SESimpleIconButton backButton = null;
    private boolean craftingState;
    private boolean gunpowderState;
    private boolean gunpowderCraftingState;
    private static final int MAX_TEXT_WIDTH = 164;
    private BlockPos terminal = null;

    public CannonInterfaceScreen(CannonInterfaceMenu menu, Inventory playerInventory, Component title, ScreenStyle style) {
        super((AEBaseMenu)menu, playerInventory, title, style);
        this.imageWidth = 176;
        this.imageHeight = 182;
        this.terminal = null;
        if (CannonInterfaceClientState.hasState()) {
            this.gunpowderState = CannonInterfaceClientState.getGunpowderState();
            this.craftingState = CannonInterfaceClientState.getCraftingState();
            this.gunpowderCraftingState = CannonInterfaceClientState.getGunpowderCraftingState();
            CannonInterfaceClientState.reset();
        }
        this.toggleCrafting = new SEToggleButton(SEIcon.CRAFTING_ALLOW, SEIcon.CRAFTING_DENY, (Component)Component.translatable((String)"gui.schematicenergistics.cannon_interface.disable_autocraft"), (Component)Component.translatable((String)"gui.schematicenergistics.cannon_interface.disable_autocraft_hint"), (Component)Component.translatable((String)"gui.schematicenergistics.cannon_interface.enable_autocraft"), (Component)Component.translatable((String)"gui.schematicenergistics.cannon_interface.enable_autocraft_hint"), state -> this.sendState("craftingState", state), this.craftingState);
        this.toggleGunpowder = new SEToggleButton(SEIcon.GUNPOWDER_ALLOW, SEIcon.GUNPOWDER_DENY, (Component)Component.translatable((String)"gui.schematicenergistics.cannon_interface.disable_gunpowder"), (Component)Component.translatable((String)"gui.schematicenergistics.cannon_interface.disable_gunpowder_hint"), (Component)Component.translatable((String)"gui.schematicenergistics.cannon_interface.enable_gunpowder"), (Component)Component.translatable((String)"gui.schematicenergistics.cannon_interface.enable_gunpowder_hint"), state -> this.sendState("gunpowderState", state), this.gunpowderState);
        this.toggleGunpowderCrafting = new SEToggleButton(SEIcon.GUNPOWDER_CRAFTING_ALLOW, SEIcon.GUNPOWDER_CRAFTING_DENY, (Component)Component.translatable((String)"gui.schematicenergistics.cannon_interface.disable_gunpowder_crafting"), (Component)Component.translatable((String)"gui.schematicenergistics.cannon_interface.disable_gunpowder_crafting_hint"), (Component)Component.translatable((String)"gui.schematicenergistics.cannon_interface.enable_gunpowder_crafting"), (Component)Component.translatable((String)"gui.schematicenergistics.cannon_interface.enable_gunpowder_crafting_hint"), state -> this.sendState("gunpowderCraftingState", state), this.gunpowderCraftingState);
        this.addToLeftToolbar(this.toggleCrafting);
        this.addToLeftToolbar(this.toggleGunpowder);
        this.addToLeftToolbar(this.toggleGunpowderCrafting);
    }

    protected void init() {
        super.init();
        this.updateSchematicName(null);
        int centerX = this.leftPos + this.imageWidth / 2 - 8;
        this.playPause = new SEToggleButton(SEIcon.PAUSE, SEIcon.PLAY, (Component)Component.translatable((String)"gui.schematicenergistics.cannon_interface.pause"), (Component)Component.translatable((String)"gui.schematicenergistics.cannon_interface.pause_hint"), (Component)Component.translatable((String)"gui.schematicenergistics.cannon_interface.play"), (Component)Component.translatable((String)"gui.schematicenergistics.cannon_interface.play_hint"), state -> this.sendCannonState(state, false), false);
        this.playPause.setPosition(centerX - 16, this.topPos + 56);
        this.addRenderableWidget((GuiEventListener)this.playPause);
        SESimpleIconButton stop = new SESimpleIconButton(SEIcon.STOP, (Component)Component.translatable((String)"gui.schematicenergistics.cannon_interface.stop"), (Component)Component.translatable((String)"gui.schematicenergistics.cannon_interface.stop_hint"), btn -> this.sendCannonState(false, true));
        stop.setPosition(centerX + 16, this.topPos + 56);
        this.addRenderableWidget((GuiEventListener)stop);
        this.backButton = new SESimpleIconButton(SEIcon.BACK, (Component)Component.translatable((String)"gui.schematicenergistics.cannon_terminal.return_terminal"), (Component)Component.empty(), btn -> PacketDistributor.sendToServer((CustomPacketPayload)new ReturnToTerminalPacket(this.terminal), (CustomPacketPayload[])new CustomPacketPayload[0]));
        this.backButton.setPosition(this.leftPos + this.imageWidth - 28, this.topPos - 10);
        this.backButton.visible = this.terminal != null;
        this.addRenderableWidget((GuiEventListener)this.backButton);
    }

    public void sendState(String config, boolean state) {
        PacketDistributor.sendToServer((CustomPacketPayload)new CannonInterfaceConfigPacket(state, config), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void sendCannonState(boolean state, boolean isStop) {
        if (isStop) {
            SchematicannonBlockEntity.State stoppedState = SchematicannonBlockEntity.State.STOPPED;
            PacketDistributor.sendToServer((CustomPacketPayload)new CannonStatePacket(stoppedState.toString()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            return;
        }
        this.playPause.setState(state);
        SchematicannonBlockEntity.State cannonState = state ? SchematicannonBlockEntity.State.RUNNING : SchematicannonBlockEntity.State.PAUSED;
        PacketDistributor.sendToServer((CustomPacketPayload)new CannonStatePacket(cannonState.toString()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        int centerX = this.leftPos + 147;
        int centerY = this.topPos + 22;
        if (this.item != null && !this.item.toStack().isEmpty()) {
            guiGraphics.renderItem(this.item.toStack(), centerX, centerY);
        }
        if (mouseX >= centerX && mouseX < centerX + 16 && mouseY >= centerY && mouseY < centerY + 16) {
            if (this.item == null || this.item.toStack().isEmpty()) {
                guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"gui.schematicenergistics.cannon_interface.no_item"), mouseX, mouseY);
            } else {
                guiGraphics.renderTooltip(this.font, this.item.getDisplayName(), mouseX, mouseY);
            }
        }
    }

    public void updateStates(boolean gunpowderState, boolean craftingState, boolean gunpowderCraftingState) {
        this.gunpowderState = gunpowderState;
        this.craftingState = craftingState;
        if (this.toggleGunpowder != null) {
            this.toggleGunpowder.setState(gunpowderState);
        }
        if (this.toggleCrafting != null) {
            this.toggleCrafting.setState(craftingState);
        }
        if (this.toggleGunpowderCrafting != null) {
            this.toggleGunpowderCrafting.setState(gunpowderCraftingState);
        }
    }

    private Component limitTextWidth(Component originalText, int maxWidth) {
        String textString = originalText.getString();
        if (this.font.width(textString) <= maxWidth) {
            return originalText;
        }
        String ellipsis = "...";
        int ellipsisWidth = this.font.width(ellipsis);
        int availableWidth = maxWidth - ellipsisWidth;
        String truncatedText = this.font.plainSubstrByWidth(textString, availableWidth);
        return Component.literal((String)(truncatedText + ellipsis));
    }

    public void updateSchematicName(String schematicName) {
        MutableComponent text = schematicName == null || schematicName.isEmpty() ? Component.translatable((String)"gui.schematicenergistics.cannon_interface.schematic_name") : Component.literal((String)schematicName);
        Component limitedText = this.limitTextWidth((Component)text, 164);
        this.setTextContent("schematic_text", limitedText);
    }

    public void updateStatusMsg(String statusMsg) {
        MutableComponent text = statusMsg == null || statusMsg.isEmpty() ? Component.translatable((String)"gui.schematicenergistics.cannon_interface.missing_cannon") : SEUtils.formatCannonStatus(statusMsg);
        Component limitedText = this.limitTextWidth((Component)text, 164);
        this.setTextContent("status_text", limitedText);
    }

    public void updateCannonState(String state) {
        boolean cState = !"PAUSED".equals(state);
        this.playPause.setState(cState);
    }

    public void updateScreenItem(CompoundTag data, String schematicName, String statusMsg, String state, BlockPos terminalPos) {
        AEItemKey item = AEItemKey.fromTag((HolderLookup.Provider)((CannonInterfaceMenu)this.menu).getLogic().getLevel().registryAccess(), (CompoundTag)data);
        this.item = item != null ? item : AEItemKey.of((ItemStack)ItemStack.EMPTY);
        this.terminal = terminalPos;
        if (this.backButton != null) {
            this.backButton.visible = this.terminal != null;
        }
        this.updateSchematicName(schematicName);
        this.updateStatusMsg(statusMsg);
        this.updateCannonState(state);
    }
}

