/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.simpletomb;

import com.lothrazar.simpletomb.data.PartEnum;
import net.neoforged.neoforge.common.ModConfigSpec;

public class ConfigTomb {
    public static final ModConfigSpec CONFIG;
    public static ModConfigSpec.BooleanValue TOMBENABLED;
    public static ModConfigSpec.BooleanValue KEYGIVEN;
    public static ModConfigSpec.BooleanValue KEYNAMED;
    public static ModConfigSpec.IntValue TOMBEXTRAITEMS;
    public static ModConfigSpec.IntValue TPSURVIVAL;
    public static ModConfigSpec.BooleanValue TPCREATIVE;
    public static ModConfigSpec.BooleanValue TOMBLOG;
    public static ModConfigSpec.BooleanValue TOMBCHAT;
    public static ModConfigSpec.IntValue VSEARCHRANGE;
    public static ModConfigSpec.IntValue HSEARCHRANGE;
    public static ModConfigSpec.BooleanValue KEYOPENONUSE;
    public static ModConfigSpec.EnumValue<PartEnum> KEEPPARTS;
    static final String WALL = "####################################################################################";

    static {
        ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
        BUILDER.comment(new String[]{WALL, "Simple Tomb config", WALL}).push("simpletomb");
        BUILDER.comment(WALL).push("tomb");
        TOMBENABLED = BUILDER.comment("\r\nWhether to handle player death at all (false will disable almost the entire mod)").define("enabled", true);
        TOMBEXTRAITEMS = BUILDER.comment("\r\nThe radius in which extra bonus items should be hunted for and collected when a grave is spawned; set to zero (0) to disable").defineInRange("extra_items", 2, 0, 16);
        TOMBLOG = BUILDER.comment("\r\nIf true, write to the game log (server log) every time a tomb is placed").define("log", true);
        TOMBCHAT = BUILDER.comment("\r\nIf true, send a player chat message every time a tomb is placed").define("chat", true);
        VSEARCHRANGE = BUILDER.comment("\r\nWhen searching for a grave location, this is the maximum height to check").defineInRange("search_height", 16, 2, 128);
        HSEARCHRANGE = BUILDER.comment("\r\nWhen searching for a grave location, this is the maximum range to check").defineInRange("search_range", 8, 2, 128);
        KEEPPARTS = BUILDER.comment("\r\nKeep parts of the inventory").defineEnum("keep_parts", (Enum)PartEnum.NONE);
        BUILDER.pop();
        BUILDER.comment(WALL).push("key");
        KEYGIVEN = BUILDER.comment("\r\nWhether to give a Grave Key item to the player on death.  Tomb can be opened without they key, but the key will help the player locate the grave").define("given", true);
        KEYNAMED = BUILDER.comment("\r\nIf a key is being dropped, will the player's display name be added to the tomb key item name").define("named", true);
        KEYOPENONUSE = BUILDER.comment("\r\nTrue means the key will open the grave on use, even if the player is not standing on top").define("openOnUse", true);
        BUILDER.pop();
        BUILDER.comment(WALL).push("teleport");
        TPSURVIVAL = BUILDER.comment("\r\nWhen survival player is within this (straight line calculated) distance from the tomb, they can teleport to the tomb.  Set as zero (0) to disable survival TP feature.   Set as negative one (-1) to allow survival teleportation always and ignore the distance (within dimension) ").defineInRange("survival", 16, -1, 128);
        TPCREATIVE = BUILDER.comment("\r\nIf creative mode players can teleport to the tomb with the key, ignoring distance").define("creative", true);
        BUILDER.pop();
        BUILDER.pop();
        CONFIG = BUILDER.build();
    }
}

