/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CustomBubbleParticle
extends TextureSheetParticle {
    protected CustomBubbleParticle(ClientLevel world, double x, double y, double z, double velocityX, double velocityY, double velocityZ, SpriteSet provider) {
        super(world, x, y, z, velocityX, velocityY, velocityZ);
        this.pickSprite(provider);
        this.xd = velocityX;
        this.yd = velocityY;
        this.zd = velocityZ;
        this.quadSize = 0.1f;
        this.lifetime = 60 + this.random.nextInt(20);
        this.hasPhysics = false;
    }

    public void tick() {
        super.tick();
        if ((float)this.age > (float)this.lifetime * 0.5f) {
            float lifeFactor = (float)(this.lifetime - this.age) / ((float)this.lifetime * 0.5f);
            this.xd *= (double)lifeFactor;
            this.yd *= (double)lifeFactor;
            this.zd *= (double)lifeFactor;
        }
        this.yd += 0.003;
        this.alpha = this.age > this.lifetime - 10 ? Math.max(0.1f, this.alpha - 0.1f) : 1.0f;
        if (this.age >= this.lifetime - 1) {
            this.level.addParticle((ParticleOptions)ParticleTypes.BUBBLE_POP, this.x, this.y, this.z, 0.0, 0.0, 0.0);
        }
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteProvider;

        public Factory(SpriteSet spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        public Particle createParticle(SimpleParticleType parameters, ClientLevel world, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
            CustomBubbleParticle particle = new CustomBubbleParticle(world, x, y, z, velocityX, velocityY, velocityZ, this.spriteProvider);
            particle.pickSprite(this.spriteProvider);
            return particle;
        }
    }
}

