/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.config.settings;

import java.util.function.Consumer;
import java.util.function.Supplier;
import me.fzzyhmstrs.fzzy_config.util.Translatable;
import me.fzzyhmstrs.fzzy_config.util.Walkable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TooltipSettings
implements Translatable,
Walkable {
    @Nullable
    Supplier<? extends TooltipProvider> appender;

    public TooltipSettings(@Nullable Supplier<? extends TooltipProvider> appender) {
        this.appender = appender;
    }

    public TooltipSettings(ItemStack stack) {
        this(() -> new ItemStackAppender(stack));
    }

    public TooltipSettings() {
        this((Supplier<? extends TooltipProvider>)null);
    }

    @NotNull
    public String translationKey() {
        return "";
    }

    @NotNull
    public String descriptionKey() {
        return "";
    }

    @NotNull
    public MutableComponent translation(@Nullable String fallback) {
        return super.translation(fallback);
    }

    @NotNull
    public MutableComponent description(@Nullable String fallback) {
        if (this.appender == null) {
            return Component.empty();
        }
        MutableComponent[] desc = new MutableComponent[]{null};
        this.appender.get().addToTooltip(Item.TooltipContext.EMPTY, text -> {
            if (desc[0] == null) {
                desc[0] = text.copy();
            } else {
                desc[0].append((Component)Component.literal((String)"\n")).append(text);
            }
        }, (TooltipFlag)TooltipFlag.NORMAL);
        return desc[0];
    }

    public boolean hasTranslation() {
        return false;
    }

    public boolean hasDescription() {
        return this.appender != null;
    }

    private record ItemStackAppender(ItemStack stack) implements TooltipProvider
    {
        public void addToTooltip(Item.TooltipContext context, Consumer<Component> tooltip, TooltipFlag type) {
            this.stack.getTooltipLines(context, null, type).forEach(tooltip);
        }
    }
}

