/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.effect;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.sweenus.simplyswords.util.HelperMethods;

public class SmoulderingEffect
extends MobEffect {
    public SmoulderingEffect(MobEffectCategory statusEffectCategory, int color) {
        super(statusEffectCategory, color);
    }

    public boolean applyEffectTick(LivingEntity livingEntity, int amplifier) {
        if (!livingEntity.level().isClientSide()) {
            int frequency = 10;
            ServerLevel serverWorld = (ServerLevel)livingEntity.level();
            if (livingEntity.tickCount % frequency == 0) {
                HelperMethods.spawnOrbitParticles(serverWorld, livingEntity.position(), (ParticleOptions)ParticleTypes.LAVA, 0.2, 1);
            }
            if (livingEntity.tickCount % frequency * 4 == 0) {
                HelperMethods.spawnOrbitParticles(serverWorld, livingEntity.position(), (ParticleOptions)ParticleTypes.CAMPFIRE_SIGNAL_SMOKE, 0.2, 1);
            }
        }
        super.applyEffectTick(livingEntity, amplifier);
        return true;
    }

    public boolean shouldApplyEffectTickThisTick(int pDuration, int pAmplifier) {
        return true;
    }
}

