/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.effect;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.HelperMethods;

public class SoulTetherEffect
extends MobEffect {
    public LivingEntity sourceEntity;
    public int additionalData;
    private int remainingDetonations;
    public double detonateRadius;
    public float detonateDamage;
    public float heal;

    public SoulTetherEffect(MobEffectCategory statusEffectCategory, int color) {
        super(statusEffectCategory, color);
        this.remainingDetonations = Config.uniqueEffects.soulpyre.pulseCount;
        this.detonateRadius = Config.uniqueEffects.soulpyre.radius;
        this.detonateDamage = Config.uniqueEffects.soulpyre.damage;
        this.heal = Config.uniqueEffects.soulpyre.heal;
    }

    public void setSourcePlayer(LivingEntity livingEntity) {
        this.sourceEntity = livingEntity;
    }

    public void setAdditionalData(int data) {
        this.additionalData = data;
    }

    public boolean applyEffectTick(LivingEntity livingEntity, int amplifier) {
        if (!livingEntity.level().isClientSide()) {
            Player player;
            int detonateDelay = 15;
            ServerLevel world = (ServerLevel)livingEntity.level();
            DamageSource damageSource = livingEntity.damageSources().playerAttack(livingEntity instanceof Player ? (player = (Player)livingEntity) : null);
            if (this.remainingDetonations <= 0) {
                this.remainingDetonations = 10;
            }
            if (livingEntity.tickCount % detonateDelay == 0 && this.remainingDetonations > 0) {
                int detonateCount = this.remainingDetonations;
                livingEntity.heal(this.heal);
                AABB box = HelperMethods.createBox((Entity)livingEntity, this.detonateRadius - (double)detonateCount);
                for (Entity otherEntity : world.getEntities((Entity)livingEntity, box, EntitySelector.LIVING_ENTITY_STILL_ALIVE)) {
                    LivingEntity le;
                    if (!(otherEntity instanceof LivingEntity) || !HelperMethods.checkFriendlyFire(le = (LivingEntity)otherEntity, livingEntity)) continue;
                    HelperMethods.damageThroughIframes((Entity)le, damageSource, Math.min(30.0f, this.detonateDamage - (float)detonateCount));
                    if (le.distanceTo((Entity)livingEntity) > 1.0f) {
                        le.setDeltaMovement((livingEntity.getX() - le.getX()) / 8.0, (livingEntity.getY() - le.getY()) / 8.0, (livingEntity.getZ() - le.getZ()) / 8.0);
                    }
                    if (!(this.detonateDamage > le.getHealth())) continue;
                    this.detonateDamage += 1.0f;
                    HelperMethods.spawnWaistHeightParticles(world, (ParticleOptions)ParticleTypes.OMINOUS_SPAWNING, (Entity)livingEntity, (Entity)le, 20 - detonateCount);
                }
                world.playSound(null, (Entity)livingEntity, (SoundEvent)SoundRegistry.DARK_ACTIVATION_DISTORTED.get(), livingEntity.getSoundSource(), 0.05f, 0.8f + (float)detonateCount / 10.0f);
                HelperMethods.spawnOrbitParticles(world, livingEntity.position(), (ParticleOptions)ParticleTypes.POOF, this.detonateRadius - (double)detonateCount, 35 - detonateCount);
                HelperMethods.spawnOrbitParticles(world, livingEntity.position().add(0.0, 0.1, 0.0), (ParticleOptions)ParticleTypes.SOUL, this.detonateRadius - (double)detonateCount, 35 - detonateCount);
                HelperMethods.spawnOrbitParticles(world, livingEntity.position(), (ParticleOptions)ParticleTypes.VAULT_CONNECTION, this.detonateRadius - (double)detonateCount, 20 - detonateCount);
                HelperMethods.spawnOrbitParticles(world, livingEntity.position().add(0.0, 1.0, 0.0), (ParticleOptions)ParticleTypes.OMINOUS_SPAWNING, this.detonateRadius - (double)detonateCount, 40 - detonateCount);
                --this.remainingDetonations;
            }
        }
        super.applyEffectTick(livingEntity, amplifier);
        return true;
    }

    public void removeAttributeModifiers(AttributeMap attributeContainer) {
        this.remainingDetonations = 10;
        this.detonateDamage = 11.0f;
        super.removeAttributeModifiers(attributeContainer);
    }

    public boolean shouldApplyEffectTickThisTick(int pDuration, int pAmplifier) {
        return true;
    }
}

