/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.effect;

import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.AABB;
import net.sweenus.simplyswords.effect.WideOrbitingEffect;
import net.sweenus.simplyswords.effect.instance.SimplySwordsStatusEffectInstance;
import net.sweenus.simplyswords.item.custom.BrambleSwordItem;
import net.sweenus.simplyswords.registry.EffectRegistry;
import net.sweenus.simplyswords.util.HelperMethods;

public class SporeSwarmEffect
extends WideOrbitingEffect {
    public SporeSwarmEffect(MobEffectCategory statusEffectCategory, int color) {
        super(statusEffectCategory, color);
        this.setParticleType1((ParticleOptions)ParticleTypes.SMOKE);
        this.setParticleType2((ParticleOptions)ParticleTypes.ASH);
        this.setParticleType3((ParticleOptions)ParticleTypes.WARPED_SPORE);
    }

    @Override
    public boolean applyEffectTick(LivingEntity livingEntity, int amplifier) {
        if (!livingEntity.level().isClientSide()) {
            ServerLevel world = (ServerLevel)livingEntity.level();
            double x = livingEntity.getX();
            double y = livingEntity.getY();
            double z = livingEntity.getZ();
            double radius = 1.0 + (double)amplifier * 0.5;
            int maxAmp = 49;
            if (livingEntity.tickCount % 15 == 0) {
                AABB box = new AABB(x + radius, y + 1.0, z + radius, x - radius, y - 1.0, z - radius);
                for (Entity e : world.getEntities((Entity)livingEntity, box, EntitySelector.LIVING_ENTITY_STILL_ALIVE)) {
                    LivingEntity ee;
                    if (!(e instanceof LivingEntity) || !HelperMethods.checkFriendlyFire(ee = (LivingEntity)e, livingEntity)) continue;
                    HelperMethods.incrementStatusEffect(ee, (Holder<MobEffect>)MobEffects.MOVEMENT_SLOWDOWN, 40, 1, 3);
                    HelperMethods.incrementStatusEffect(ee, (Holder<MobEffect>)MobEffects.DIG_SLOWDOWN, 40, 1, 2);
                    if (!(livingEntity.getMainHandItem().getItem() instanceof BrambleSwordItem) && !(livingEntity.getOffhandItem().getItem() instanceof BrambleSwordItem)) {
                        maxAmp = 9;
                    }
                    if (livingEntity.getMainHandItem().getItem() instanceof BrambleSwordItem && livingEntity.getOffhandItem().getItem() instanceof BrambleSwordItem) {
                        maxAmp = 74;
                    }
                    SimplySwordsStatusEffectInstance effect = HelperMethods.incrementSimplySwordsStatusEffect(ee, EffectRegistry.getReference(EffectRegistry.PAIN), 60, 1, maxAmp);
                    effect.setSourceEntity(livingEntity);
                    effect.setAdditionalData(0);
                    ee.addEffect((MobEffectInstance)effect);
                    HelperMethods.spawnWaistHeightParticles(world, (ParticleOptions)ParticleTypes.SMOKE, (Entity)ee, (Entity)livingEntity, 10);
                    HelperMethods.incrementStatusEffect(livingEntity, EffectRegistry.getReference(EffectRegistry.SPORE_SWARM), 200, 1, 4);
                }
            }
        }
        super.applyEffectTick(livingEntity, amplifier);
        return true;
    }

    @Override
    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return super.shouldApplyEffectTickThisTick(duration, amplifier);
    }
}

