/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.power;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.sweenus.simplyswords.power.GemPower;
import net.sweenus.simplyswords.registry.GemPowerRegistry;
import net.sweenus.simplyswords.util.Styles;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record GemPowerComponent(boolean hasRunicPower, boolean hasNetherPower, Holder<GemPower> runicPower, Holder<GemPower> netherPower) {
    public static final Codec<GemPowerComponent> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("has_runic_power").forGetter(GemPowerComponent::hasRunicPower), (App)Codec.BOOL.fieldOf("has_nether_power").forGetter(GemPowerComponent::hasNetherPower), (App)new GemPower.GemPowerCodec().fieldOf("runic_power").forGetter(GemPowerComponent::runicPower), (App)new GemPower.GemPowerCodec().fieldOf("nether_power").forGetter(GemPowerComponent::netherPower)).apply((Applicative)instance, GemPowerComponent::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, GemPowerComponent> PACKET_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, GemPowerComponent::hasRunicPower, (StreamCodec)ByteBufCodecs.BOOL, GemPowerComponent::hasNetherPower, (StreamCodec)ByteBufCodecs.holderRegistry((ResourceKey)GemPowerRegistry.REGISTRY.key()), GemPowerComponent::runicPower, (StreamCodec)ByteBufCodecs.holderRegistry((ResourceKey)GemPowerRegistry.REGISTRY.key()), GemPowerComponent::netherPower, GemPowerComponent::new);
    public static final GemPowerComponent DEFAULT = new GemPowerComponent(false, false, (Holder<GemPower>)GemPowerRegistry.EMPTY, (Holder<GemPower>)GemPowerRegistry.EMPTY);

    @Override
    public boolean equals(Object componentObject) {
        if (componentObject == null || this.getClass() != componentObject.getClass()) {
            return false;
        }
        GemPowerComponent gemPowerComponentObject = (GemPowerComponent)componentObject;
        return this == gemPowerComponentObject;
    }

    public static GemPowerComponent runic(@NotNull Holder<GemPower> power) {
        return new GemPowerComponent(true, false, power, (Holder<GemPower>)GemPowerRegistry.EMPTY);
    }

    public static GemPowerComponent nether(@NotNull Holder<GemPower> power) {
        return new GemPowerComponent(false, true, (Holder<GemPower>)GemPowerRegistry.EMPTY, power);
    }

    public static GemPowerComponent create(@Nullable Holder<GemPower> runic, @Nullable Holder<GemPower> nether) {
        return new GemPowerComponent(runic != null, nether != null, (Holder<GemPower>)(runic != null ? runic : GemPowerRegistry.EMPTY), (Holder<GemPower>)(nether != null ? nether : GemPowerRegistry.EMPTY));
    }

    public static GemPowerComponent createEmpty(boolean hasRunic, boolean hasNether) {
        return new GemPowerComponent(hasRunic, hasNether, (Holder<GemPower>)GemPowerRegistry.EMPTY, (Holder<GemPower>)GemPowerRegistry.EMPTY);
    }

    public GemPowerComponent fill(BiFunction<Boolean, Holder<GemPower>, Holder<GemPower>> runicFiller, BiFunction<Boolean, Holder<GemPower>, Holder<GemPower>> netherFiller) {
        return new GemPowerComponent(this.hasRunicPower, this.hasNetherPower, runicFiller.apply(this.hasRunicPower, this.runicPower), netherFiller.apply(this.hasNetherPower, this.netherPower));
    }

    public boolean canBeFilled() {
        return this.hasRunicPower || this.hasNetherPower;
    }

    public boolean isEmpty() {
        return ((GemPower)this.runicPower.value()).isEmpty() && ((GemPower)this.netherPower.value()).isEmpty();
    }

    public boolean hasPower(Holder<GemPower> power) {
        if (this.isEmpty()) {
            return false;
        }
        return !((GemPower)this.runicPower.value()).isEmpty() && power.unwrap() == this.runicPower.unwrap() || !((GemPower)this.netherPower.value()).isEmpty() && power.unwrap() == this.netherPower.unwrap();
    }

    public boolean hasRunic(Holder<GemPower> power) {
        return !((GemPower)this.runicPower.value()).isEmpty() && power.unwrap().equals(this.runicPower.unwrap());
    }

    public boolean hasNether(Holder<GemPower> power) {
        return !((GemPower)this.netherPower.value()).isEmpty() && power.unwrap() == this.netherPower.unwrap();
    }

    public void postHit(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        ((GemPower)this.runicPower.value()).postHit(stack, target, attacker);
        ((GemPower)this.netherPower.value()).postHit(stack, target, attacker);
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        ItemStack itemStack = user.getItemInHand(hand);
        InteractionResultHolder<ItemStack> result1 = ((GemPower)this.runicPower.value()).use(world, user, hand, itemStack);
        InteractionResultHolder<ItemStack> result2 = ((GemPower)this.netherPower.value()).use(world, user, hand, itemStack);
        if (result1.getResult().compareTo((Enum)result2.getResult()) < 0) {
            return result1;
        }
        return result2;
    }

    public void usageTick(Level world, LivingEntity user, ItemStack stack, int remainingUseTicks) {
        ((GemPower)this.runicPower.value()).usageTick(world, user, stack, remainingUseTicks);
        ((GemPower)this.netherPower.value()).usageTick(world, user, stack, remainingUseTicks);
    }

    public void onStoppedUsing(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks) {
        ((GemPower)this.runicPower.value()).onStoppedUsing(stack, world, user, remainingUseTicks);
        ((GemPower)this.netherPower.value()).onStoppedUsing(stack, world, user, remainingUseTicks);
    }

    public int getMaxUseTime(ItemStack stack) {
        return Math.max(((GemPower)this.runicPower.value()).getMaxUseTime(stack), ((GemPower)this.netherPower.value()).getMaxUseTime(stack));
    }

    public void inventoryTick(ItemStack stack, Level world, LivingEntity user, int slot, boolean selected) {
        ((GemPower)this.runicPower.value()).inventoryTick(stack, world, user, slot, selected);
        ((GemPower)this.netherPower.value()).inventoryTick(stack, world, user, slot, selected);
    }

    public void appendTooltip(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag type) {
        this.appendTooltip(itemStack, tooltipContext, tooltip, type, false);
    }

    public void appendTooltip(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag type, boolean isRunic) {
        if (((GemPower)this.runicPower.value()).isGreater()) {
            tooltip.add((Component)Component.translatable((String)"item.simplyswords.greater_runic_power").setStyle(Styles.RUNIC));
        }
        if (!((GemPower)this.runicPower.value()).isEmpty()) {
            ((GemPower)this.runicPower.value()).appendTooltip(itemStack, tooltipContext, tooltip, type, isRunic);
        } else if (!isRunic && this.hasRunicPower) {
            tooltip.add((Component)Component.translatable((String)"item.simplyswords.empty_runic_slot").setStyle(Styles.RUNIC));
        }
        if (((GemPower)this.netherPower.value()).isGreater()) {
            tooltip.add((Component)Component.translatable((String)"item.simplyswords.greater_nether_power").setStyle(Styles.NETHERFUSED));
        }
        if (!((GemPower)this.netherPower.value()).isEmpty()) {
            ((GemPower)this.netherPower.value()).appendTooltip(itemStack, tooltipContext, tooltip, type, isRunic);
        } else if (!isRunic && this.hasNetherPower) {
            tooltip.add((Component)Component.translatable((String)"item.simplyswords.empty_nether_slot").setStyle(Styles.NETHERFUSED));
        }
    }
}

