/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.chars.CharArraySet;
import it.unimi.dsi.fastutil.chars.CharSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;

public class RawUpgradableRecipe {
    public static final MapCodec<RawUpgradableRecipe> CODEC = Data.CODEC.flatXmap(RawUpgradableRecipe::fromData, recipe -> recipe.data.map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Cannot encode unpacked recipe")));
    public static final StreamCodec<RegistryFriendlyByteBuf, RawUpgradableRecipe> PACKET_CODEC = StreamCodec.ofMember(RawUpgradableRecipe::writeToBuf, RawUpgradableRecipe::readFromBuf);
    private final int width;
    private final int height;
    private boolean mirrored;
    private final int upgradableItemSlot;
    private final NonNullList<Ingredient> ingredients;
    private final Optional<Data> data;
    private final int ingredientCount;
    private final boolean symmetrical;

    public int getUpgradableItemSlot() {
        return this.upgradableItemSlot;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public NonNullList<Ingredient> getIngredients() {
        return this.ingredients;
    }

    public RawUpgradableRecipe(int width, int height, int upgradableItemSlot, NonNullList<Ingredient> ingredients, Optional<Data> data) {
        this.width = width;
        this.height = height;
        this.upgradableItemSlot = upgradableItemSlot;
        this.ingredients = ingredients;
        this.data = data;
        int i = 0;
        for (Ingredient ingredient : ingredients) {
            if (ingredient.isEmpty()) continue;
            ++i;
        }
        this.ingredientCount = i;
        this.symmetrical = Util.isSymmetrical((int)width, (int)height, ingredients);
    }

    private void writeToBuf(RegistryFriendlyByteBuf buf) {
        buf.writeVarInt(this.width);
        buf.writeVarInt(this.height);
        for (Ingredient ingredient : this.ingredients) {
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buf, (Object)ingredient);
        }
        buf.writeVarInt(this.upgradableItemSlot);
    }

    public boolean matches(CraftingInput input) {
        if (input.ingredientCount() == this.ingredientCount && input.width() == this.width && input.height() == this.height) {
            if (!this.symmetrical && this.matches(input, true)) {
                return true;
            }
            return this.matches(input, false);
        }
        return false;
    }

    private boolean matches(CraftingInput input, boolean mirrored) {
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                ItemStack itemStack;
                Ingredient ingredient = mirrored ? (Ingredient)this.ingredients.get(this.width - j - 1 + i * this.width) : (Ingredient)this.ingredients.get(j + i * this.width);
                if (ingredient.test(itemStack = input.getItem(j, i))) continue;
                return false;
            }
        }
        this.mirrored = mirrored;
        return true;
    }

    private static DataResult<? extends RawUpgradableRecipe> fromData(Data data) {
        String[] pattern = RawUpgradableRecipe.stripWhitespace(data.pattern);
        int height = pattern.length;
        int width = pattern[0].length();
        NonNullList defaultedList = NonNullList.withSize((int)(height * width), (Object)Ingredient.EMPTY);
        CharArraySet charSet = new CharArraySet(data.key.keySet());
        int upgradableSlot = -1;
        for (int k = 0; k < pattern.length; ++k) {
            String string = pattern[k];
            for (int l = 0; l < string.length(); ++l) {
                boolean upgradable;
                int slot = l + k * width;
                char c = string.charAt(l);
                Ingredient ingredient = c == ' ' ? Ingredient.EMPTY : (Ingredient)data.key.get(Character.valueOf(c)).getFirst();
                boolean bl = upgradable = c != ' ' && (Boolean)data.key.get(Character.valueOf(c)).getSecond() != false;
                if (ingredient == null) {
                    return DataResult.error(() -> "Pattern references symbol '" + c + "' but it's not defined in the key");
                }
                if (upgradable) {
                    if (upgradableSlot < 0) {
                        upgradableSlot = slot;
                    } else {
                        int finalSlot = upgradableSlot;
                        return DataResult.error(() -> "Pattern attempted to define slot #" + slot + " as upgradable, but slot #" + finalSlot + " is already upgradable");
                    }
                }
                charSet.remove(c);
                defaultedList.set(slot, (Object)ingredient);
            }
        }
        if (upgradableSlot < 0) {
            return DataResult.error(() -> "Pattern does not define a slot as upgradable");
        }
        if (!charSet.isEmpty()) {
            return DataResult.error(() -> RawUpgradableRecipe.lambda$fromData$6((CharSet)charSet));
        }
        return DataResult.success((Object)new RawUpgradableRecipe(width, height, upgradableSlot, (NonNullList<Ingredient>)defaultedList, Optional.of(data)));
    }

    private static String[] stripWhitespace(List<String> strings) {
        int a = strings.getFirst().length();
        int b = strings.size();
        int c = 0;
        int d = 0;
        for (int y = 0; y < strings.size(); ++y) {
            for (int x = 0; x < strings.getFirst().length(); ++x) {
                if (strings.get(y).charAt(x) == ' ') continue;
                if (x < a) {
                    a = x;
                }
                if (x > c) {
                    c = x;
                }
                if (y < b) {
                    b = y;
                }
                if (y <= d) continue;
                d = y;
            }
        }
        ArrayList<String> strippedStrings = new ArrayList<String>();
        for (int y = 0; y < strings.size(); ++y) {
            if (y < b || y > d) continue;
            strippedStrings.add(strings.get(y).substring(a, c + 1));
        }
        return strippedStrings.toArray(new String[0]);
    }

    private static RawUpgradableRecipe readFromBuf(RegistryFriendlyByteBuf buf) {
        int i = buf.readVarInt();
        int j = buf.readVarInt();
        NonNullList defaultedList = NonNullList.withSize((int)(i * j), (Object)Ingredient.EMPTY);
        defaultedList.replaceAll(ingredient -> (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buf));
        int slot = buf.readVarInt();
        return new RawUpgradableRecipe(i, j, slot, (NonNullList<Ingredient>)defaultedList, Optional.empty());
    }

    public boolean isMirrored() {
        return this.mirrored;
    }

    private static /* synthetic */ String lambda$fromData$6(CharSet charSet) {
        return "Key defines symbols that aren't used in pattern: " + String.valueOf(charSet);
    }

    public record Data(Map<Character, Pair<Ingredient, Boolean>> key, List<String> pattern) {
        private static final Codec<List<String>> PATTERN_CODEC;
        private static final Codec<Pair<Ingredient, Boolean>> INGREDIENT_CODEC;
        private static final Codec<Character> KEY_ENTRY_CODEC;
        public static final MapCodec<Data> CODEC;

        static {
            INGREDIENT_CODEC = Codec.pair((Codec)Ingredient.CODEC_NONEMPTY, (Codec)Codec.BOOL.optionalFieldOf("upgradable", (Object)false).codec());
            PATTERN_CODEC = Codec.STRING.listOf().comapFlatMap(pattern -> {
                if (pattern.size() > 3) {
                    return DataResult.error(() -> "Invalid pattern: too many rows, 3 is maximum");
                }
                if (pattern.isEmpty()) {
                    return DataResult.error(() -> "Invalid pattern: empty pattern not allowed");
                }
                int i = ((String)pattern.getFirst()).length();
                for (String string : pattern) {
                    if (string.length() > 3) {
                        return DataResult.error(() -> "Invalid pattern: too many columns, 3 is maximum");
                    }
                    if (i == string.length()) continue;
                    return DataResult.error(() -> "Invalid pattern: each row must be the same width");
                }
                return DataResult.success((Object)pattern);
            }, Function.identity());
            KEY_ENTRY_CODEC = Codec.STRING.comapFlatMap(keyEntry -> {
                if (keyEntry.length() != 1) {
                    return DataResult.error(() -> "Invalid key entry: '" + keyEntry + "' is an invalid symbol (must be 1 character only).");
                }
                return " ".equals(keyEntry) ? DataResult.error(() -> "Invalid key entry: ' ' is a reserved symbol.") : DataResult.success((Object)Character.valueOf(keyEntry.charAt(0)));
            }, String::valueOf);
            CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ExtraCodecs.strictUnboundedMap(KEY_ENTRY_CODEC, INGREDIENT_CODEC).fieldOf("key").forGetter(data -> data.key), (App)PATTERN_CODEC.fieldOf("pattern").forGetter(data -> data.pattern)).apply((Applicative)instance, Data::new));
        }
    }
}

