/*
 * Decompiled with CFR 0.152.
 */
package alexthw.starbunclemania.glyph;

import alexthw.starbunclemania.StarbuncleMania;
import alexthw.starbunclemania.starbuncle.fluid.StarbyFluidBehavior;
import com.alexthw.sauce.api.WrappedExtractedItemHandler;
import com.hollingsworth.arsnouveau.api.ANFakePlayer;
import com.hollingsworth.arsnouveau.api.item.inv.ExtractedStack;
import com.hollingsworth.arsnouveau.api.item.inv.FilterableItemHandler;
import com.hollingsworth.arsnouveau.api.item.inv.InteractType;
import com.hollingsworth.arsnouveau.api.item.inv.InventoryManager;
import com.hollingsworth.arsnouveau.api.item.inv.SlotReference;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.IWrappedCaster;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.TileCaster;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.api.util.SpellUtil;
import com.hollingsworth.arsnouveau.common.block.tile.RuneTile;
import com.hollingsworth.arsnouveau.common.items.curios.ShapersFocus;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAOE;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentPierce;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentSensitive;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.util.BlockSnapshot;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import org.jetbrains.annotations.NotNull;

public class PlaceFluidEffect
extends AbstractEffect {
    public static final PlaceFluidEffect INSTANCE = new PlaceFluidEffect();

    public PlaceFluidEffect() {
        super(StarbuncleMania.prefix("glyph_place_fluid"), "Place Fluid");
    }

    public String getBookDescription() {
        return "Place Fluid in world, draining from a tank in the hotbar or next to the turret";
    }

    public void onResolveEntity(EntityHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        this.onResolveBlock(new BlockHitResult(rayTraceResult.getLocation(), Direction.UP, rayTraceResult.getEntity().getOnPos(), true), world, shooter, spellStats, spellContext, resolver);
    }

    public void onResolveBlock(BlockHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        List posList = SpellUtil.calcAOEBlocks((LivingEntity)shooter, (BlockPos)rayTraceResult.getBlockPos(), (BlockHitResult)rayTraceResult, (SpellStats)spellStats);
        ANFakePlayer fakePlayer = ANFakePlayer.getPlayer((ServerLevel)((ServerLevel)world));
        List<IFluidHandler> tanks = this.getTanks(world, spellContext);
        if (tanks.isEmpty()) {
            return;
        }
        for (BlockPos pos1 : posList) {
            if (!BlockUtil.destroyRespectsClaim((LivingEntity)this.getPlayer(shooter, (ServerLevel)world), (Level)world, (BlockPos)pos1)) continue;
            BlockPos blockPos = pos1 = spellStats.isSensitive() ? pos1 : pos1.relative(rayTraceResult.getDirection());
            if (world.getCapability(Capabilities.FluidHandler.BLOCK, pos1, (Object)rayTraceResult.getDirection()) != null) {
                IFluidHandler cap = StarbyFluidBehavior.getHandlerFromCap(pos1, world, rayTraceResult.getDirection());
                this.placeInTank(cap, tanks);
                continue;
            }
            if (((BlockEvent.EntityPlaceEvent)NeoForge.EVENT_BUS.post((Event)new BlockEvent.EntityPlaceEvent(BlockSnapshot.create((ResourceKey)world.dimension(), (LevelAccessor)world, (BlockPos)pos1), world.getBlockState(pos1), (Entity)fakePlayer))).isCanceled()) continue;
            this.place(pos1, (ServerLevel)world, shooter, tanks, spellContext, resolver, new BlockHitResult(new Vec3((double)pos1.getX(), (double)pos1.getY(), (double)pos1.getZ()), rayTraceResult.getDirection(), pos1, false));
        }
        for (IFluidHandler tank : tanks) {
            if (!(tank instanceof WrappedExtractedItemHandler)) continue;
            WrappedExtractedItemHandler wrap = (WrappedExtractedItemHandler)tank;
            wrap.extractedStack().returnOrDrop(world, shooter.getOnPos());
        }
    }

    private void placeInTank(IFluidHandler cap, List<IFluidHandler> tanks) {
        for (IFluidHandler tank : tanks) {
            int room;
            FluidStack fluid = tank.getFluidInTank(0);
            if (fluid.isEmpty() || !cap.isFluidValid(0, fluid) || (room = Math.min(1000, cap.fill(fluid, IFluidHandler.FluidAction.SIMULATE))) <= 0) continue;
            int actualFill = cap.fill(new FluidStack(fluid.getFluidHolder(), room), IFluidHandler.FluidAction.EXECUTE);
            tank.drain(actualFill, IFluidHandler.FluidAction.EXECUTE);
            if (!(tank instanceof WrappedExtractedItemHandler)) continue;
            WrappedExtractedItemHandler wrap = (WrappedExtractedItemHandler)tank;
            wrap.updateContainer();
        }
    }

    private void place(BlockPos pPos, ServerLevel world, LivingEntity shooter, List<IFluidHandler> tanks, SpellContext spellContext, SpellResolver resolver, BlockHitResult resolveResult) {
        BlockState state = world.getBlockState(pPos);
        boolean isReplaceable = state.canBeReplaced();
        for (IFluidHandler tank : tanks) {
            LiquidBlockContainer container;
            FluidStack tester;
            Fluid fluid;
            if (tank.getFluidInTank(0).isEmpty() || !((fluid = (tester = new FluidStack(tank.getFluidInTank(0).getFluidHolder(), 1000)).getFluid()) instanceof FlowingFluid)) continue;
            FlowingFluid ff = (FlowingFluid)fluid;
            if (tank.drain(tester, IFluidHandler.FluidAction.SIMULATE).getAmount() != 1000 || !state.isAir() && !isReplaceable && (!((fluid = state.getBlock()) instanceof LiquidBlockContainer) || !(container = (LiquidBlockContainer)fluid).canPlaceLiquid(this.getPlayer(shooter, world), (BlockGetter)world, pPos, state, (Fluid)ff))) continue;
            if (state.getFluidState().isSource() && state.getFluidState().getFluidType() == ff.getFluidType()) break;
            if (world.dimensionType().ultraWarm() && tester.is(FluidTags.WATER)) {
                int i = pPos.getX();
                int j = pPos.getY();
                int k = pPos.getZ();
                world.playSound(null, pPos, SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 0.5f, 2.6f + (world.random.nextFloat() - world.random.nextFloat()) * 0.8f);
                for (int l = 0; l < 8; ++l) {
                    world.addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, (double)i + Math.random(), (double)j + Math.random(), (double)k + Math.random(), 0.0, 0.0, 0.0);
                }
            } else {
                LiquidBlockContainer container2;
                Block block = state.getBlock();
                if (block instanceof LiquidBlockContainer && (container2 = (LiquidBlockContainer)block).canPlaceLiquid(this.getPlayer(shooter, world), (BlockGetter)world, pPos, state, (Fluid)ff)) {
                    container2.placeLiquid((LevelAccessor)world, pPos, state, ff.defaultFluidState());
                } else {
                    if (!world.isClientSide && state.canBeReplaced() && !state.liquid()) {
                        world.destroyBlock(pPos, true);
                    }
                    if (!world.setBlock(pPos, ff.defaultFluidState().createLegacyBlock(), 11) && !state.getFluidState().isSource()) continue;
                }
            }
            tank.drain(tester, IFluidHandler.FluidAction.EXECUTE);
            if (tank instanceof WrappedExtractedItemHandler) {
                WrappedExtractedItemHandler wrap = (WrappedExtractedItemHandler)tank;
                wrap.updateContainer();
            }
            ShapersFocus.tryPropagateBlockSpell((BlockHitResult)resolveResult, (Level)world, (Entity)shooter, (SpellContext)spellContext, (SpellResolver)resolver);
            break;
        }
    }

    public List<IFluidHandler> getTanks(Level world, SpellContext spellContext) {
        ArrayList<IFluidHandler> handlers;
        block3: {
            TileCaster tile;
            block4: {
                handlers = new ArrayList<IFluidHandler>();
                IWrappedCaster iWrappedCaster = spellContext.getCaster();
                if (!(iWrappedCaster instanceof TileCaster)) break block3;
                tile = (TileCaster)iWrappedCaster;
                if (!((iWrappedCaster = tile.getTile()) instanceof RuneTile)) break block4;
                RuneTile rune = (RuneTile)iWrappedCaster;
                if (rune.isSensitive) break block3;
            }
            BlockPos tilePos = tile.getTile().getBlockPos();
            for (Direction side : Direction.values()) {
                IFluidHandler handler;
                BlockPos pos = tilePos.relative(side);
                if (world.getCapability(Capabilities.FluidHandler.BLOCK, pos, (Object)side) == null || (handler = StarbyFluidBehavior.getHandlerFromCap(pos, world, side)) == null || handler.getFluidInTank(0).isEmpty() || handler.getFluidInTank(0).getAmount() < 1000) continue;
                handlers.add(handler);
            }
        }
        PlaceFluidEffect.getTankItems(spellContext, handlers);
        return handlers;
    }

    public static void getTankItems(SpellContext spellContext, List<IFluidHandler> handlers) {
        InventoryManager manager = spellContext.getCaster().getInvManager();
        Predicate<ItemStack> predicate = i -> !i.isEmpty() && i.getCapability(Capabilities.FluidHandler.ITEM) != null;
        FilterableItemHandler highestHandler = manager.highestPrefInventory(manager.getInventory(), predicate, InteractType.EXTRACT);
        if (highestHandler != null) {
            for (SlotReference slot : PlaceFluidEffect.findItems(highestHandler, predicate, InteractType.EXTRACT)) {
                ExtractedStack extractItem = ExtractedStack.from((SlotReference)slot, (int)1);
                if (extractItem.isEmpty()) continue;
                handlers.add((IFluidHandler)new WrappedExtractedItemHandler((IFluidHandlerItem)extractItem.stack.getCapability(Capabilities.FluidHandler.ITEM), extractItem));
            }
        }
    }

    public static List<SlotReference> findItems(FilterableItemHandler itemHandler, Predicate<ItemStack> stackPredicate, InteractType type) {
        ArrayList<SlotReference> slots = new ArrayList<SlotReference>();
        for (int slot = 0; slot < Math.min(itemHandler.getHandler().getSlots(), Inventory.getSelectionSize()); ++slot) {
            ItemStack stackInSlot = itemHandler.getHandler().getStackInSlot(slot);
            if (stackInSlot.isEmpty() || !stackPredicate.test(stackInSlot) || !itemHandler.canInteractFor(stackInSlot, type).valid()) continue;
            slots.add(new SlotReference(itemHandler.getHandler(), slot));
        }
        return slots;
    }

    public int getDefaultManaCost() {
        return 20;
    }

    public SpellTier defaultTier() {
        return SpellTier.TWO;
    }

    @NotNull
    public Set<SpellSchool> getSchools() {
        return this.setOf(new SpellSchool[]{SpellSchools.MANIPULATION, SpellSchools.ELEMENTAL_WATER});
    }

    @NotNull
    protected Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(new AbstractAugment[]{AugmentSensitive.INSTANCE, AugmentAOE.INSTANCE, AugmentPierce.INSTANCE});
    }

    public void addAugmentDescriptions(Map<AbstractAugment, String> map) {
        super.addAugmentDescriptions(map);
        this.addBlockAoeAugmentDescriptions(map);
        map.put((AbstractAugment)AugmentSensitive.INSTANCE, "Places the fluid inside the block hit instead of relative to it.");
    }
}

