/*
 * Decompiled with CFR 0.152.
 */
package ftblag.stonechest;

import ftblag.stonechest.blocks.BlockStoneChest;
import ftblag.stonechest.blocks.EnumStoneChest;
import ftblag.stonechest.client.TEISRStoneChest;
import ftblag.stonechest.tileentities.TileEntityStoneChest;
import java.util.Arrays;
import java.util.Locale;
import java.util.function.Consumer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class SCRegistry {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((ResourceKey)Registries.BLOCK, (String)"stonechest");
    public static final DeferredRegister<BlockEntityType<?>> TILE_ENTITIES = DeferredRegister.create((ResourceKey)Registries.BLOCK_ENTITY_TYPE, (String)"stonechest");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((ResourceKey)Registries.ITEM, (String)"stonechest");
    public static DeferredHolder<Block, BlockStoneChest>[] chests = new DeferredHolder[EnumStoneChest.VALUES.length];
    public static DeferredHolder<BlockEntityType<?>, BlockEntityType<TileEntityStoneChest>> CHEST_TILE_TYPE;

    public static void register(IEventBus modEventBus) {
        for (EnumStoneChest type : EnumStoneChest.VALUES) {
            DeferredHolder chestObject;
            ITEMS.register("part_" + type.name().toLowerCase(Locale.ENGLISH), () -> new Item(new Item.Properties()));
            String name = "chest_" + type.name().toLowerCase(Locale.ENGLISH);
            SCRegistry.chests[type.ordinal()] = chestObject = BLOCKS.register(name, () -> new BlockStoneChest(type));
            ITEMS.register(name, () -> new BlockItem((Block)chestObject.get(), new Item.Properties()){

                public void initializeClient(Consumer<IClientItemExtensions> consumer) {
                    super.initializeClient(consumer);
                    consumer.accept(new IClientItemExtensions(this){

                        public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                            return TEISRStoneChest.INSTANCE;
                        }
                    });
                }
            });
        }
        CHEST_TILE_TYPE = TILE_ENTITIES.register("chest_tile", () -> BlockEntityType.Builder.of(TileEntityStoneChest::new, (Block[])((Block[])Arrays.stream(chests).map(DeferredHolder::get).toArray(Block[]::new))).build(null));
        BLOCKS.register(modEventBus);
        TILE_ENTITIES.register(modEventBus);
        ITEMS.register(modEventBus);
    }
}

