/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.structures_tweaker.cache;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.level.ChunkEvent;

public class StructureCache {
    private static final int MAX_ENTRIES_PER_DIMENSION = 1000;
    private final Map<String, StructureBoundCache> dimensionCaches = new ConcurrentHashMap<String, StructureBoundCache>();

    public void cacheStructure(Level level, BlockPos pos, ResourceLocation structure, BoundingBox bounds) {
        if (level == null || pos == null || structure == null || bounds == null) {
            return;
        }
        String dimensionKey = level.dimension().location().toString();
        StructureBoundCache cache = this.dimensionCaches.computeIfAbsent(dimensionKey, k -> new StructureBoundCache());
        if (cache.structures.size() >= 1000) {
            cache.structures.clear();
            cache.bounds.clear();
            cache.structureBounds.clear();
        }
        ChunkPos chunkPos = new ChunkPos(pos);
        cache.structures.put(chunkPos.toLong(), (Object)structure);
        cache.bounds.put(chunkPos.toLong(), (Object)bounds);
        cache.structureBounds.compute(structure, (k, v) -> {
            if (v == null) {
                return new BoundingBox[]{bounds};
            }
            BoundingBox[] newArray = new BoundingBox[((BoundingBox[])v).length + 1];
            System.arraycopy(v, 0, newArray, 0, ((BoundingBox[])v).length);
            newArray[v.length] = bounds;
            return newArray;
        });
        int minChunkX = bounds.minX() >> 4;
        int maxChunkX = bounds.maxX() >> 4;
        int minChunkZ = bounds.minZ() >> 4;
        int maxChunkZ = bounds.maxZ() >> 4;
        for (int x = minChunkX; x <= maxChunkX; ++x) {
            for (int z = minChunkZ; z <= maxChunkZ; ++z) {
                long chunkKey = ChunkPos.asLong((int)x, (int)z);
                cache.structures.put(chunkKey, (Object)structure);
                cache.bounds.put(chunkKey, (Object)bounds);
            }
        }
    }

    public ResourceLocation getStructureAt(Level level, BlockPos pos) {
        if (level == null || pos == null) {
            return null;
        }
        String dimensionKey = level.dimension().location().toString();
        StructureBoundCache cache = this.dimensionCaches.get(dimensionKey);
        if (cache == null) {
            return null;
        }
        ChunkPos chunkPos = new ChunkPos(pos);
        long chunkKey = chunkPos.toLong();
        ResourceLocation structure = (ResourceLocation)cache.structures.get(chunkKey);
        if (structure == null) {
            return null;
        }
        BoundingBox bounds = (BoundingBox)cache.bounds.get(chunkKey);
        if (bounds == null) {
            return null;
        }
        if (bounds.isInside((Vec3i)pos)) {
            return structure;
        }
        cache.structures.remove(chunkKey);
        cache.bounds.remove(chunkKey);
        return null;
    }

    @SubscribeEvent
    public void onChunkUnload(ChunkEvent.Unload event) {
        ChunkAccess chunkAccess = event.getChunk();
        if (!(chunkAccess instanceof LevelChunk)) {
            return;
        }
        LevelChunk chunk = (LevelChunk)chunkAccess;
        String dimensionKey = chunk.getLevel().dimension().location().toString();
        StructureBoundCache cache = this.dimensionCaches.get(dimensionKey);
        if (cache == null) {
            return;
        }
        long chunkKey = chunk.getPos().toLong();
        ResourceLocation structure = (ResourceLocation)cache.structures.remove(chunkKey);
        BoundingBox bounds = (BoundingBox)cache.bounds.remove(chunkKey);
        if (structure != null && bounds != null) {
            cache.structureBounds.computeIfPresent(structure, (k, v) -> {
                if (v == null || ((BoundingBox[])v).length == 0) {
                    return null;
                }
                if (((BoundingBox[])v).length == 1) {
                    return v[0] != null && v[0].equals((Object)bounds) ? null : v;
                }
                return this.removeFromArray((BoundingBox[])v, bounds);
            });
        }
    }

    private BoundingBox[] removeFromArray(BoundingBox[] array, BoundingBox toRemove) {
        if (array == null || toRemove == null) {
            return array;
        }
        return (BoundingBox[])Arrays.stream(array).filter(box -> box != null && !box.equals((Object)toRemove)).toArray(BoundingBox[]::new);
    }

    public void clearCache() {
        this.dimensionCaches.clear();
    }

    public ResourceLocation getStructureAtPosition(Level level, BlockPos pos) {
        if (level == null || pos == null) {
            return null;
        }
        String dimensionKey = level.dimension().location().toString();
        StructureBoundCache cache = this.dimensionCaches.get(dimensionKey);
        if (cache == null) {
            return null;
        }
        ChunkPos chunkPos = new ChunkPos(pos);
        List<StructureInstance> instances = cache.chunkStructures.get(chunkPos);
        if (instances != null) {
            for (StructureInstance instance : instances) {
                if (!instance.bounds.isInside((Vec3i)pos)) continue;
                return instance.structure;
            }
        }
        return this.getStructureAt(level, pos);
    }

    public void cacheStructureBounds(Level level, ResourceLocation structure, BoundingBox bounds) {
        if (level == null || structure == null || bounds == null) {
            return;
        }
        String dimensionKey = level.dimension().location().toString();
        StructureBoundCache cache = this.dimensionCaches.computeIfAbsent(dimensionKey, k -> new StructureBoundCache());
        StructureInstance instance = new StructureInstance(structure, bounds);
        int minChunkX = bounds.minX() >> 4;
        int maxChunkX = bounds.maxX() >> 4;
        int minChunkZ = bounds.minZ() >> 4;
        int maxChunkZ = bounds.maxZ() >> 4;
        for (int x = minChunkX; x <= maxChunkX; ++x) {
            for (int z = minChunkZ; z <= maxChunkZ; ++z) {
                ChunkPos chunkPos = new ChunkPos(x, z);
                cache.chunkStructures.computeIfAbsent(chunkPos, k -> Collections.synchronizedList(new ArrayList())).add(instance);
            }
        }
    }

    public BoundingBox getCachedBounds(Level level, ResourceLocation structure, BlockPos pos) {
        BoundingBox bounds;
        if (level == null || structure == null || pos == null) {
            return null;
        }
        String dimensionKey = level.dimension().location().toString();
        StructureBoundCache cache = this.dimensionCaches.get(dimensionKey);
        if (cache == null) {
            return null;
        }
        ChunkPos chunkPos = new ChunkPos(pos);
        List<StructureInstance> instances = cache.chunkStructures.get(chunkPos);
        if (instances != null) {
            for (StructureInstance instance : instances) {
                if (!instance.structure.equals((Object)structure) || !instance.bounds.isInside((Vec3i)pos)) continue;
                return instance.bounds;
            }
        }
        if ((bounds = (BoundingBox)cache.bounds.get(chunkPos.toLong())) != null && bounds.isInside((Vec3i)pos)) {
            return bounds;
        }
        return null;
    }

    public static class StructureBoundCache {
        public final Long2ObjectMap<ResourceLocation> structures = new Long2ObjectOpenHashMap();
        public final Long2ObjectMap<BoundingBox> bounds = new Long2ObjectOpenHashMap();
        final Map<ResourceLocation, BoundingBox[]> structureBounds = new ConcurrentHashMap<ResourceLocation, BoundingBox[]>();
        final Map<ChunkPos, List<StructureInstance>> chunkStructures = new ConcurrentHashMap<ChunkPos, List<StructureInstance>>();
    }

    public static class StructureInstance {
        public final ResourceLocation structure;
        public final BoundingBox bounds;

        public StructureInstance(ResourceLocation structure, BoundingBox bounds) {
            this.structure = structure;
            this.bounds = bounds;
        }
    }
}

