/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.structures_tweaker.config.core;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.leclowndu93150.structures_tweaker.config.core.ConfigDocumentationGenerator;
import com.leclowndu93150.structures_tweaker.config.core.GlobalStructureConfig;
import com.leclowndu93150.structures_tweaker.config.core.InheritedStructureConfig;
import com.leclowndu93150.structures_tweaker.config.core.ModularStructureConfig;
import com.leclowndu93150.structures_tweaker.config.core.StructureConfig;
import com.leclowndu93150.structures_tweaker.config.migration.ModularConfigMigration;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StructureConfigManager {
    private static final Path CONFIG_DIR = Path.of("config", "structures_tweaker");
    private static final Path GLOBAL_CONFIG_PATH = CONFIG_DIR.resolve("global.json");
    private final Map<ResourceLocation, StructureConfig> configCache = new ConcurrentHashMap<ResourceLocation, StructureConfig>();
    private GlobalStructureConfig globalConfig;
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private volatile boolean configsLoaded = false;
    private static final Logger LOGGER = LogManager.getLogger();
    private ConfigUpdateListener configUpdateListener;

    public void generateConfigs() {
        this.loadOrCreateGlobalConfig();
        ConfigDocumentationGenerator.generateReadmeAndDocumentation(CONFIG_DIR);
        ModularConfigMigration.migrateAllConfigs(CONFIG_DIR);
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server == null) {
            LOGGER.error("Server instance is null during config generation!");
            return;
        }
        server.registryAccess().registry(Registries.STRUCTURE).ifPresent(registry -> registry.forEach(structure -> {
            ResourceLocation id = registry.getKey(structure);
            if (id == null) {
                return;
            }
            Path configPath = CONFIG_DIR.resolve(id.getNamespace() + "/" + id.getPath() + ".json");
            try {
                Files.createDirectories(configPath.getParent(), new FileAttribute[0]);
                if (!Files.exists(configPath, new LinkOption[0])) {
                    ModularStructureConfig individualConfig = ModularConfigMigration.loadOrCreateConfig(configPath, id.getNamespace(), id.getPath());
                    IndividualConfigWrapper wrapper = new IndividualConfigWrapper(individualConfig, this.globalConfig);
                    String json = GSON.toJson((Object)wrapper);
                    Files.writeString(configPath, (CharSequence)json, new OpenOption[0]);
                }
            }
            catch (IOException e) {
                LOGGER.error("Failed to generate config for {}: {}", (Object)id, (Object)e.getMessage());
            }
        }));
    }

    public void loadConfigs() {
        this.configCache.clear();
        this.configsLoaded = false;
        this.loadOrCreateGlobalConfig();
        try {
            Files.walk(CONFIG_DIR, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.toString().endsWith(".json")).filter(path -> !path.equals(GLOBAL_CONFIG_PATH)).forEach(path -> {
                try {
                    String relativePath = CONFIG_DIR.relativize((Path)path).toString().replace('\\', '/');
                    String[] parts = relativePath.substring(0, relativePath.length() - 5).split("/", 2);
                    if (parts.length != 2) {
                        LOGGER.error("Invalid config path format: {}", (Object)relativePath);
                        return;
                    }
                    ResourceLocation id = ResourceLocation.tryParse((String)(parts[0] + ":" + parts[1]));
                    if (id == null) {
                        LOGGER.error("Invalid resource location from path: {}", (Object)relativePath);
                        return;
                    }
                    ModularStructureConfig individualConfig = ModularConfigMigration.loadOrCreateConfig(path, parts[0], parts[1]);
                    if (individualConfig != null) {
                        InheritedStructureConfig inherited = new InheritedStructureConfig(this.globalConfig, individualConfig.getExplicitlySetValues());
                        this.configCache.put(id, inherited);
                    } else {
                        LOGGER.error("Failed to parse config for {}", (Object)id);
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Unexpected error loading config {}: {}", path, (Object)e.getMessage());
                }
            });
        }
        catch (IOException e) {
            LOGGER.error("Error walking config directory: {}", (Object)e.getMessage());
        }
        this.configsLoaded = true;
        LOGGER.info("Loaded global config and {} structure configs", (Object)this.configCache.size());
    }

    public boolean isReady() {
        return this.configsLoaded;
    }

    public StructureConfig getConfig(ResourceLocation id) {
        if (!this.configsLoaded) {
            this.loadConfigs();
        }
        return this.configCache.get(id);
    }

    public Map<ResourceLocation, StructureConfig> getAllConfigs() {
        return this.configCache;
    }

    public GlobalStructureConfig getGlobalConfig() {
        return this.globalConfig;
    }

    public boolean setConfigValue(ResourceLocation structureId, String propertyKey, Object value) {
        Path configPath = CONFIG_DIR.resolve(structureId.getNamespace() + "/" + structureId.getPath() + ".json");
        try {
            ModularStructureConfig individualConfig;
            Object json;
            Files.createDirectories(configPath.getParent(), new FileAttribute[0]);
            if (Files.exists(configPath, new LinkOption[0])) {
                String content = Files.readString(configPath);
                json = JsonParser.parseString((String)content).getAsJsonObject();
                JsonObject configObject = json.has("individualOverrides") && json.get("individualOverrides").isJsonObject() ? json.getAsJsonObject("individualOverrides") : (json.has("config") && json.get("config").isJsonObject() ? json.getAsJsonObject("config") : new JsonObject());
                individualConfig = ModularStructureConfig.fromJson(configObject, false);
            } else {
                individualConfig = new ModularStructureConfig();
            }
            individualConfig.setValue(propertyKey, value);
            IndividualConfigWrapper wrapper = new IndividualConfigWrapper(individualConfig, this.globalConfig);
            json = GSON.toJson((Object)wrapper);
            Files.writeString(configPath, (CharSequence)json, new OpenOption[0]);
            InheritedStructureConfig inherited = new InheritedStructureConfig(this.globalConfig, individualConfig.getExplicitlySetValues());
            this.configCache.put(structureId, inherited);
            if (this.configUpdateListener != null) {
                this.configUpdateListener.onConfigUpdate(structureId, inherited);
            }
            LOGGER.info("Updated config for {}: {} = {}", (Object)structureId, (Object)propertyKey, value);
            return true;
        }
        catch (Exception e) {
            LOGGER.error("Failed to set config value for {}: {}", (Object)structureId, (Object)e.getMessage());
            return false;
        }
    }

    public void setConfigUpdateListener(ConfigUpdateListener listener) {
        this.configUpdateListener = listener;
    }

    private void loadOrCreateGlobalConfig() {
        try {
            Files.createDirectories(CONFIG_DIR, new FileAttribute[0]);
            if (Files.exists(GLOBAL_CONFIG_PATH, new LinkOption[0])) {
                String content = Files.readString(GLOBAL_CONFIG_PATH);
                JsonObject json = JsonParser.parseString((String)content).getAsJsonObject();
                JsonObject configObject = json.has("config") && json.get("config").isJsonObject() ? json.getAsJsonObject("config") : json;
                ModularStructureConfig modular = ModularStructureConfig.fromJson(configObject);
                this.globalConfig = new GlobalStructureConfig(modular.getAllValues());
            } else {
                this.globalConfig = new GlobalStructureConfig();
                ModularConfigMigration.ConfigWrapper wrapper = new ModularConfigMigration.ConfigWrapper(this.globalConfig);
                Files.writeString(GLOBAL_CONFIG_PATH, (CharSequence)GSON.toJson((Object)wrapper), new OpenOption[0]);
                LOGGER.info("Created default global config at {}", (Object)GLOBAL_CONFIG_PATH);
            }
        }
        catch (IOException e) {
            LOGGER.error("Failed to load/create global config: {}", (Object)e.getMessage());
            this.globalConfig = new GlobalStructureConfig();
        }
    }

    public static class IndividualConfigWrapper {
        private final Map<String, Object> individualOverrides = new HashMap<String, Object>();
        private final String note;

        public IndividualConfigWrapper(ModularStructureConfig individual, GlobalStructureConfig global) {
            this.note = "Only properties that differ from global config are saved here. See global.json for defaults.";
            for (Map.Entry<String, Object> entry : individual.getExplicitlySetValues().entrySet()) {
                this.individualOverrides.put(entry.getKey(), entry.getValue());
            }
        }
    }

    public static interface ConfigUpdateListener {
        public void onConfigUpdate(ResourceLocation var1, StructureConfig var2);
    }
}

