/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.structures_tweaker.data;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;

public class EmptyChunksData
extends SavedData {
    private final Set<Long> emptyChunks = new HashSet<Long>();

    public static EmptyChunksData get(ServerLevel level) {
        DimensionDataStorage storage = level.getDataStorage();
        return (EmptyChunksData)storage.computeIfAbsent(new SavedData.Factory(EmptyChunksData::new, (tag, provider) -> EmptyChunksData.load(tag), null), "structures_tweaker_empty_chunks");
    }

    private static EmptyChunksData load(CompoundTag tag) {
        EmptyChunksData data = new EmptyChunksData();
        ListTag list = tag.getList("empty_chunks", 4);
        for (int i = 0; i < list.size(); ++i) {
            data.emptyChunks.add(((LongTag)list.get(i)).getAsLong());
        }
        return data;
    }

    public CompoundTag save(CompoundTag tag, HolderLookup.Provider provider) {
        ListTag list = new ListTag();
        for (Long chunkPos : this.emptyChunks) {
            list.add((Object)LongTag.valueOf((long)chunkPos));
        }
        tag.put("empty_chunks", (Tag)list);
        return tag;
    }

    public void markEmpty(ChunkPos pos) {
        this.emptyChunks.add(pos.toLong());
        this.setDirty();
    }

    public boolean isEmpty(ChunkPos pos) {
        return this.emptyChunks.contains(pos.toLong());
    }

    public void clear() {
        this.emptyChunks.clear();
        this.setDirty();
    }

    @SubscribeEvent
    public static void onServerStarted(ServerStartedEvent event) {
        event.getServer().getAllLevels().forEach(level -> EmptyChunksData.get(level).clear());
    }
}

