/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.particles;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;

public class SpeakerSoundParticle
extends TextureSheetParticle {
    protected SpeakerSoundParticle(ClientLevel worldIn, double xCoordIn, double yCoordIn, double zCoordIn, double xSpeedIn, double ySpeedIn, double zSpeedIn) {
        super(worldIn, xCoordIn, yCoordIn, zCoordIn, 0.0, 0.0, 0.0);
        this.xd = 0.0;
        this.yd = 0.0;
        this.zd = 0.0;
        this.rCol = Math.max(0.0f, Mth.sin((float)(((float)xSpeedIn + 0.0f) * ((float)Math.PI * 2))) * 0.65f + 0.35f);
        this.gCol = Math.max(0.0f, Mth.sin((float)(((float)xSpeedIn + 0.33333334f) * ((float)Math.PI * 2))) * 0.65f + 0.35f);
        this.bCol = Math.max(0.0f, Mth.sin((float)(((float)xSpeedIn + 0.6666667f) * ((float)Math.PI * 2))) * 0.65f + 0.35f);
        this.quadSize *= 1.5f;
        this.lifetime = 10;
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    public float getQuadSize(float scaleFactor) {
        float i = 0.2f;
        return this.quadSize * (Mth.sin((float)((float)Math.PI * 3 * ((float)this.age / (float)this.lifetime))) * i + 1.0f - i / 2.0f);
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        } else {
            this.move(this.xd, this.yd, this.zd);
            if (this.y == this.yo) {
                this.xd *= 1.1;
                this.zd *= 1.1;
            }
            this.xd *= 0.66;
            this.yd *= 0.66;
            this.zd *= 0.66;
            if (this.onGround) {
                this.xd *= 0.7;
                this.zd *= 0.7;
            }
        }
    }

    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public Factory(SpriteSet sprite) {
            this.spriteSet = sprite;
        }

        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            SpeakerSoundParticle op = new SpeakerSoundParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed);
            op.pickSprite(this.spriteSet);
            return op;
        }
    }
}

