/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import java.util.List;
import net.mehvahdjukaar.moonlight.api.block.ItemDisplayTile;
import net.mehvahdjukaar.moonlight.api.misc.HolderRef;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.tiles.UrnBlockTile;
import net.mehvahdjukaar.supplementaries.common.entities.FallingUrnEntity;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class UrnBlock
extends FallingBlock
implements EntityBlock,
SimpleWaterloggedBlock {
    public static final MapCodec<UrnBlock> CODEC = UrnBlock.simpleCodec(UrnBlock::new);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final BooleanProperty TREASURE = ModBlockProperties.TREASURE;
    private static final VoxelShape SHAPE = Shapes.or((VoxelShape)UrnBlock.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)10.0, (double)12.0), (VoxelShape[])new VoxelShape[]{UrnBlock.box((double)5.0, (double)10.0, (double)5.0, (double)11.0, (double)12.0, (double)11.0), UrnBlock.box((double)4.0, (double)12.0, (double)4.0, (double)12.0, (double)14.0, (double)12.0)});

    public UrnBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)TREASURE, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends FallingBlock> codec() {
        return CODEC;
    }

    public int getDustColor(BlockState state, BlockGetter reader, BlockPos pos) {
        return 6173722;
    }

    public void onPlace(BlockState state, Level worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (state.getBlock() != oldState.getBlock()) {
            worldIn.scheduleTick(pos, (Block)this, this.getDelayAfterPlace());
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{WATERLOGGED, TREASURE});
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        boolean flag = context.getLevel().getFluidState(context.getClickedPos()).getType() == Fluids.WATER;
        return (BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.getValue((Property)WATERLOGGED)).booleanValue()) {
            worldIn.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)worldIn));
        }
        worldIn.scheduleTick(currentPos, (Block)this, this.getDelayAfterPlace());
        return super.updateShape(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public void tick(BlockState state, ServerLevel pLevel, BlockPos pos, RandomSource pRand) {
        if (UrnBlock.isFree((BlockState)pLevel.getBlockState(pos.below())) && pos.getY() >= pLevel.getMinBuildHeight()) {
            CompoundTag tag = null;
            BlockEntity blockEntity = pLevel.getBlockEntity(pos);
            if (blockEntity instanceof UrnBlockTile) {
                UrnBlockTile tile = (UrnBlockTile)blockEntity;
                tag = tile.saveWithoutMetadata((HolderLookup.Provider)pLevel.registryAccess());
                tile.clearContent();
                tile.setRemoved();
            }
            FallingUrnEntity fallingblockentity = FallingUrnEntity.fall((Level)pLevel, pos, state);
            ((FallingBlockEntity)fallingblockentity).blockData = tag;
            this.falling((FallingBlockEntity)fallingblockentity);
        }
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return false;
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        if (!((Boolean)pState.getValue((Property)TREASURE)).booleanValue()) {
            return new UrnBlockTile(pPos, pState);
        }
        return null;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemDisplayTile tile;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof ItemDisplayTile && (tile = (ItemDisplayTile)blockEntity).isEmpty()) {
            return tile.interactWithPlayerItem(player, hand, stack);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        Containers.dropContentsOnDestroy((BlockState)state, (BlockState)newState, (Level)level, (BlockPos)pos);
        super.onRemove(state, level, pos, newState, isMoving);
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState blockState, Level world, BlockPos pos) {
        Container tile;
        BlockEntity blockEntity;
        if (((Boolean)blockState.getValue((Property)TREASURE)).booleanValue() || (blockEntity = world.getBlockEntity(pos)) instanceof Container && !(tile = (Container)blockEntity).isEmpty()) {
            return 15;
        }
        return 0;
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        Object object = builder.getOptionalParameter(LootContextParams.BLOCK_ENTITY);
        if (object instanceof UrnBlockTile) {
            UrnBlockTile tile = (UrnBlockTile)((Object)object);
            if (!tile.hasLevel()) {
                tile.setLevel((Level)builder.getLevel());
            }
            List l = super.getDrops(state, builder);
            for (int i = 0; i < tile.getContainerSize(); ++i) {
                l.add(tile.getItem(i));
            }
            return l;
        }
        return super.getDrops(state, builder);
    }

    private static int getFortuneLevel(ItemStack stack, Level level) {
        HolderRef holder = HolderRef.of((ResourceKey)Enchantments.FORTUNE);
        return EnchantmentHelper.getItemEnchantmentLevel((Holder)holder.getHolder(level), (ItemStack)stack);
    }

    public BlockState playerWillDestroy(Level pLevel, BlockPos pPos, BlockState pState, Player pPlayer) {
        if (pLevel.isClientSide && UrnBlock.getFortuneLevel(pPlayer.getUseItem(), pPlayer.level()) == 0) {
            UrnBlock.spawnExtraBrokenParticles(pState, pPos, pLevel);
        }
        return super.playerWillDestroy(pLevel, pPos, pState, pPlayer);
    }

    public static void spawnExtraBrokenParticles(BlockState state, BlockPos pos, Level level) {
        if (level.isClientSide && ((Boolean)state.getValue((Property)TREASURE)).booleanValue()) {
            level.addDestroyBlockEffect(pos, state);
            if (level.random.nextInt(20) == 0) {
                double x = (double)pos.getX() + 0.5;
                double y = (double)pos.getY() + 0.3125;
                double z = (double)pos.getZ() + 0.5;
                level.addParticle((ParticleOptions)ParticleTypes.SOUL, x, y, z, 0.0, 0.05, 0.0);
                float f = level.random.nextFloat() * 0.4f + level.random.nextFloat() > 0.9f ? 0.6f : 0.0f;
                level.playSound(null, x, y, z, (Holder)SoundEvents.SOUL_ESCAPE, SoundSource.BLOCKS, f, 0.6f + level.random.nextFloat() * 0.4f);
            }
        }
    }

    public void onProjectileHit(Level pLevel, BlockState pState, BlockHitResult pHit, Projectile pProjectile) {
        super.onProjectileHit(pLevel, pState, pHit, pProjectile);
        BlockPos pos = pHit.getBlockPos();
        pLevel.destroyBlock(pos, true);
        UrnBlock.spawnExtraBrokenParticles(pState, pos, pLevel);
    }

    public void spawnAfterBreak(BlockState state, ServerLevel level, BlockPos pos, ItemStack stack, boolean bl) {
        super.spawnAfterBreak(state, level, pos, stack, bl);
        if (!((Boolean)state.getValue((Property)TREASURE)).booleanValue()) {
            return;
        }
        if ((double)level.random.nextFloat() < CommonConfigs.Functional.URN_ENTITY_SPAWN_CHANCE.get() && level.getGameRules().getBoolean(GameRules.RULE_DOBLOCKDROPS) && !EnchantmentHelper.hasTag((ItemStack)stack, (TagKey)EnchantmentTags.PREVENTS_INFESTED_SPAWNS)) {
            EntityType e;
            Entity entity;
            ArrayList<EntityType> list = new ArrayList<EntityType>();
            for (Holder e2 : BuiltInRegistries.ENTITY_TYPE.getTagOrEmpty(ModTags.URN_SPAWN)) {
                list.add((EntityType)e2.value());
            }
            if (!list.isEmpty() && (entity = (e = (EntityType)list.get(level.getRandom().nextInt(list.size()))).create((Level)level)) != null) {
                if (entity instanceof Slime) {
                    Slime slime = (Slime)entity;
                    slime.setSize(0, true);
                }
                entity.moveTo((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, 0.0f, 0.0f);
                level.addFreshEntity(entity);
            }
        }
    }
}

