/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.network;

import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Map;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.misc.map_data.MapLightHandler;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;

public class ClientBoundSyncAmbientLightPacket
implements Message {
    public static final CustomPacketPayload.TypeAndCodec<RegistryFriendlyByteBuf, ClientBoundSyncAmbientLightPacket> CODEC = Message.makeType((ResourceLocation)Supplementaries.res("s2c_sync_ambient_light"), ClientBoundSyncAmbientLightPacket::new);
    private final Object2IntMap<ResourceKey<Level>> ambientLight = new Object2IntArrayMap();

    public ClientBoundSyncAmbientLightPacket(RegistryAccess registryAccess) {
        for (Map.Entry d : registryAccess.registryOrThrow(Registries.DIMENSION).entrySet()) {
            Object obj = d.getValue();
            DimensionType type = null;
            if (obj instanceof LevelStem) {
                LevelStem stem = (LevelStem)obj;
                type = (DimensionType)stem.type().value();
            } else if (obj instanceof Level) {
                Level l = (Level)obj;
                type = l.dimensionType();
            }
            if (type == null) continue;
            float light = type.hasSkyLight() ? type.ambientLight() : 1.0f;
            this.ambientLight.put((Object)((ResourceKey)d.getKey()), Mth.ceil((float)(light * 15.0f)));
        }
    }

    public ClientBoundSyncAmbientLightPacket(FriendlyByteBuf buf) {
        this.ambientLight.putAll(buf.readMap(buf1 -> buf1.readResourceKey(Registries.DIMENSION), FriendlyByteBuf::readVarInt));
    }

    public void write(RegistryFriendlyByteBuf buf) {
        buf.writeMap(this.ambientLight, FriendlyByteBuf::writeResourceKey, FriendlyByteBuf::writeVarInt);
    }

    public void handle(Message.Context context) {
        MapLightHandler.setAmbientLight(this.ambientLight);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return CODEC.type();
    }
}

