/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.worldgen;

import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.blocks.AbstractRopeBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.PulleyBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.RopeBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.TurnTableBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.PulleyBlockTile;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModWorldgen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.structures.MineshaftPieces;
import net.minecraft.world.level.levelgen.structure.structures.MineshaftStructure;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import org.jetbrains.annotations.Nullable;

public class MineshaftElevatorPiece
extends MineshaftPieces.MineShaftPiece {
    private final Direction direction;
    private final byte floor;
    private final boolean hasChain;

    public MineshaftElevatorPiece(StructurePieceSerializationContext context, CompoundTag compoundTag) {
        super(ModWorldgen.MINESHAFT_ELEVATOR_PIECE.get(), compoundTag);
        this.direction = Direction.from2DDataValue((int)compoundTag.getInt("D"));
        this.floor = compoundTag.getByte("F");
        this.hasChain = compoundTag.getBoolean("C");
        this.setOrientation(this.direction);
    }

    public MineshaftElevatorPiece(int depth, BoundingBox boundingBox, @Nullable Direction direction, byte floor, boolean hasChain, MineshaftStructure.Type type) {
        super(ModWorldgen.MINESHAFT_ELEVATOR_PIECE.get(), depth, type, boundingBox);
        this.direction = direction;
        this.floor = floor;
        this.hasChain = hasChain;
        this.setOrientation(direction);
    }

    @Nullable
    public static MineshaftPieces.MineShaftPiece getElevator(StructurePieceAccessor pieces, RandomSource random, int x, int y, int z, Direction direction, int genDepth, MineshaftStructure.Type type) {
        if (y > 48) {
            return null;
        }
        if ((double)random.nextFloat() < CommonConfigs.Redstone.MINESHAFT_ELEVATOR.get() && CommonConfigs.Redstone.PULLEY_ENABLED.get().booleanValue() && CommonConfigs.Redstone.TURN_TABLE_ENABLED.get().booleanValue()) {
            int height = 12;
            int floor = random.nextInt(3);
            if (random.nextBoolean() && floor != 2) {
                ++floor;
            }
            int yOffset = floor * 4;
            BoundingBox boundingBox = switch (direction) {
                case Direction.SOUTH -> new BoundingBox(-1, -yOffset, 0, 3, height - yOffset, 4);
                case Direction.WEST -> new BoundingBox(-4, -yOffset, -1, 0, height - yOffset, 3);
                case Direction.EAST -> new BoundingBox(0, -yOffset, -1, 4, height - yOffset, 3);
                default -> new BoundingBox(-1, -yOffset, -4, 3, height - yOffset, 0);
            };
            boundingBox.move(x, y, z);
            if (pieces.findCollisionPiece(boundingBox) == null) {
                boolean hasChain = random.nextInt(5) == 0;
                return new MineshaftElevatorPiece(genDepth, boundingBox, direction, (byte)floor, hasChain, type);
            }
        }
        return null;
    }

    protected void addAdditionalSaveData(StructurePieceSerializationContext context, CompoundTag tag) {
        super.addAdditionalSaveData(context, tag);
        tag.putInt("D", this.direction.get2DDataValue());
        tag.putByte("F", this.floor);
        tag.putBoolean("C", this.hasChain);
    }

    public void addChildren(StructurePiece piece, StructurePieceAccessor pieces, RandomSource random) {
        int genDepth1 = this.getGenDepth();
        for (int i = 0; i < 3; ++i) {
            int y = this.boundingBox.minY() + i * 4;
            int c = 2 + Mth.abs((int)(i - this.floor));
            if (random.nextInt(c) != 0 && (i != this.floor || this.direction != Direction.SOUTH)) {
                MineshaftPieces.generateAndAddPiece((StructurePiece)piece, (StructurePieceAccessor)pieces, (RandomSource)random, (int)(this.boundingBox.minX() + 1), (int)y, (int)(this.boundingBox.minZ() - 1), (Direction)Direction.NORTH, (int)genDepth1);
            }
            if (random.nextInt(c) != 0 && (i != this.floor || this.direction != Direction.EAST)) {
                MineshaftPieces.generateAndAddPiece((StructurePiece)piece, (StructurePieceAccessor)pieces, (RandomSource)random, (int)(this.boundingBox.minX() - 1), (int)y, (int)(this.boundingBox.minZ() + 1), (Direction)Direction.WEST, (int)genDepth1);
            }
            if (random.nextInt(c) != 0 && (i != this.floor || this.direction != Direction.WEST)) {
                MineshaftPieces.generateAndAddPiece((StructurePiece)piece, (StructurePieceAccessor)pieces, (RandomSource)random, (int)(this.boundingBox.maxX() + 1), (int)y, (int)(this.boundingBox.minZ() + 1), (Direction)Direction.EAST, (int)genDepth1);
            }
            if (random.nextInt(c) == 0 || i == this.floor && this.direction == Direction.NORTH) continue;
            MineshaftPieces.generateAndAddPiece((StructurePiece)piece, (StructurePieceAccessor)pieces, (RandomSource)random, (int)(this.boundingBox.minX() + 1), (int)y, (int)(this.boundingBox.maxZ() + 1), (Direction)Direction.SOUTH, (int)genDepth1);
        }
    }

    public void postProcess(WorldGenLevel level, StructureManager structureManager, ChunkGenerator generator, RandomSource random, BoundingBox box, ChunkPos chunkPos, BlockPos pos) {
        if (!this.isInInvalidLocation((LevelAccessor)level, box)) {
            BlockState plank = this.type.getPlanksState();
            int minY = this.boundingBox.minY();
            int minZ = this.boundingBox.minZ();
            int maxZ = this.boundingBox.maxZ();
            int minX = this.boundingBox.minX();
            int maxX = this.boundingBox.maxX();
            for (int f = 0; f < 3; ++f) {
                int yInc = f * 4;
                this.generateBox(level, box, minX + 1, minY + yInc, minZ, maxX - 1, minY + 3 - 1 + yInc, maxZ, CAVE_AIR, CAVE_AIR, false);
                this.generateBox(level, box, minX, minY + yInc, minZ + 1, maxX, minY + 3 - 1 + yInc, maxZ - 1, CAVE_AIR, CAVE_AIR, false);
                this.generateBox(level, box, minX + 1, minY + 4 + yInc - 1, minZ + 1, maxX - 1, minY + 4 + yInc - 1, maxZ - 1, CAVE_AIR, CAVE_AIR, false);
                this.maybePlaceCobWeb(level, box, random, 0.06f, minX, minY + yInc + 2, minZ + 1);
                this.maybePlaceCobWeb(level, box, random, 0.06f, minX, minY + yInc + 2, maxZ - 1);
                this.maybePlaceCobWeb(level, box, random, 0.06f, maxX, minY + yInc + 2, minZ + 1);
                this.maybePlaceCobWeb(level, box, random, 0.06f, maxX, minY + yInc + 2, maxZ - 1);
                this.maybePlaceCobWeb(level, box, random, 0.06f, minX + 1, minY + yInc + 2, minZ);
                this.maybePlaceCobWeb(level, box, random, 0.06f, maxX - 1, minY + yInc + 2, minZ);
                this.maybePlaceCobWeb(level, box, random, 0.06f, minX + 1, minY + yInc + 2, maxZ);
                this.maybePlaceCobWeb(level, box, random, 0.06f, maxX - 1, minY + yInc + 2, maxZ);
            }
            this.generateBox(level, box, minX + 1, minY + 4 + 8, minZ + 1, maxX - 1, minY + 4 + 8, maxZ - 1, CAVE_AIR, CAVE_AIR, false);
            int maxY = this.boundingBox.maxY() - 1;
            int i = minY - 1;
            BlockState wood = this.type.getWoodState();
            boolean b1 = this.fillPillarDownOrChainUp(level, wood, minX, minZ, box);
            boolean b2 = this.fillPillarDownOrChainUp(level, wood, minX, maxZ, box);
            boolean b3 = this.fillPillarDownOrChainUp(level, wood, maxX, minZ, box);
            boolean b4 = this.fillPillarDownOrChainUp(level, wood, maxX, maxZ, box);
            if (!(b1 || b2 || b3 || b4)) {
                wood = plank;
            }
            this.placeSidePillar(level, box, minX, minY, minZ, maxY - 1, wood);
            this.placeSidePillar(level, box, minX, minY, maxZ, maxY - 1, wood);
            this.placeSidePillar(level, box, maxX, minY, minZ, maxY - 1, wood);
            this.placeSidePillar(level, box, maxX, minY, maxZ, maxY - 1, wood);
            for (int j = minX; j <= maxX; ++j) {
                for (int k = minZ; k <= maxZ; ++k) {
                    this.setPlanksBlock(level, box, plank, j, i, k);
                    if (j != minX && j != maxX && k != minZ && k != maxZ) continue;
                    this.setPlanksBlock(level, box, plank, j, i + 4, k);
                    this.setPlanksBlock(level, box, plank, j, i + 8, k);
                    this.placeBlock(level, plank, j, i + 12, k, box);
                }
            }
            this.addPulley(level, random, box, minZ, minX, maxY);
        }
    }

    private void maybePlaceCobWeb(WorldGenLevel level, BoundingBox box, RandomSource random, float chance, int x, int y, int z) {
        if (this.isInterior((LevelReader)level, x, y, z, box) && random.nextFloat() < chance && this.hasSturdyNeighbours(level, box, x, y, z, 2)) {
            this.placeBlock(level, Blocks.COBWEB.defaultBlockState(), x, y, z, box);
        }
    }

    private void placeSidePillar(WorldGenLevel level, BoundingBox box, int x, int y, int z, int maxY, BlockState state) {
        if (this.isInterior((LevelReader)level, x, y, z, box)) {
            this.generateBox(level, box, x, y, z, x, maxY, z, state, CAVE_AIR, false);
        }
    }

    protected boolean fillPillarDownOrChainUp(WorldGenLevel level, BlockState state, int x, int z, BoundingBox box) {
        int minY = this.boundingBox.minY();
        int maxY = this.boundingBox.maxY() - 1;
        if (!this.isInterior((LevelReader)level, x, minY, z, box)) {
            return false;
        }
        BlockPos.MutableBlockPos mutableBlockPos = this.getWorldPos(x, minY, z);
        int j = 1;
        boolean canKeepGoingDown = this.isReplaceableByStructures(level.getBlockState(new BlockPos(x, minY, z)));
        boolean canKeepGoingUp = this.isReplaceableByStructures(level.getBlockState(new BlockPos(x, maxY, z)));
        if (!canKeepGoingDown) {
            return canKeepGoingUp;
        }
        while (canKeepGoingDown || canKeepGoingUp) {
            boolean canBeReplaced;
            BlockState blockState;
            if (canKeepGoingDown) {
                mutableBlockPos.setY(minY - j);
                blockState = level.getBlockState((BlockPos)mutableBlockPos);
                boolean bl = canBeReplaced = this.isReplaceableByStructures(blockState) && !blockState.is(Blocks.LAVA);
                if (!canBeReplaced && blockState.isFaceSturdy((BlockGetter)level, (BlockPos)mutableBlockPos, Direction.UP)) {
                    MineshaftElevatorPiece.fillColumnBetween(level, state, mutableBlockPos, minY - j + 1, minY);
                    return true;
                }
                boolean bl2 = canKeepGoingDown = j <= 20 && canBeReplaced && mutableBlockPos.getY() > level.getMinBuildHeight() + 1;
            }
            if (canKeepGoingUp) {
                mutableBlockPos.setY(maxY + j);
                blockState = level.getBlockState((BlockPos)mutableBlockPos);
                canBeReplaced = this.isReplaceableByStructures(blockState);
                if (!canBeReplaced && this.canHangChainBelow((LevelReader)level, (BlockPos)mutableBlockPos, blockState)) {
                    level.setBlock((BlockPos)mutableBlockPos.setY(maxY + 1), this.type.getFenceState(), 2);
                    BlockState chain = maxY + 2 > MineshaftElevatorPiece.getRopeCutout() && CommonConfigs.Functional.ROPE_ENABLED.get() != false ? (BlockState)((BlockState)ModRegistry.ROPE.get().defaultBlockState().setValue((Property)RopeBlock.UP, (Comparable)Boolean.valueOf(true))).setValue((Property)RopeBlock.DOWN, (Comparable)Boolean.valueOf(true)) : Blocks.CHAIN.defaultBlockState();
                    MineshaftElevatorPiece.fillColumnBetween(level, chain, mutableBlockPos, maxY + 2, maxY + j);
                    return false;
                }
                canKeepGoingUp = j <= 50 && canBeReplaced && mutableBlockPos.getY() < level.getMaxBuildHeight() - 1;
            }
            ++j;
        }
        return false;
    }

    private boolean canHangChainBelow(LevelReader level, BlockPos pos, BlockState state) {
        return Block.canSupportCenter((LevelReader)level, (BlockPos)pos, (Direction)Direction.DOWN) && !(state.getBlock() instanceof FallingBlock);
    }

    private static void fillColumnBetween(WorldGenLevel level, BlockState state, BlockPos.MutableBlockPos pos, int minY, int maxY) {
        for (int i = minY; i < maxY; ++i) {
            level.setBlock((BlockPos)pos.setY(i), state, 2);
        }
    }

    private boolean hasSturdyNeighbours(WorldGenLevel level, BoundingBox box, int x, int y, int z, int required) {
        BlockPos.MutableBlockPos mutableBlockPos = this.getWorldPos(x, y, z);
        int i = 0;
        for (Direction direction : Direction.values()) {
            mutableBlockPos.move(direction);
            if (box.isInside((Vec3i)mutableBlockPos) && level.getBlockState((BlockPos)mutableBlockPos).isFaceSturdy((BlockGetter)level, (BlockPos)mutableBlockPos, direction.getOpposite()) && ++i >= required) {
                return true;
            }
            mutableBlockPos.move(direction.getOpposite());
        }
        return false;
    }

    public static int getRopeCutout() {
        return 22;
    }

    @Nullable
    public static BlockState getMineshaftRope() {
        Block rope = CommonConfigs.getSelectedRope();
        if (rope == null) {
            return null;
        }
        BlockState ropeState = rope.defaultBlockState();
        if (rope instanceof AbstractRopeBlock) {
            ropeState = (BlockState)((BlockState)ropeState.setValue((Property)RopeBlock.UP, (Comparable)Boolean.valueOf(true))).setValue((Property)RopeBlock.DOWN, (Comparable)Boolean.valueOf(true));
        }
        return ropeState;
    }

    private void addPulley(WorldGenLevel level, RandomSource random, BoundingBox box, int minZ, int minX, int maxY) {
        BlockEntity blockEntity;
        BlockEntity blockEntity2;
        boolean hasRope;
        BlockState wood = this.type.getWoodState();
        BlockState plank = this.type.getPlanksState();
        Direction d = this.direction;
        BlockState ropeBlock = MineshaftElevatorPiece.getMineshaftRope();
        boolean bl = hasRope = !this.hasChain && ropeBlock != null;
        if (!hasRope) {
            ropeBlock = Blocks.CHAIN.defaultBlockState();
        }
        Item ropeItem = ropeBlock.getBlock().asItem();
        BlockPos.MutableBlockPos contraptionPos = new BlockPos.MutableBlockPos(minX + 2, maxY + 1, minZ + 2);
        this.placeBlock(level, (BlockState)((BlockState)ModRegistry.PULLEY_BLOCK.get().defaultBlockState().setValue(PulleyBlock.TYPE, (Comparable)((Object)(hasRope ? ModBlockProperties.Winding.ROPE : ModBlockProperties.Winding.CHAIN)))).setValue((Property)PulleyBlock.AXIS, (Comparable)d.getAxis()), contraptionPos.getX(), contraptionPos.getY(), contraptionPos.getZ(), box);
        if (this.boundingBox.isInside((Vec3i)contraptionPos) && (blockEntity2 = level.getBlockEntity((BlockPos)contraptionPos)) instanceof PulleyBlockTile) {
            PulleyBlockTile tile = (PulleyBlockTile)blockEntity2;
            tile.setDisplayedItem(new ItemStack((ItemLike)ropeItem, 16 + random.nextInt(8)));
        }
        contraptionPos.move(d);
        Direction dOpposite = d.getOpposite();
        this.placeBlock(level, (BlockState)((BlockState)ModRegistry.TURN_TABLE.get().defaultBlockState().setValue((Property)TurnTableBlock.INVERTED, (Comparable)Boolean.valueOf(d.getAxisDirection() == Direction.AxisDirection.NEGATIVE))).setValue((Property)TurnTableBlock.FACING, (Comparable)dOpposite), contraptionPos.getX(), contraptionPos.getY(), contraptionPos.getZ(), box);
        contraptionPos.move(d.getClockWise());
        this.placeBlock(level, Blocks.TARGET.defaultBlockState(), contraptionPos.getX(), contraptionPos.getY(), contraptionPos.getZ(), box);
        contraptionPos.move(dOpposite, 2).move(d.getCounterClockWise());
        this.placeBlock(level, (BlockState)wood.setValue((Property)RotatedPillarBlock.AXIS, (Comparable)d.getAxis()), contraptionPos.getX(), contraptionPos.getY(), contraptionPos.getZ(), box);
        contraptionPos.move(dOpposite);
        this.placeBlock(level, plank, contraptionPos.getX(), contraptionPos.getY(), contraptionPos.getZ(), box);
        contraptionPos.move(d.getClockWise());
        this.placeBlock(level, plank, contraptionPos.getX(), contraptionPos.getY(), contraptionPos.getZ(), box);
        contraptionPos.move(d.getCounterClockWise(), 2);
        this.placeBlock(level, plank, contraptionPos.getX(), contraptionPos.getY(), contraptionPos.getZ(), box);
        contraptionPos.move(d, 4);
        this.placeBlock(level, plank, contraptionPos.getX(), contraptionPos.getY(), contraptionPos.getZ(), box);
        contraptionPos.move(d.getClockWise());
        this.placeBlock(level, plank, contraptionPos.getX(), contraptionPos.getY(), contraptionPos.getZ(), box);
        contraptionPos.move(d.getClockWise());
        this.placeBlock(level, plank, contraptionPos.getX(), contraptionPos.getY(), contraptionPos.getZ(), box);
        this.placeBlock(level, ropeBlock, minX + 2, maxY, minZ + 2, box);
        this.placeBlock(level, ropeBlock, minX + 2, maxY - 1, minZ + 2, box);
        BlockState chest = (hasRope ? ModRegistry.SACK.get() : Blocks.CHEST).defaultBlockState();
        this.placeBlock(level, chest, minX + 2, maxY - 2, minZ + 2, box);
        if (this.isInterior((LevelReader)level, minX + 2, maxY - 2, minZ + 2, box) && (blockEntity = level.getBlockEntity(new BlockPos(minX + 2, maxY - 2, minZ + 2))) instanceof RandomizableContainerBlockEntity) {
            RandomizableContainerBlockEntity tile = (RandomizableContainerBlockEntity)blockEntity;
            tile.setLootTable(BuiltInLootTables.ABANDONED_MINESHAFT, random.nextLong());
        }
    }
}

