/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.unused;

import com.mojang.blaze3d.platform.NativeImage;
import java.io.IOException;
import java.util.HashSet;
import net.mehvahdjukaar.moonlight.api.client.texture_renderer.FrameBufferBackedDynamicTexture;
import net.mehvahdjukaar.moonlight.api.client.texture_renderer.RenderedTexturesManager;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.resources.textures.SpriteUtils;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureImage;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.Item;

public class IconGenerator {
    public static void generateIcons() {
        if (!PlatHelper.isDev() || Minecraft.getInstance().level == null) {
            return;
        }
        if (Minecraft.getInstance().level.getGameTime() % 400L != 0L) {
            return;
        }
        if (Minecraft.getInstance().level != null) {
            ResourceManager res = Minecraft.getInstance().getResourceManager();
            try {
                TextureImage plus = TextureImage.open((ResourceManager)res, (ResourceLocation)Supplementaries.res("plus"));
                TextureImage unseen = TextureImage.open((ResourceManager)res, (ResourceLocation)Supplementaries.res("unseen"));
                HashSet<Item> items = new HashSet<Item>();
                items.add(ModRegistry.PLANTER.get().asItem());
                items.add(ModRegistry.PEDESTAL.get().asItem());
                for (Item item : items) {
                    ResourceLocation id = Utils.getID((Item)item);
                    IconGenerator.makeTexture("", item, new TextureImage[0]);
                    IconGenerator.makeTexture("_unseen", item, unseen);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static void makeTexture(String postfix, Item item, TextureImage ... overlays) {
        BakedModel model = Minecraft.getInstance().getItemRenderer().getModel(item.getDefaultInstance(), null, null, 0);
        int s = model.isGui3d() ? 16 : 1;
        FrameBufferBackedDynamicTexture t = RenderedTexturesManager.requestFlatItemTexture((ResourceLocation)Utils.getID((Item)item).withSuffix(postfix), (Item)item, (int)(18 * s), nativeImage -> {
            SpriteUtils.forEachPixel((NativeImage)nativeImage, (x, y) -> {
                if (y < nativeImage.getHeight() / 2) {
                    return;
                }
                int currentColor = nativeImage.getPixelRGBA(x.intValue(), y.intValue());
                int oppositeYColor = nativeImage.getPixelRGBA(x.intValue(), nativeImage.getHeight() - 1 - y);
                nativeImage.setPixelRGBA(x.intValue(), y.intValue(), oppositeYColor);
                nativeImage.setPixelRGBA(x.intValue(), nativeImage.getHeight() - 1 - y, currentColor);
            });
            IconGenerator.addOutline(nativeImage, FastColor.ABGR32.color((int)255, (int)0), s);
            for (TextureImage plus : overlays) {
                SpriteUtils.forEachPixel((NativeImage)nativeImage, (x, y) -> {
                    int xx = -1 + x / s;
                    int yy = -1 + y / s;
                    if (xx >= plus.getImage().getWidth() || yy >= plus.getImage().getHeight() || xx < 0 || yy < 0) {
                        return;
                    }
                    int color = plus.getImage().getPixelRGBA(xx, yy);
                    if (color != 0) {
                        nativeImage.setPixelRGBA(x.intValue(), y.intValue(), color);
                    }
                });
            }
        }, (boolean)false);
        if (t.isInitialized()) {
            try {
                t.saveTextureToFile(PlatHelper.getGamePath().resolve("guide"));
            }
            catch (Exception e) {
                Supplementaries.LOGGER.error((Object)e);
            }
        }
    }

    private static void addOutline(NativeImage nativeImage, int color, int thickness) {
        int[][] temp = new int[nativeImage.getWidth()][nativeImage.getHeight()];
        SpriteUtils.forEachPixel((NativeImage)nativeImage, (x, y) -> {
            int currentColor = nativeImage.getPixelRGBA(x.intValue(), y.intValue());
            if (FastColor.ABGR32.alpha((int)currentColor) != 0) {
                for (int i = -thickness; i <= thickness; ++i) {
                    for (int j = -thickness; j <= thickness; ++j) {
                        int currentColor2;
                        if (i * i + j * j > thickness * thickness || x + i < 0 || x + i >= nativeImage.getWidth() || y + j < 0 || y + j >= nativeImage.getHeight() || FastColor.ABGR32.alpha((int)(currentColor2 = nativeImage.getPixelRGBA(x + i, y + j))) != 0) continue;
                        temp[x.intValue() + i][y.intValue() + j] = color;
                    }
                }
            }
        });
        for (int x2 = 0; x2 < nativeImage.getWidth(); ++x2) {
            for (int y2 = 0; y2 < nativeImage.getHeight(); ++y2) {
                if (temp[x2][y2] == 0) continue;
                nativeImage.setPixelRGBA(x2, y2, temp[x2][y2]);
            }
        }
    }
}

