/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.tempad.common.compat;

import com.mojang.authlib.GameProfile;
import earth.terrarium.cadmus.api.flags.Flag;
import earth.terrarium.cadmus.api.flags.FlagApi;
import earth.terrarium.cadmus.api.flags.types.BooleanFlag;
import earth.terrarium.cadmus.api.protections.Protection;
import earth.terrarium.cadmus.common.protections.Protections;
import earth.terrarium.tempad.Tempad;
import earth.terrarium.tempad.api.event.TimedoorEvent;
import earth.terrarium.tempad.common.compat.TimedoorProtection;
import earth.terrarium.tempad.common.location_handlers.AnchorPointsHandler;
import earth.terrarium.tempad.common.utils.ExtensionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.NeoForge;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0011\u001a\u00020\u0012R\"\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0013"}, d2={"Learth/terrarium/tempad/common/compat/CadmusCompat;", "", "<init>", "()V", "timedoorGameRule", "Lnet/minecraft/world/level/GameRules$Key;", "Lnet/minecraft/world/level/GameRules$BooleanValue;", "getTimedoorGameRule", "()Lnet/minecraft/world/level/GameRules$Key;", "setTimedoorGameRule", "(Lnet/minecraft/world/level/GameRules$Key;)V", "timedoorFlag", "Learth/terrarium/cadmus/api/flags/types/BooleanFlag;", "getTimedoorFlag", "()Learth/terrarium/cadmus/api/flags/types/BooleanFlag;", "setTimedoorFlag", "(Learth/terrarium/cadmus/api/flags/types/BooleanFlag;)V", "init", "", "tempad-1.21.1"})
public final class CadmusCompat {
    @NotNull
    public static final CadmusCompat INSTANCE = new CadmusCompat();
    @Nullable
    private static GameRules.Key<GameRules.BooleanValue> timedoorGameRule;
    @Nullable
    private static BooleanFlag timedoorFlag;

    private CadmusCompat() {
    }

    @Nullable
    public final GameRules.Key<GameRules.BooleanValue> getTimedoorGameRule() {
        return timedoorGameRule;
    }

    public final void setTimedoorGameRule(@Nullable GameRules.Key<GameRules.BooleanValue> key) {
        timedoorGameRule = key;
    }

    @Nullable
    public final BooleanFlag getTimedoorFlag() {
        return timedoorFlag;
    }

    public final void setTimedoorFlag(@Nullable BooleanFlag booleanFlag) {
        timedoorFlag = booleanFlag;
    }

    public final void init() {
        timedoorGameRule = GameRules.register((String)"allowTimedoorsInClaims", (GameRules.Category)GameRules.Category.MISC, (GameRules.Type)GameRules.BooleanValue.create((boolean)true));
        timedoorFlag = (BooleanFlag)FlagApi.API.register((Flag)new BooleanFlag("timedoors-summoning", Boolean.valueOf(true)));
        TimedoorProtection protection = (TimedoorProtection)Protections.register((Protection)TimedoorProtection.INSTANCE);
        NeoForge.EVENT_BUS.addListener(arg_0 -> CadmusCompat.init$lambda$0(protection, arg_0));
    }

    private static final void init$lambda$0(TimedoorProtection $protection, TimedoorEvent.Open event) {
        Intrinsics.checkNotNullParameter((Object)((Object)event), (String)"event");
        GameProfile player = event.getOpener();
        Level level = event.getEntity().level();
        MinecraftServer minecraftServer = Tempad.Companion.getServer();
        if (minecraftServer == null || (minecraftServer = minecraftServer.getLevel(event.getEntity().getTargetDimension())) == null) {
            return;
        }
        MinecraftServer targetLevel = minecraftServer;
        Intrinsics.checkNotNull((Object)level);
        BlockPos blockPos = event.getEntity().blockPosition();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"blockPosition(...)");
        boolean canOpenAtStarting = $protection.canOpenTimedoor(level, player, blockPos);
        Level level2 = (Level)targetLevel;
        BlockPos blockPos2 = BlockPos.containing((Position)((Position)event.getEntity().getTargetPos()));
        Intrinsics.checkNotNullExpressionValue((Object)blockPos2, (String)"containing(...)");
        boolean canOpenAtTarget = $protection.canOpenTimedoor(level2, player, blockPos2);
        if (!canOpenAtStarting) {
            event.fail(ExtensionsKt.getTranslatable("cadmus.protection.timedoor_summoning.starting"));
        }
        if (!canOpenAtTarget && !Intrinsics.areEqual((Object)event.getProvider(), (Object)AnchorPointsHandler.Companion.getID())) {
            event.fail(ExtensionsKt.getTranslatable("cadmus.protection.timedoor_summoning.target"));
        }
    }
}

