/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.tempad.common.registries;

import earth.terrarium.tempad.Tempad;
import earth.terrarium.tempad.TempadKt;
import earth.terrarium.tempad.api.app.AppRegistry;
import earth.terrarium.tempad.api.app.TempadApp;
import earth.terrarium.tempad.api.context.SyncableContext;
import earth.terrarium.tempad.api.tva_device.UpgradeHandler;
import earth.terrarium.tempad.api.tva_device.UpgradeHandlerKt;
import earth.terrarium.tempad.client.TempadClientKt;
import earth.terrarium.tempad.common.apps.KnowledgeRepositoryApp;
import earth.terrarium.tempad.common.apps.NewLocationApp;
import earth.terrarium.tempad.common.apps.PortalSetupApp;
import earth.terrarium.tempad.common.apps.TeleportApp;
import earth.terrarium.tempad.common.apps.TimelineApp;
import earth.terrarium.tempad.common.config.CommonConfig;
import earth.terrarium.tempad.common.registries.ModApps;
import earth.terrarium.tempad.common.registries.ModComponentsKt;
import earth.terrarium.tempad.common.registries.ModItems;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.MutableDataComponentHolder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0012\u001a\u00020\u0013R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007R\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0007R\u0011\u0010\u0010\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0007\u00a8\u0006\u0014"}, d2={"Learth/terrarium/tempad/common/registries/ModApps;", "", "<init>", "()V", "teleport", "Lnet/minecraft/resources/ResourceLocation;", "getTeleport", "()Lnet/minecraft/resources/ResourceLocation;", "portalSetup", "getPortalSetup", "newLocation", "getNewLocation", "timeline", "getTimeline", "settings", "getSettings", "guide", "getGuide", "init", "", "tempad-1.21.1"})
public final class ModApps {
    @NotNull
    public static final ModApps INSTANCE = new ModApps();
    @NotNull
    private static final ResourceLocation teleport = TempadKt.getTempadId("teleport");
    @NotNull
    private static final ResourceLocation portalSetup = TempadKt.getTempadId("portal_setup");
    @NotNull
    private static final ResourceLocation newLocation = TempadKt.getTempadId("new_location");
    @NotNull
    private static final ResourceLocation timeline = TempadKt.getTempadId("timeline");
    @NotNull
    private static final ResourceLocation settings = TempadKt.getTempadId("settings");
    @NotNull
    private static final ResourceLocation guide = ModItems.INSTANCE.getGuideKey();

    private ModApps() {
    }

    @NotNull
    public final ResourceLocation getTeleport() {
        return teleport;
    }

    @NotNull
    public final ResourceLocation getPortalSetup() {
        return portalSetup;
    }

    @NotNull
    public final ResourceLocation getNewLocation() {
        return newLocation;
    }

    @NotNull
    public final ResourceLocation getTimeline() {
        return timeline;
    }

    @NotNull
    public final ResourceLocation getSettings() {
        return settings;
    }

    @NotNull
    public final ResourceLocation getGuide() {
        return guide;
    }

    public final void init() {
        AppRegistry.INSTANCE.register(teleport, ModApps::init$lambda$0);
        AppRegistry.INSTANCE.register(portalSetup, ModApps::init$lambda$1);
        AppRegistry.INSTANCE.register(newLocation, ModApps::init$lambda$2);
        AppRegistry.INSTANCE.register(timeline, ModApps::init$lambda$3);
        AppRegistry.INSTANCE.register(settings, init.5.INSTANCE);
        AppRegistry.INSTANCE.register(guide, ModApps::init$lambda$4);
    }

    private static final TempadApp init$lambda$0(SyncableContext ctx2, boolean isStationary) {
        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
        return !isStationary ? (TempadApp)new TeleportApp(ctx2) : null;
    }

    private static final TempadApp init$lambda$1(SyncableContext ctx2, boolean isStationary) {
        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
        return isStationary ? (TempadApp)new PortalSetupApp(ctx2) : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final TempadApp init$lambda$2(SyncableContext ctx2, boolean isStationary) {
        Level level;
        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
        MinecraftServer minecraftServer = Tempad.Companion.getServer();
        if (minecraftServer != null && (minecraftServer = minecraftServer.overworld()) != null) {
            level = (Level)minecraftServer;
        } else {
            level = TempadClientKt.getClientLevel();
            if (level == null) {
                return null;
            }
        }
        Level level2 = level;
        if (!CommonConfig.allowLocationSaving) return null;
        if (isStationary) return null;
        if (level2.enabledFeatures().contains(Tempad.Companion.getFlag())) {
            UpgradeHandler upgradeHandler = UpgradeHandlerKt.getUpgrades(ctx2.getStack());
            if (upgradeHandler == null) return null;
            if (!upgradeHandler.contains(ModItems.INSTANCE.getNewLocationKey())) return null;
            boolean bl = true;
            if (!bl) return null;
        }
        TempadApp tempadApp = new NewLocationApp(ctx2);
        return tempadApp;
    }

    private static final TempadApp init$lambda$3(SyncableContext ctx2, boolean isStationary) {
        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
        return !ModComponentsKt.getTwisterEquipped((MutableDataComponentHolder)ctx2.getStack()) ? null : (TempadApp)new TimelineApp(ctx2, isStationary);
    }

    private static final TempadApp init$lambda$4(SyncableContext ctx2, boolean isStationary) {
        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
        UpgradeHandler upgradeHandler = UpgradeHandlerKt.getUpgrades(ctx2.getStack());
        return (upgradeHandler != null ? upgradeHandler.contains(ModItems.INSTANCE.getGuideKey()) : false) ? (TempadApp)new KnowledgeRepositoryApp(ctx2, isStationary) : null;
    }
}

