/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.model.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.Nullable;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import twilightforest.TwilightForestMod;
import twilightforest.client.model.entity.TrophyBlockModel;
import twilightforest.client.renderer.entity.KnightPhantomRenderer;
import twilightforest.entity.boss.KnightPhantom;

public class KnightPhantomModel
extends HumanoidModel<KnightPhantom>
implements TrophyBlockModel {
    private static final ResourceLocation PHANTOM_ARMOR_TEXTURE = TwilightForestMod.prefix("textures/models/armor/phantom_layer_1.png");
    @Nullable
    private KnightPhantom knight;
    private ModelPart helmet;

    public KnightPhantomModel(ModelPart root) {
        super(root);
        if (root.hasChild("helmet")) {
            this.helmet = root.getChild("helmet");
        }
    }

    public static LayerDefinition create() {
        MeshDefinition meshdefinition = HumanoidModel.createMesh((CubeDeformation)CubeDeformation.NONE, (float)0.0f);
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("hat", CubeListBuilder.create(), PartPose.ZERO);
        partdefinition.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(40, 16).addBox(-1.0f, -2.0f, -1.0f, 2.0f, 12.0f, 2.0f), PartPose.offset((float)-5.0f, (float)2.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("left_arm", CubeListBuilder.create().mirror().texOffs(40, 16).addBox(-1.0f, -2.0f, -1.0f, 2.0f, 12.0f, 2.0f), PartPose.offset((float)5.0f, (float)2.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().mirror().texOffs(0, 16).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 12.0f, 2.0f), PartPose.offset((float)-2.0f, (float)12.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().mirror().texOffs(0, 16).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 12.0f, 2.0f), PartPose.offset((float)2.0f, (float)12.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public static LayerDefinition createTrophy() {
        MeshDefinition meshdefinition = HumanoidModel.createMesh((CubeDeformation)CubeDeformation.NONE, (float)0.0f);
        PartDefinition partdefinition = meshdefinition.getRoot();
        CubeDeformation deformation = new CubeDeformation(0.25f);
        partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f), PartPose.offset((float)0.0f, (float)-4.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("hat", CubeListBuilder.create(), PartPose.ZERO);
        PartDefinition helm = partdefinition.addOrReplaceChild("helmet", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, deformation), PartPose.offset((float)0.0f, (float)-4.0f, (float)0.0f));
        PartDefinition rightHorn = helm.addOrReplaceChild("right_horn_1", CubeListBuilder.create().texOffs(24, 0).addBox(-5.5f, -1.5f, -1.5f, 5.0f, 3.0f, 3.0f, deformation), PartPose.offsetAndRotation((float)-4.0f, (float)-6.5f, (float)0.0f, (float)0.0f, (float)-0.43633232f, (float)0.7853982f));
        rightHorn.addOrReplaceChild("right_horn_2", CubeListBuilder.create().texOffs(54, 16).addBox(-3.5f, -1.0f, -1.0f, 3.0f, 2.0f, 2.0f, deformation), PartPose.offsetAndRotation((float)-4.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.2617994f, (float)0.7853982f));
        PartDefinition leftHorn = helm.addOrReplaceChild("left_horn_1", CubeListBuilder.create().mirror().texOffs(24, 0).addBox(0.5f, -1.5f, -1.5f, 5.0f, 3.0f, 3.0f, deformation), PartPose.offsetAndRotation((float)4.0f, (float)-6.5f, (float)0.0f, (float)0.0f, (float)0.43633232f, (float)-0.7853982f));
        leftHorn.addOrReplaceChild("left_horn_2", CubeListBuilder.create().texOffs(54, 16).addBox(0.5f, -1.0f, -1.0f, 3.0f, 2.0f, 2.0f, deformation), PartPose.offsetAndRotation((float)4.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.2617994f, (float)-0.7853982f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public void renderToBuffer(PoseStack stack, VertexConsumer builder, int light, int overlay, int color) {
        if (this.knight != null && this.knight.isChargingAtPlayer()) {
            super.renderToBuffer(stack, builder, light, overlay, color);
        }
        this.knight = null;
    }

    public void setupAnim(KnightPhantom entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.knight = entity;
        super.setupAnim((LivingEntity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        this.leftLeg.yRot = 0.0f;
        this.leftLeg.zRot = 0.0f;
        this.rightLeg.yRot = 0.0f;
        this.rightLeg.zRot = 0.0f;
        this.rightLeg.xRot = 0.2f * Mth.sin((float)(ageInTicks * 0.3f)) + 0.4f;
        this.leftLeg.xRot = 0.2f * Mth.sin((float)(ageInTicks * 0.3f)) + 0.4f;
    }

    @Override
    public void setupRotationsForTrophy(float x, float y, float z, float mouthAngle) {
        this.head.yRot = y * ((float)Math.PI / 180);
        this.helmet.xRot = this.head.xRot = z * ((float)Math.PI / 180);
        this.helmet.yRot = this.head.yRot;
    }

    @Override
    public void renderTrophy(PoseStack stack, MultiBufferSource buffer, int light, int overlay, int color, ItemDisplayContext context) {
        if (context == ItemDisplayContext.GUI) {
            stack.pushPose();
            float scale = 0.9411765f;
            stack.scale(scale, scale, scale);
            stack.translate(0.0f, -0.065f, 0.0f);
            stack.pushPose();
            stack.translate(0.0f, 0.3f, 0.0f);
            VertexConsumer armorConsumer = buffer.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)PHANTOM_ARMOR_TEXTURE));
            this.helmet.render(stack, armorConsumer, light, OverlayTexture.NO_OVERLAY, FastColor.ARGB32.colorFromFloat((float)0.0625f, (float)1.0f, (float)1.0f, (float)1.0f));
            stack.popPose();
            stack.scale(0.9090909f, 0.9090909f, 0.9090909f);
            stack.translate(0.0f, 0.25f, 0.0f);
            VertexConsumer consumer = buffer.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)KnightPhantomRenderer.TEXTURE));
            this.head.render(stack, consumer, light, overlay, color);
            stack.popPose();
        } else {
            stack.translate(0.0f, 0.25f, 0.0f);
            VertexConsumer consumer = buffer.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)KnightPhantomRenderer.TEXTURE));
            this.head.render(stack, consumer, light, overlay, color);
            stack.scale(1.1f, 1.1f, 1.1f);
            stack.translate(0.0f, 0.05f, 0.0f);
            VertexConsumer armorConsumer = buffer.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)PHANTOM_ARMOR_TEXTURE));
            this.helmet.render(stack, armorConsumer, light, OverlayTexture.NO_OVERLAY, FastColor.ARGB32.colorFromFloat((float)0.0625f, (float)1.0f, (float)1.0f, (float)1.0f));
        }
    }
}

