/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.model.entity;

import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import twilightforest.client.JappaPackReloadListener;
import twilightforest.entity.monster.PinchBeetle;

public class PinchBeetleModel
extends HierarchicalModel<PinchBeetle> {
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart rightLeg1;
    private final ModelPart rightLeg2;
    private final ModelPart rightLeg3;
    private final ModelPart leftLeg1;
    private final ModelPart leftLeg2;
    private final ModelPart leftLeg3;
    private final ModelPart rightPincer;
    private final ModelPart leftPincer;

    public PinchBeetleModel(ModelPart root) {
        this.root = root;
        this.head = root.getChild("head");
        this.leftPincer = this.head.getChild("left_pincher");
        this.rightPincer = this.head.getChild("right_pincher");
        this.rightLeg1 = root.getChild("right_leg_1");
        this.rightLeg2 = root.getChild("right_leg_2");
        this.rightLeg3 = root.getChild("right_leg_3");
        this.leftLeg1 = root.getChild("left_leg_1");
        this.leftLeg2 = root.getChild("left_leg_2");
        this.leftLeg3 = root.getChild("left_leg_3");
    }

    public static LayerDefinition checkForPack() {
        return JappaPackReloadListener.INSTANCE.isJappaPackLoaded() ? PinchBeetleModel.createJappaModel() : PinchBeetleModel.create();
    }

    private static LayerDefinition create() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -4.0f, -6.0f, 8.0f, 6.0f, 6.0f), PartPose.offset((float)0.0f, (float)19.0f, (float)-5.0f));
        head.addOrReplaceChild("right_antenna", CubeListBuilder.create().texOffs(42, 4).addBox(0.0f, -0.5f, -0.5f, 10.0f, 1.0f, 1.0f), PartPose.offsetAndRotation((float)1.0f, (float)-3.0f, (float)-5.0f, (float)0.0f, (float)1.047198f, (float)-0.296706f));
        head.addOrReplaceChild("left_antenna", CubeListBuilder.create().texOffs(42, 4).addBox(0.0f, -0.5f, -0.5f, 10.0f, 1.0f, 1.0f), PartPose.offsetAndRotation((float)-1.0f, (float)-3.0f, (float)-5.0f, (float)0.0f, (float)2.094395f, (float)0.296706f));
        head.addOrReplaceChild("right_eye", CubeListBuilder.create().texOffs(15, 12).addBox(-1.5f, -1.5f, -1.5f, 3.0f, 3.0f, 3.0f), PartPose.offset((float)-3.0f, (float)-2.0f, (float)-5.0f));
        head.addOrReplaceChild("left_eye", CubeListBuilder.create().texOffs(15, 12).addBox(-1.5f, -1.5f, -1.5f, 3.0f, 3.0f, 3.0f), PartPose.offset((float)3.0f, (float)-2.0f, (float)-5.0f));
        PartDefinition rightJaw = head.addOrReplaceChild("right_pincher", CubeListBuilder.create().texOffs(40, 6).addBox(-1.0f, -1.0f, -1.5f, 8.0f, 2.0f, 3.0f), PartPose.offsetAndRotation((float)-3.0f, (float)1.0f, (float)-6.0f, (float)0.0f, (float)2.635447f, (float)0.0f));
        PartDefinition rightJawTooth = rightJaw.addOrReplaceChild("right_pincher_top", CubeListBuilder.create().texOffs(40, 10).addBox(-1.0f, -1.0f, -1.0f, 10.0f, 2.0f, 2.0f), PartPose.offsetAndRotation((float)7.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.047197f, (float)0.0f));
        rightJawTooth.addOrReplaceChild("right_tooth_1", CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, -0.5f, 0.0f, 2.0f, 1.0f, 1.0f), PartPose.offsetAndRotation((float)9.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.5235987f, (float)0.0f));
        rightJawTooth.addOrReplaceChild("right_tooth_2", CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, -0.5f, 0.0f, 2.0f, 1.0f, 1.0f), PartPose.offsetAndRotation((float)6.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.5707963f, (float)0.0f));
        rightJawTooth.addOrReplaceChild("right_tooth_3", CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, -0.5f, -0.0f, 2.0f, 1.0f, 1.0f), PartPose.offsetAndRotation((float)3.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.5707963f, (float)0.0f));
        PartDefinition leftJaw = head.addOrReplaceChild("left_pincher", CubeListBuilder.create().texOffs(40, 6).addBox(-1.0f, -1.0f, -1.5f, 8.0f, 2.0f, 3.0f), PartPose.offsetAndRotation((float)3.0f, (float)1.0f, (float)-6.0f, (float)0.0f, (float)0.541052f, (float)0.0f));
        PartDefinition leftJawTooth = leftJaw.addOrReplaceChild("left_pincher_top", CubeListBuilder.create().texOffs(40, 10).addBox(-1.0f, -1.0f, -1.0f, 10.0f, 2.0f, 2.0f), PartPose.offsetAndRotation((float)7.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.047197f, (float)0.0f));
        leftJawTooth.addOrReplaceChild("left_tooth_1", CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, -0.5f, 0.0f, 2.0f, 1.0f, 1.0f), PartPose.offsetAndRotation((float)8.0f, (float)0.0f, (float)-1.0f, (float)0.0f, (float)0.5235987f, (float)0.0f));
        leftJawTooth.addOrReplaceChild("left_tooth_2", CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, -0.5f, 0.0f, 2.0f, 1.0f, 1.0f), PartPose.offsetAndRotation((float)7.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.5707963f, (float)0.0f));
        leftJawTooth.addOrReplaceChild("left_tooth_3", CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, -0.5f, 0.0f, 2.0f, 1.0f, 1.0f), PartPose.offsetAndRotation((float)3.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.5707963f, (float)0.0f));
        partdefinition.addOrReplaceChild("thorax", CubeListBuilder.create().texOffs(0, 22).addBox(-4.5f, -4.0f, 0.0f, 9.0f, 8.0f, 2.0f), PartPose.offset((float)0.0f, (float)18.0f, (float)-4.5f));
        partdefinition.addOrReplaceChild("connector_1", CubeListBuilder.create().texOffs(0, 12).addBox(-3.0f, -3.0f, 0.0f, 6.0f, 6.0f, 1.0f), PartPose.offset((float)0.0f, (float)18.0f, (float)-3.0f));
        partdefinition.addOrReplaceChild("connector_2", CubeListBuilder.create().texOffs(0, 12).addBox(-3.0f, -3.0f, -1.0f, 6.0f, 6.0f, 1.0f), PartPose.offset((float)0.0f, (float)18.0f, (float)-4.0f));
        partdefinition.addOrReplaceChild("rear", CubeListBuilder.create().texOffs(28, 14).addBox(-5.0f, -9.0f, -4.0f, 10.0f, 10.0f, 8.0f), PartPose.offsetAndRotation((float)0.0f, (float)18.0f, (float)7.0f, (float)1.570796f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("right_leg_1", CubeListBuilder.create().mirror().texOffs(40, 0).addBox(-9.0f, -1.0f, -1.0f, 10.0f, 2.0f, 2.0f), PartPose.offsetAndRotation((float)-4.0f, (float)21.0f, (float)4.0f, (float)0.0f, (float)0.6981317f, (float)-0.3490659f));
        partdefinition.addOrReplaceChild("left_leg_1", CubeListBuilder.create().texOffs(40, 0).addBox(-1.0f, -1.0f, -1.0f, 10.0f, 2.0f, 2.0f), PartPose.offsetAndRotation((float)4.0f, (float)21.0f, (float)4.0f, (float)0.0f, (float)-0.6981317f, (float)0.3490659f));
        partdefinition.addOrReplaceChild("right_leg_2", CubeListBuilder.create().mirror().texOffs(40, 0).addBox(-9.0f, -1.0f, -1.0f, 10.0f, 2.0f, 2.0f), PartPose.offsetAndRotation((float)-4.0f, (float)21.0f, (float)-1.0f, (float)0.0f, (float)0.2792527f, (float)-0.3490659f));
        partdefinition.addOrReplaceChild("left_leg_2", CubeListBuilder.create().texOffs(40, 0).addBox(-1.0f, -1.0f, -1.0f, 10.0f, 2.0f, 2.0f), PartPose.offsetAndRotation((float)4.0f, (float)21.0f, (float)-1.0f, (float)0.0f, (float)-0.2792527f, (float)0.3490659f));
        partdefinition.addOrReplaceChild("right_leg_3", CubeListBuilder.create().mirror().texOffs(40, 0).addBox(-9.0f, -1.0f, -1.0f, 10.0f, 2.0f, 2.0f), PartPose.offsetAndRotation((float)-4.0f, (float)21.0f, (float)-4.0f, (float)0.0f, (float)-0.2792527f, (float)-0.3490659f));
        partdefinition.addOrReplaceChild("left_leg_3", CubeListBuilder.create().texOffs(40, 0).addBox(-1.0f, -1.0f, -1.0f, 10.0f, 2.0f, 2.0f), PartPose.offsetAndRotation((float)4.0f, (float)21.0f, (float)-4.0f, (float)0.0f, (float)0.2792527f, (float)0.3490659f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    private static LayerDefinition createJappaModel() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -3.0f, -6.0f, 8.0f, 6.0f, 6.0f), PartPose.offset((float)0.0f, (float)19.0f, (float)0.0f));
        head.addOrReplaceChild("left_antenna", CubeListBuilder.create().texOffs(52, 0).addBox(0.0f, 0.0f, -10.0f, 1.0f, 0.0f, 10.0f), PartPose.offsetAndRotation((float)1.0f, (float)-3.0f, (float)-6.0f, (float)-0.43633232f, (float)-0.43633232f, (float)0.0f));
        head.addOrReplaceChild("right_antenna", CubeListBuilder.create().texOffs(48, 0).addBox(-1.0f, 0.0f, -10.0f, 1.0f, 0.0f, 10.0f), PartPose.offsetAndRotation((float)-1.0f, (float)-3.0f, (float)-6.0f, (float)-0.43633232f, (float)0.43633232f, (float)0.0f));
        head.addOrReplaceChild("left_pincher", CubeListBuilder.create().texOffs(16, 14).addBox(0.0f, 0.0f, -12.0f, 12.0f, 2.0f, 12.0f), PartPose.offsetAndRotation((float)4.0f, (float)2.0f, (float)-4.0f, (float)0.08726646f, (float)0.61086524f, (float)0.0f));
        head.addOrReplaceChild("right_pincher", CubeListBuilder.create().texOffs(16, 0).addBox(-12.0f, 0.0f, -12.0f, 12.0f, 2.0f, 12.0f), PartPose.offsetAndRotation((float)-4.0f, (float)2.0f, (float)-4.0f, (float)0.08726646f, (float)-0.61086524f, (float)0.0f));
        partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 28).addBox(-5.0f, -8.0f, -3.0f, 10.0f, 10.0f, 7.0f), PartPose.offsetAndRotation((float)0.0f, (float)19.0f, (float)8.0f, (float)1.5707964f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("right_leg_1", CubeListBuilder.create().texOffs(40, 28).addBox(-10.0f, 0.0f, -1.0f, 10.0f, 2.0f, 2.0f), PartPose.offsetAndRotation((float)-2.0f, (float)21.0f, (float)6.0f, (float)0.0f, (float)0.61086524f, (float)-0.17453292f));
        partdefinition.addOrReplaceChild("right_leg_2", CubeListBuilder.create().texOffs(40, 32).addBox(-10.0f, 0.0f, -1.0f, 10.0f, 2.0f, 2.0f), PartPose.offsetAndRotation((float)-2.0f, (float)21.0f, (float)4.0f, (float)0.0f, (float)0.20943952f, (float)-0.17453292f));
        partdefinition.addOrReplaceChild("right_leg_3", CubeListBuilder.create().texOffs(40, 36).addBox(-10.0f, 0.0f, -1.0f, 10.0f, 2.0f, 2.0f), PartPose.offsetAndRotation((float)-2.0f, (float)21.0f, (float)2.0f, (float)0.0f, (float)-0.20943952f, (float)-0.17453292f));
        partdefinition.addOrReplaceChild("left_leg_1", CubeListBuilder.create().texOffs(40, 42).addBox(0.0f, 0.0f, -1.0f, 10.0f, 2.0f, 2.0f), PartPose.offsetAndRotation((float)2.0f, (float)21.0f, (float)6.0f, (float)0.0f, (float)-0.61086524f, (float)0.17453292f));
        partdefinition.addOrReplaceChild("left_leg_2", CubeListBuilder.create().texOffs(40, 46).addBox(0.0f, 0.0f, -1.0f, 10.0f, 2.0f, 2.0f), PartPose.offsetAndRotation((float)2.0f, (float)21.0f, (float)4.0f, (float)0.0f, (float)-0.20943952f, (float)0.17453292f));
        partdefinition.addOrReplaceChild("left_leg_3", CubeListBuilder.create().texOffs(40, 50).addBox(0.0f, 0.0f, -1.0f, 10.0f, 2.0f, 2.0f), PartPose.offsetAndRotation((float)2.0f, (float)21.0f, (float)2.0f, (float)0.0f, (float)0.20943952f, (float)0.17453292f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public ModelPart root() {
        return this.root;
    }

    public void setupAnim(PinchBeetle entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float legZ;
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        this.leftLeg1.zRot = legZ = 0.28559935f;
        this.rightLeg1.zRot = -legZ;
        this.leftLeg2.zRot = legZ * 0.74f;
        this.rightLeg2.zRot = -legZ * 0.74f;
        this.leftLeg3.zRot = legZ;
        this.rightLeg3.zRot = -legZ;
        float var9 = -0.0f;
        float var10 = 0.3926991f;
        this.leftLeg1.yRot = -var10 * 2.0f + var9;
        this.rightLeg1.yRot = var10 * 2.0f - var9;
        this.leftLeg2.yRot = var10 + var9;
        this.rightLeg2.yRot = -var10 - var9;
        this.leftLeg3.yRot = var10 * 2.0f + var9;
        this.rightLeg3.yRot = -var10 * 2.0f - var9;
        float var11 = -(Mth.cos((float)(limbSwing * 0.6662f * 2.0f + 0.0f)) * 0.4f) * limbSwingAmount;
        float var12 = -(Mth.cos((float)(limbSwing * 0.6662f * 2.0f + (float)Math.PI)) * 0.4f) * limbSwingAmount;
        float var14 = -(Mth.cos((float)(limbSwing * 0.6662f * 2.0f + 4.712389f)) * 0.4f) * limbSwingAmount;
        float var15 = Math.abs(Mth.sin((float)(limbSwing * 0.6662f + 0.0f)) * 0.4f) * limbSwingAmount;
        float var16 = Math.abs(Mth.sin((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.4f) * limbSwingAmount;
        float var18 = Math.abs(Mth.sin((float)(limbSwing * 0.6662f + 4.712389f)) * 0.4f) * limbSwingAmount;
        this.leftLeg1.yRot += var11;
        this.rightLeg1.yRot -= var11;
        this.leftLeg2.yRot += var12;
        this.rightLeg2.yRot -= var12;
        this.leftLeg3.yRot += var14;
        this.rightLeg3.yRot -= var14;
        this.leftLeg1.zRot += var15;
        this.rightLeg1.zRot -= var15;
        this.leftLeg2.zRot += var16;
        this.rightLeg2.zRot -= var16;
        this.leftLeg3.zRot += var18;
        this.rightLeg3.zRot -= var18;
    }

    public void prepareMobModel(PinchBeetle entity, float limbSwing, float limbSwingAmount, float partialTicks) {
        if (entity.isVehicle()) {
            this.rightPincer.yRot = -(JappaPackReloadListener.INSTANCE.isJappaPackLoaded() ? 20.0f : 170.0f) * ((float)Math.PI / 180);
            this.leftPincer.yRot = 0.34906584f;
        } else {
            this.rightPincer.yRot = (JappaPackReloadListener.INSTANCE.isJappaPackLoaded() ? -45.0f : 135.0f) * ((float)Math.PI / 180);
            this.leftPincer.yRot = 0.7853982f;
        }
    }
}

