/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.model.entity;

import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Mob;

public class TFGhastModel<T extends Mob>
extends HierarchicalModel<T> {
    protected static final int tentacleCount = 9;
    private final ModelPart root;
    private final ModelPart body;
    private final ModelPart[] tentacles = new ModelPart[9];

    public TFGhastModel(ModelPart root) {
        this.root = root;
        this.body = this.root.getChild("body");
        for (int i = 0; i < this.tentacles.length; ++i) {
            this.tentacles[i] = this.body.getChild("tentacle_" + i);
        }
    }

    public static LayerDefinition create() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-8.0f, -8.0f, -8.0f, 16.0f, 16.0f, 16.0f), PartPose.offset((float)0.0f, (float)8.0f, (float)0.0f));
        RandomSource rand = RandomSource.create((long)1660L);
        for (int i = 0; i < 9; ++i) {
            TFGhastModel.makeTentacle(body, "tentacle_" + i, rand, i);
        }
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public ModelPart root() {
        return this.root;
    }

    private static void makeTentacle(PartDefinition parent, String name, RandomSource random, int i) {
        float length = (float)random.nextInt(7) + 8.0f;
        float xPoint = (((float)(i % 3) - (float)i / 3.0f % 2.0f * 0.5f + 0.25f) / 2.0f * 2.0f - 1.0f) * 5.0f;
        float zPoint = (float)(i % 3 - i) * 1.5f + 4.0f;
        parent.addOrReplaceChild(name, CubeListBuilder.create().addBox(-1.0f, 0.0f, -1.0f, 2.0f, length, 2.0f), PartPose.offset((float)xPoint, (float)7.0f, (float)zPoint));
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        for (int i = 0; i < this.tentacles.length; ++i) {
            this.tentacles[i].xRot = 0.2f * Mth.sin((float)(ageInTicks * 0.3f + (float)i)) + 0.4f;
        }
        this.body.xRot = headPitch * ((float)Math.PI / 180);
        this.body.yRot = netHeadYaw * ((float)Math.PI / 180);
    }
}

