/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.model.entity;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import twilightforest.client.JappaPackReloadListener;
import twilightforest.entity.passive.TinyBird;

public class TinyBirdModel
extends AgeableListModel<TinyBird> {
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart rightFoot;
    private final ModelPart leftFoot;
    private final ModelPart rightWing;
    private final ModelPart leftWing;

    public TinyBirdModel(ModelPart root) {
        this.head = root.getChild("head");
        this.body = root.getChild("body");
        this.rightFoot = root.getChild("right_foot");
        this.leftFoot = root.getChild("left_foot");
        this.rightWing = this.body.getChild("right_wing");
        this.leftWing = this.body.getChild("left_wing");
    }

    public static LayerDefinition checkForPack() {
        return JappaPackReloadListener.INSTANCE.isJappaPackLoaded() ? TinyBirdModel.createJappaModel() : TinyBirdModel.create();
    }

    private static LayerDefinition create() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-1.5f, -1.5f, -1.5f, 3.0f, 3.0f, 3.0f), PartPose.offset((float)0.0f, (float)20.5f, (float)-0.5f));
        head.addOrReplaceChild("beak", CubeListBuilder.create().texOffs(12, 0).addBox(-0.5f, -0.5f, -0.5f, 1.0f, 1.0f, 1.0f), PartPose.offset((float)0.0f, (float)0.5f, (float)-2.0f));
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 6).addBox(-1.5f, 0.0f, -1.0f, 3.0f, 3.0f, 3.0f), PartPose.offset((float)0.0f, (float)20.0f, (float)0.0f));
        body.addOrReplaceChild("right_wing", CubeListBuilder.create().texOffs(12, 2).addBox(-1.0f, 0.0f, -1.5f, 1.0f, 2.0f, 3.0f), PartPose.offset((float)-1.5f, (float)0.5f, (float)1.0f));
        body.addOrReplaceChild("left_wing", CubeListBuilder.create().mirror().texOffs(12, 2).addBox(0.0f, 0.0f, -1.5f, 1.0f, 2.0f, 3.0f), PartPose.offset((float)1.5f, (float)0.5f, (float)1.0f));
        partdefinition.addOrReplaceChild("right_foot", CubeListBuilder.create().texOffs(0, 12).addBox(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f), PartPose.offset((float)-1.5f, (float)23.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("left_foot", CubeListBuilder.create().mirror().texOffs(0, 12).addBox(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f), PartPose.offset((float)0.0f, (float)23.0f, (float)0.0f));
        body.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(0, 14).addBox(-1.5f, -0.5f, 0.0f, 3.0f, 1.0f, 2.0f), PartPose.offset((float)0.0f, (float)2.0f, (float)2.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    private static LayerDefinition createJappaModel() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-1.5f, -2.0f, -2.0f, 3.0f, 3.0f, 3.0f).texOffs(9, 0).addBox(-0.5f, 0.0f, -3.0f, 1.0f, 1.0f, 1.0f).texOffs(0, 6).addBox(-1.5f, -5.0f, 1.0f, 3.0f, 3.0f, 0.0f), PartPose.offset((float)0.0f, (float)21.0f, (float)0.0f));
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(12, 0).addBox(-1.5f, 0.0f, 0.0f, 3.0f, 3.0f, 3.0f), PartPose.offset((float)0.0f, (float)20.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("right_foot", CubeListBuilder.create().texOffs(0, 9).addBox(-0.5f, 0.0f, -1.0f, 1.0f, 1.0f, 1.0f), PartPose.offset((float)-1.0f, (float)23.0f, (float)2.0f));
        partdefinition.addOrReplaceChild("left_foot", CubeListBuilder.create().texOffs(0, 11).addBox(-0.5f, 0.0f, -1.0f, 1.0f, 1.0f, 1.0f), PartPose.offset((float)1.0f, (float)23.0f, (float)2.0f));
        body.addOrReplaceChild("right_wing", CubeListBuilder.create().texOffs(24, 0).addBox(-0.5f, 0.0f, -1.0f, 1.0f, 2.0f, 3.0f), PartPose.offset((float)-2.0f, (float)0.0f, (float)1.0f));
        body.addOrReplaceChild("left_wing", CubeListBuilder.create().texOffs(24, 5).addBox(-0.5f, 0.0f, -1.0f, 1.0f, 2.0f, 3.0f), PartPose.offset((float)2.0f, (float)0.0f, (float)1.0f));
        body.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(1, 6).addBox(-2.5f, 0.0f, 0.0f, 5.0f, 0.0f, 5.0f), PartPose.offsetAndRotation((float)0.0f, (float)1.0f, (float)3.0f, (float)0.43633232f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    protected Iterable<ModelPart> headParts() {
        return ImmutableList.of((Object)this.head);
    }

    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.head, (Object)this.body, (Object)this.rightFoot, (Object)this.leftFoot);
    }

    public void renderToBuffer(PoseStack stack, VertexConsumer builder, int light, int overlay, int color) {
        if (this.young) {
            float f = 2.0f;
            stack.pushPose();
            stack.translate(0.0f, 5.0f, 0.75f);
            this.headParts().forEach(renderer -> renderer.render(stack, builder, light, overlay, color));
            stack.popPose();
            stack.pushPose();
            stack.scale(1.0f / f, 1.0f / f, 1.0f / f);
            stack.translate(0.0f, 24.0f, 0.0f);
            this.bodyParts().forEach(renderer -> renderer.render(stack, builder, light, overlay, color));
            stack.popPose();
        } else {
            this.headParts().forEach(renderer -> renderer.render(stack, builder, light, overlay, color));
            this.bodyParts().forEach(renderer -> renderer.render(stack, builder, light, overlay, color));
        }
    }

    public void setupAnim(TinyBird entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.rightFoot.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.leftFoot.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.rightWing.zRot = ageInTicks;
        this.leftWing.zRot = -ageInTicks;
        if (entity.isBirdLanded()) {
            this.rightFoot.y = 23.0f;
            this.leftFoot.y = 23.0f;
        } else {
            this.rightFoot.y = 22.5f;
            this.leftFoot.y = 22.5f;
        }
    }
}

