/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;

public class GhastTrapParticle
extends TextureSheetParticle {
    private final float reddustParticleScale;
    private final double originX;
    private final double originY;
    private final double originZ;

    public GhastTrapParticle(ClientLevel level, double x, double y, double z, double vx, double vy, double vz) {
        this(level, x, y, z, 3.0f, vx, vy, vz);
    }

    public GhastTrapParticle(ClientLevel level, double x, double y, double z, float scale, double mx, double my, double mz) {
        super(level, x + mx, y + my, z + mz, mx, my, mz);
        this.xd = mx;
        this.yd = my;
        this.zd = mz;
        this.originX = x;
        this.originY = y;
        this.originZ = z;
        float brightness = (float)Math.random() * 0.4f;
        this.rCol = 1.0f;
        this.gCol = ((float)(Math.random() * 0.2) + 0.8f) * brightness;
        this.bCol = ((float)(Math.random() * 0.2) + 0.8f) * brightness;
        this.quadSize *= 0.75f * scale;
        this.reddustParticleScale = this.quadSize;
        this.lifetime = (int)(10.0 / (Math.random() * 0.8 + 0.2));
        this.hasPhysics = true;
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    public float getQuadSize(float partialTicks) {
        float f6 = ((float)this.age + partialTicks) / (float)this.lifetime * 32.0f;
        f6 = Mth.clamp((float)f6, (float)0.0f, (float)1.0f);
        return this.reddustParticleScale * f6;
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        float proportion = (float)this.age / (float)this.lifetime;
        proportion = 1.0f - proportion;
        this.x = this.originX + this.xd * (double)proportion;
        this.y = this.originY + this.yd * (double)proportion;
        this.z = this.originZ + this.zd * (double)proportion;
        if (this.age++ >= this.lifetime) {
            this.remove();
        }
    }

    public record Factory(SpriteSet sprite) implements ParticleProvider<SimpleParticleType>
    {
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            GhastTrapParticle particle = new GhastTrapParticle(level, x, y, z, xSpeed, ySpeed, zSpeed);
            particle.setSpriteFromAge(this.sprite);
            return particle;
        }
    }
}

