/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;

public class SnowParticle
extends TextureSheetParticle {
    final float initialParticleScale;

    public SnowParticle(ClientLevel level, double x, double y, double z, double vx, double vy, double vz) {
        this(level, x, y, z, vx, vy, vz, 1.0f);
    }

    public SnowParticle(ClientLevel level, double x, double y, double z, double vx, double vy, double vz, float scale) {
        super(level, x, y, z, 0.0, 0.0, 0.0);
        this.xd *= 0.1;
        this.yd *= 0.1;
        this.zd *= 0.1;
        this.xd += vx * 0.4;
        this.yd += vy * 0.4;
        this.zd += vz * 0.4;
        this.bCol = 1.0f;
        this.gCol = 1.0f;
        this.rCol = 1.0f;
        this.quadSize *= 0.75f;
        this.quadSize *= scale;
        this.initialParticleScale = this.quadSize;
        this.lifetime = (int)(6.0 / (Math.random() * 0.8 + 0.6));
        this.lifetime = (int)((float)this.lifetime * scale);
        this.hasPhysics = true;
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        }
        this.move(this.xd, this.yd, this.zd);
        this.xd *= 0.7;
        this.yd *= 0.7;
        this.zd *= 0.7;
        this.yd -= 0.02;
        if (this.onGround) {
            this.xd *= 0.7;
            this.zd *= 0.7;
        }
    }

    public int getLightColor(float partialTicks) {
        return 0xF000F0;
    }

    public record Factory(SpriteSet sprite) implements ParticleProvider<SimpleParticleType>
    {
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            SnowParticle particle = new SnowParticle(level, x, y, z, xSpeed, ySpeed, zSpeed);
            particle.pickSprite(this.sprite);
            return particle;
        }
    }
}

