/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.renderer.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PiglinHeadModel;
import net.minecraft.client.model.SkullModel;
import net.minecraft.client.model.SkullModelBase;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RotationSegment;
import org.jetbrains.annotations.Nullable;
import twilightforest.block.AbstractSkullCandleBlock;
import twilightforest.block.LightableBlock;
import twilightforest.block.SkullCandleBlock;
import twilightforest.block.WallSkullCandleBlock;
import twilightforest.block.entity.SkullCandleBlockEntity;

public class SkullCandleRenderer<T extends SkullCandleBlockEntity>
implements BlockEntityRenderer<T> {
    private final Map<SkullBlock.Type, SkullModelBase> modelByType;
    public static final Map<SkullBlock.Type, ResourceLocation> SKIN_BY_TYPE = (Map)Util.make((Object)Maps.newHashMap(), map -> {
        map.put(SkullBlock.Types.SKELETON, ResourceLocation.withDefaultNamespace((String)"textures/entity/skeleton/skeleton.png"));
        map.put(SkullBlock.Types.WITHER_SKELETON, ResourceLocation.withDefaultNamespace((String)"textures/entity/skeleton/wither_skeleton.png"));
        map.put(SkullBlock.Types.ZOMBIE, ResourceLocation.withDefaultNamespace((String)"textures/entity/zombie/zombie.png"));
        map.put(SkullBlock.Types.CREEPER, ResourceLocation.withDefaultNamespace((String)"textures/entity/creeper/creeper.png"));
        map.put(SkullBlock.Types.PIGLIN, ResourceLocation.withDefaultNamespace((String)"textures/entity/piglin/piglin.png"));
        map.put(SkullBlock.Types.PLAYER, DefaultPlayerSkin.getDefaultTexture());
    });

    public static Map<SkullBlock.Type, SkullModelBase> createSkullRenderers(EntityModelSet set) {
        ImmutableMap.Builder map = ImmutableMap.builder();
        map.put((Object)SkullBlock.Types.SKELETON, (Object)new SkullModel(set.bakeLayer(ModelLayers.SKELETON_SKULL)));
        map.put((Object)SkullBlock.Types.WITHER_SKELETON, (Object)new SkullModel(set.bakeLayer(ModelLayers.WITHER_SKELETON_SKULL)));
        map.put((Object)SkullBlock.Types.PLAYER, (Object)new SkullModel(set.bakeLayer(ModelLayers.PLAYER_HEAD)));
        map.put((Object)SkullBlock.Types.ZOMBIE, (Object)new SkullModel(set.bakeLayer(ModelLayers.ZOMBIE_HEAD)));
        map.put((Object)SkullBlock.Types.CREEPER, (Object)new SkullModel(set.bakeLayer(ModelLayers.CREEPER_HEAD)));
        map.put((Object)SkullBlock.Types.PIGLIN, (Object)new PiglinHeadModel(set.bakeLayer(ModelLayers.PIGLIN_HEAD)));
        return map.build();
    }

    public SkullCandleRenderer(BlockEntityRendererProvider.Context context) {
        this.modelByType = SkullCandleRenderer.createSkullRenderers(context.getModelSet());
    }

    public void render(SkullCandleBlockEntity entity, float partialTicks, PoseStack stack, MultiBufferSource buffer, int light, int overlay) {
        float animationTime = entity.getAnimation(partialTicks);
        BlockState state = entity.getBlockState();
        boolean wallSkull = state.getBlock() instanceof WallSkullCandleBlock;
        Direction direction = wallSkull ? (Direction)state.getValue((Property)WallSkullCandleBlock.FACING) : null;
        int rotation = wallSkull ? RotationSegment.convertToSegment((Direction)direction.getOpposite()) : (Integer)state.getValue((Property)SkullCandleBlock.ROTATION);
        float rotDegrees = RotationSegment.convertToDegrees((int)rotation);
        SkullBlock.Type type = ((AbstractSkullCandleBlock)state.getBlock()).getType();
        SkullModelBase base = this.modelByType.get(type);
        RenderType rendertype = SkullCandleRenderer.getRenderType(type, entity.getOwnerProfile());
        SkullCandleRenderer.renderSkull(direction, rotDegrees, animationTime, stack, buffer, light, base, rendertype);
        if (direction != null) {
            stack.translate((float)(-direction.getStepX()) * 0.25f, 0.75f, (float)(-direction.getStepZ()) * 0.25f);
        } else {
            stack.translate(0.0f, 0.45f, 0.0f);
        }
        Minecraft.getInstance().getBlockRenderer().renderSingleBlock((BlockState)((BlockState)AbstractSkullCandleBlock.candleColorToCandle(AbstractSkullCandleBlock.CandleColors.colorFromInt(entity.getCandleColor())).defaultBlockState().setValue((Property)CandleBlock.CANDLES, (Comparable)Integer.valueOf(Math.max(1, (Integer)state.getValue((Property)BlockStateProperties.CANDLES))))).setValue((Property)CandleBlock.LIT, (Comparable)Boolean.valueOf(state.getValue((Property)AbstractSkullCandleBlock.LIGHTING) != LightableBlock.Lighting.NONE)), stack, buffer, light, overlay);
    }

    public static void renderSkull(@Nullable Direction direction, float pYRot, float animationTime, PoseStack stack, MultiBufferSource buffer, int light, SkullModelBase base, RenderType type) {
        stack.pushPose();
        if (direction == null) {
            stack.translate(0.5f, 0.0f, 0.5f);
        } else {
            stack.translate(0.5f - (float)direction.getStepX() * 0.25f, 0.25f, 0.5f - (float)direction.getStepZ() * 0.25f);
        }
        stack.scale(-1.0f, -1.0f, 1.0f);
        VertexConsumer consumer = buffer.getBuffer(type);
        base.setupAnim(animationTime, pYRot, 0.0f);
        base.renderToBuffer(stack, consumer, light, OverlayTexture.NO_OVERLAY);
        stack.popPose();
    }

    public static RenderType getRenderType(SkullBlock.Type type, @Nullable ResolvableProfile profile) {
        ResourceLocation resourcelocation = SKIN_BY_TYPE.get(type);
        if (type == SkullBlock.Types.PLAYER && profile != null) {
            SkinManager skinmanager = Minecraft.getInstance().getSkinManager();
            return RenderType.entityTranslucent((ResourceLocation)skinmanager.getInsecureSkin(profile.gameProfile()).texture());
        }
        return RenderType.entityCutoutNoCullZOffset((ResourceLocation)resourcelocation);
    }
}

