/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.dispenser;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import twilightforest.init.TFSounds;

public class FeatherFanDispenseBehavior
extends DefaultDispenseItemBehavior {
    boolean fired = false;

    protected ItemStack execute(BlockSource source, ItemStack stack) {
        ServerLevel level = source.level();
        BlockPos blockpos = source.pos().relative((Direction)source.state().getValue((Property)DispenserBlock.FACING));
        int damage = stack.getMaxDamage() - stack.getDamageValue();
        List thingsToPush = level.getEntitiesOfClass(LivingEntity.class, new AABB(blockpos).inflate(3.0), EntitySelector.NO_SPECTATORS);
        if (thingsToPush.size() < damage) {
            for (Entity entity : thingsToPush) {
                Vec3i lookVec = ((Direction)level.getBlockState(source.pos()).getValue((Property)DispenserBlock.FACING)).getNormal();
                if (!entity.isPushable() && !(entity instanceof ItemEntity)) continue;
                entity.setDeltaMovement((double)lookVec.getX(), (double)lookVec.getY(), (double)lookVec.getZ());
                stack.hurtAndBreak(1, level, null, item -> {});
            }
            this.fired = true;
        }
        return stack;
    }

    protected void playSound(BlockSource source) {
        if (this.fired) {
            RandomSource random = source.level().getRandom();
            source.level().playSound(null, source.pos(), (SoundEvent)TFSounds.FAN_WHOOSH.get(), SoundSource.BLOCKS, 1.0f + random.nextFloat(), random.nextFloat() * 0.7f + 0.3f);
            this.fired = false;
        } else {
            source.level().levelEvent(1001, source.pos(), 0);
        }
    }

    protected void playAnimation(BlockSource source, Direction direction) {
        BlockPos blockpos = source.pos().relative((Direction)source.state().getValue((Property)DispenserBlock.FACING));
        ServerLevel world = source.level();
        RandomSource random = world.getRandom();
        int j1 = direction.getStepX();
        int j2 = direction.getStepY();
        int k2 = direction.getStepZ();
        double d18 = (double)blockpos.getX() + (double)j1 * 0.6 + 0.5;
        double d24 = (double)blockpos.getY() + (double)j2 * 0.6 + 0.5;
        double d28 = (double)blockpos.getZ() + (double)k2 * 0.6 + 0.5;
        for (int i = 0; i < 30; ++i) {
            double d4 = random.nextDouble() * 0.2 + 0.01;
            double d6 = d18 + (double)j1 * 0.01 + (random.nextDouble() - 0.5) * (double)k2 * 0.5;
            double d8 = d24 + (double)j2 * 0.01 + (random.nextDouble() - 0.5) * (double)j2 * 0.5;
            double d30 = d28 + (double)k2 * 0.01 + (random.nextDouble() - 0.5) * (double)j1 * 0.5;
            double d9 = (double)j1 * d4 + random.nextGaussian() * 0.01;
            double d10 = (double)j2 * d4 + random.nextGaussian() * 0.01;
            double d11 = (double)k2 * d4 + random.nextGaussian() * 0.01;
            world.addParticle((ParticleOptions)ParticleTypes.CLOUD, d6, d8, d30, d9, d10, d11);
        }
    }
}

