/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.monster;

import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import twilightforest.entity.monster.CarminiteGhastguard;
import twilightforest.init.TFSounds;

public class CarminiteGhastling
extends CarminiteGhastguard {
    private boolean isMinion = false;

    public CarminiteGhastling(EntityType<? extends CarminiteGhastling> type, Level world) {
        super(type, world);
        this.wanderFactor = 4.0f;
        if (this.isMinion() && this.getAttribute(Attributes.MAX_HEALTH) != null) {
            Objects.requireNonNull(this.getAttribute(Attributes.MAX_HEALTH)).setBaseValue(6.0);
            this.setHealth(this.getMaxHealth());
        }
    }

    @Override
    public int getMaxSpawnClusterSize() {
        return 16;
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return CarminiteGhastguard.registerAttributes().add(Attributes.MAX_HEALTH, 10.0).add(Attributes.FOLLOW_RANGE, 16.0);
    }

    @Override
    protected SoundEvent getAmbientSound() {
        return (SoundEvent)TFSounds.CARMINITE_GHASTLING_AMBIENT.get();
    }

    @Override
    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)TFSounds.CARMINITE_GHASTLING_HURT.get();
    }

    @Override
    protected SoundEvent getDeathSound() {
        return (SoundEvent)TFSounds.CARMINITE_GHASTLING_DEATH.get();
    }

    @Override
    public SoundEvent getFireSound() {
        return (SoundEvent)TFSounds.CARMINITE_GHASTLING_SHOOT.get();
    }

    @Override
    public SoundEvent getWarnSound() {
        return (SoundEvent)TFSounds.CARMINITE_GHASTLING_WARN.get();
    }

    @Override
    public boolean shouldAttack(LivingEntity living) {
        ItemStack helmet = living.getItemBySlot(EquipmentSlot.HEAD);
        if (!helmet.isEmpty() && helmet.is(Items.PUMPKIN)) {
            return false;
        }
        if (living.distanceTo((Entity)this) <= 3.5f) {
            return living.hasLineOfSight((Entity)this);
        }
        Vec3 vec3d = living.getViewVector(1.0f).normalize();
        Vec3 vec3d1 = new Vec3(this.getX() - living.getX(), this.getBoundingBox().minY + (double)this.getEyeHeight() - (living.getY() + (double)living.getEyeHeight()), this.getZ() - living.getZ());
        double d0 = vec3d1.length();
        double d1 = vec3d.dot(vec3d1 = vec3d1.normalize());
        return d1 > 1.0 - 0.025 / d0 && living.hasLineOfSight((Entity)this);
    }

    public static boolean canSpawnHere(EntityType<CarminiteGhastling> entity, ServerLevelAccessor world, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return world.getDifficulty() != Difficulty.PEACEFUL && (reason == MobSpawnType.MOB_SUMMONED || Monster.isDarkEnoughToSpawn((ServerLevelAccessor)world, (BlockPos)pos, (RandomSource)random)) && CarminiteGhastling.checkMobSpawnRules(entity, (LevelAccessor)world, (MobSpawnType)reason, (BlockPos)pos, (RandomSource)random);
    }

    public void makeBossMinion() {
        this.wanderFactor = 0.005f;
        this.isMinion = true;
        this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(6.0);
        this.setHealth(this.getMaxHealth());
    }

    public boolean isMinion() {
        return this.isMinion;
    }

    @Override
    public void addAdditionalSaveData(CompoundTag compound) {
        compound.putBoolean("isMinion", this.isMinion);
        super.addAdditionalSaveData(compound);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.getBoolean("isMinion")) {
            this.makeBossMinion();
        }
    }

    public boolean isIgnoringBlockTriggers() {
        return true;
    }
}

